/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.storage.control.v2.CreateFolderRequest;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.Folder;
import com.google.storage.control.v2.GetFolderRequest;
import com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.storage.control.v2.ListFoldersRequest;
import com.google.storage.control.v2.ListFoldersResponse;
import com.google.storage.control.v2.RenameFolderMetadata;
import com.google.storage.control.v2.RenameFolderRequest;
import com.google.storage.control.v2.StorageControlClient;
import com.google.storage.control.v2.StorageLayout;
import com.google.storage.control.v2.stub.GrpcStorageControlCallableFactory;
import com.google.storage.control.v2.stub.StorageControlStub;
import com.google.storage.control.v2.stub.StorageControlStubSettings;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcStorageControlStub
extends StorageControlStub {
    private static final MethodDescriptor<CreateFolderRequest, Folder> createFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/CreateFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Folder.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteFolderRequest, Empty> deleteFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/DeleteFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetFolderRequest, Folder> getFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Folder.getDefaultInstance())).build();
    private static final MethodDescriptor<ListFoldersRequest, ListFoldersResponse> listFoldersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/ListFolders").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFoldersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFoldersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RenameFolderRequest, Operation> renameFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/RenameFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)RenameFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetStorageLayoutRequest, StorageLayout> getStorageLayoutMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetStorageLayout").setRequestMarshaller(ProtoUtils.marshaller((Message)GetStorageLayoutRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StorageLayout.getDefaultInstance())).build();
    private final UnaryCallable<CreateFolderRequest, Folder> createFolderCallable;
    private final UnaryCallable<DeleteFolderRequest, Empty> deleteFolderCallable;
    private final UnaryCallable<GetFolderRequest, Folder> getFolderCallable;
    private final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable;
    private final UnaryCallable<ListFoldersRequest, StorageControlClient.ListFoldersPagedResponse> listFoldersPagedCallable;
    private final UnaryCallable<RenameFolderRequest, Operation> renameFolderCallable;
    private final OperationCallable<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationCallable;
    private final UnaryCallable<GetStorageLayoutRequest, StorageLayout> getStorageLayoutCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate DELETE_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate LIST_FOLDERS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate RENAME_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_STORAGE_LAYOUT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");

    public static final GrpcStorageControlStub create(StorageControlStubSettings settings) throws IOException {
        return new GrpcStorageControlStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcStorageControlStub create(ClientContext clientContext) throws IOException {
        return new GrpcStorageControlStub(StorageControlStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcStorageControlStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcStorageControlStub(StorageControlStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcStorageControlStub(StorageControlStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcStorageControlCallableFactory());
    }

    protected GrpcStorageControlStub(StorageControlStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", CREATE_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings deleteFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", DELETE_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listFoldersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFoldersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", LIST_FOLDERS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings renameFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(renameFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", RENAME_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getStorageLayoutTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getStorageLayoutMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_STORAGE_LAYOUT_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.createFolderCallable = callableFactory.createUnaryCallable(createFolderTransportSettings, settings.createFolderSettings(), clientContext);
        this.deleteFolderCallable = callableFactory.createUnaryCallable(deleteFolderTransportSettings, settings.deleteFolderSettings(), clientContext);
        this.getFolderCallable = callableFactory.createUnaryCallable(getFolderTransportSettings, settings.getFolderSettings(), clientContext);
        this.listFoldersCallable = callableFactory.createUnaryCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.listFoldersPagedCallable = callableFactory.createPagedCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.renameFolderCallable = callableFactory.createUnaryCallable(renameFolderTransportSettings, settings.renameFolderSettings(), clientContext);
        this.renameFolderOperationCallable = callableFactory.createOperationCallable(renameFolderTransportSettings, settings.renameFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getStorageLayoutCallable = callableFactory.createUnaryCallable(getStorageLayoutTransportSettings, settings.getStorageLayoutSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateFolderRequest, Folder> createFolderCallable() {
        return this.createFolderCallable;
    }

    @Override
    public UnaryCallable<DeleteFolderRequest, Empty> deleteFolderCallable() {
        return this.deleteFolderCallable;
    }

    @Override
    public UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.getFolderCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.listFoldersCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, StorageControlClient.ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.listFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<RenameFolderRequest, Operation> renameFolderCallable() {
        return this.renameFolderCallable;
    }

    @Override
    public OperationCallable<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationCallable() {
        return this.renameFolderOperationCallable;
    }

    @Override
    public UnaryCallable<GetStorageLayoutRequest, StorageLayout> getStorageLayoutCallable() {
        return this.getStorageLayoutCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

