/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.CreateHmacKeyRequest;
import com.google.storage.v2.CreateNotificationConfigRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteHmacKeyRequest;
import com.google.storage.v2.DeleteNotificationConfigRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetHmacKeyRequest;
import com.google.storage.v2.GetNotificationConfigRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.GetServiceAccountRequest;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListHmacKeysRequest;
import com.google.storage.v2.ListNotificationConfigsRequest;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.RestoreObjectRequest;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateHmacKeyRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import java.io.Serializable;

final class GrpcRetryAlgorithmManager
implements Serializable {
    private static final long serialVersionUID = 3084833873820431477L;
    private final StorageRetryStrategy retryStrategy;

    GrpcRetryAlgorithmManager(StorageRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    ResultRetryAlgorithm<?> idempotent() {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ComposeObjectRequest req) {
        return req.hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateHmacKeyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateNotificationConfigRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteBucketRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteHmacKeyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteNotificationConfigRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteObjectRequest req) {
        if (req.getGeneration() > 0L || req.hasIfGenerationMatch()) {
            return this.retryStrategy.getIdempotentHandler();
        }
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetHmacKeyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetIamPolicyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetNotificationConfigRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(RestoreObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetServiceAccountRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListBucketsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListHmacKeysRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListNotificationConfigsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListObjectsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(LockBucketRetentionPolicyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(QueryWriteStatusRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ReadObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(RewriteObjectRequest req) {
        return req.hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(SetIamPolicyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(StartResumableWriteRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(TestIamPermissionsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateBucketRequest req) {
        return req.hasIfMetagenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateHmacKeyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateObjectRequest req) {
        return req.hasIfMetagenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(WriteObjectRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(BidiWriteObjectRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }
}

