/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.transfermanager.DefaultQos;
import com.google.cloud.storage.transfermanager.TransferManager;
import com.google.cloud.storage.transfermanager.TransferManagerImpl;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
public final class TransferManagerConfig {
    private final int maxWorkers;
    private final int perWorkerBufferSize;
    private final boolean allowDivideAndConquerDownload;
    private final boolean allowParallelCompositeUpload;
    private final StorageOptions storageOptions;

    TransferManagerConfig(int maxWorkers, int perWorkerBufferSize, boolean allowDivideAndConquerDownload, boolean allowParallelCompositeUpload, StorageOptions storageOptions) {
        this.maxWorkers = maxWorkers;
        this.perWorkerBufferSize = perWorkerBufferSize;
        this.allowDivideAndConquerDownload = allowDivideAndConquerDownload;
        this.allowParallelCompositeUpload = allowParallelCompositeUpload;
        this.storageOptions = storageOptions;
    }

    @BetaApi
    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    @BetaApi
    public int getPerWorkerBufferSize() {
        return this.perWorkerBufferSize;
    }

    @BetaApi
    public boolean isAllowDivideAndConquerDownload() {
        return this.allowDivideAndConquerDownload;
    }

    @BetaApi
    public boolean isAllowParallelCompositeUpload() {
        return this.allowParallelCompositeUpload;
    }

    @BetaApi
    public StorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    @BetaApi
    public TransferManager getService() {
        return new TransferManagerImpl(this, DefaultQos.of(this));
    }

    @BetaApi
    public Builder toBuilder() {
        return new Builder().setAllowDivideAndConquerDownload(this.allowDivideAndConquerDownload).setAllowParallelCompositeUpload(this.allowParallelCompositeUpload).setMaxWorkers(this.maxWorkers).setPerWorkerBufferSize(this.perWorkerBufferSize).setStorageOptions(this.storageOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferManagerConfig)) {
            return false;
        }
        TransferManagerConfig that = (TransferManagerConfig)o;
        return this.maxWorkers == that.maxWorkers && this.perWorkerBufferSize == that.perWorkerBufferSize && this.allowDivideAndConquerDownload == that.allowDivideAndConquerDownload && this.allowParallelCompositeUpload == that.allowParallelCompositeUpload && Objects.equals((Object)this.storageOptions, (Object)that.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxWorkers, this.perWorkerBufferSize, this.allowDivideAndConquerDownload, this.allowParallelCompositeUpload, this.storageOptions});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxWorkers", this.maxWorkers).add("perWorkerBufferSize", this.perWorkerBufferSize).add("allowDivideAndConquerDownload", this.allowDivideAndConquerDownload).add("allowParallelCompositeUpload", this.allowParallelCompositeUpload).add("storageOptions", (Object)this.storageOptions).toString();
    }

    @BetaApi
    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private int maxWorkers = 2 * Runtime.getRuntime().availableProcessors();
        private int perWorkerBufferSize = 0x1000000;
        private boolean allowDivideAndConquerDownload = false;
        private boolean allowParallelCompositeUpload = false;
        private StorageOptions storageOptions = StorageOptions.getDefaultInstance();

        private Builder() {
        }

        @BetaApi
        public Builder setMaxWorkers(int maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        @BetaApi
        public Builder setPerWorkerBufferSize(int perWorkerBufferSize) {
            this.perWorkerBufferSize = perWorkerBufferSize;
            return this;
        }

        @BetaApi
        public Builder setAllowDivideAndConquerDownload(boolean allowDivideAndConquerDownload) {
            this.allowDivideAndConquerDownload = allowDivideAndConquerDownload;
            return this;
        }

        @BetaApi
        public Builder setAllowParallelCompositeUpload(boolean allowParallelCompositeUpload) {
            this.allowParallelCompositeUpload = allowParallelCompositeUpload;
            return this;
        }

        @BetaApi
        public Builder setStorageOptions(StorageOptions storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        @BetaApi
        public TransferManagerConfig build() {
            return new TransferManagerConfig(this.maxWorkers, this.perWorkerBufferSize, this.allowDivideAndConquerDownload, this.allowParallelCompositeUpload, this.storageOptions);
        }
    }
}

