/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.ResumableSessionFailureScenario;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSessionQueryTask
implements Callable<ResumableOperationResult<StorageObject>> {
    private final HttpClientContext context;
    private final JsonResumableWrite jsonResumableWrite;

    JsonResumableSessionQueryTask(HttpClientContext context, JsonResumableWrite jsonResumableWrite) {
        this.context = context;
        this.jsonResumableWrite = jsonResumableWrite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResumableOperationResult<@Nullable StorageObject> call() {
        HttpResponse response = null;
        String uploadId = this.jsonResumableWrite.getUploadId();
        try {
            HttpRequest req = this.context.getRequestFactory().buildPutRequest(new GenericUrl(uploadId), (HttpContent)new EmptyContent()).setParser(this.context.getObjectParser());
            req.setThrowExceptionOnExecuteError(false);
            HttpHeaders headers = req.getHeaders();
            headers.setContentRange(HttpContentRange.query().getHeaderValue());
            for (Map.Entry e : this.jsonResumableWrite.getExtraHeaders().entrySet()) {
                headers.set((String)e.getKey(), e.getValue());
            }
            response = req.execute();
            int code = response.getStatusCode();
            if (ResumableSessionFailureScenario.isOk(code)) {
                BigInteger actualSize;
                StorageObject storageObject;
                boolean isJson;
                Long contentLength = response.getHeaders().getContentLength();
                String contentType = response.getHeaders().getContentType();
                String storedContentLength = HttpClientContext.firstHeaderValue(response.getHeaders(), "x-goog-stored-content-length");
                boolean bl = isJson = contentType != null && contentType.startsWith("application/json");
                if (isJson) {
                    storageObject = (StorageObject)response.parseAs(StorageObject.class);
                    actualSize = storageObject != null ? storageObject.getSize() : null;
                } else if ((contentLength == null || contentLength == 0L) && storedContentLength != null) {
                    response.ignore();
                    actualSize = new BigInteger(storedContentLength, 10);
                    storageObject = null;
                } else {
                    response.ignore();
                    throw ResumableSessionFailureScenario.SCENARIO_0_1.toStorageException(uploadId, response, null, () -> null);
                }
                if (actualSize == null) throw ResumableSessionFailureScenario.SCENARIO_0.toStorageException(uploadId, response, null, () -> storageObject != null ? storageObject.toString() : null);
                if (storageObject != null) {
                    ResumableOperationResult<StorageObject> resumableOperationResult = ResumableOperationResult.complete(storageObject, actualSize.longValue());
                    return resumableOperationResult;
                }
                ResumableOperationResult<StorageObject> resumableOperationResult = ResumableOperationResult.incremental(actualSize.longValue());
                return resumableOperationResult;
            }
            if (ResumableSessionFailureScenario.isContinue(code)) {
                String range1 = response.getHeaders().getRange();
                if (range1 != null) {
                    ByteRangeSpec range = ByteRangeSpec.parse(range1);
                    long endOffset = range.endOffset();
                    ResumableOperationResult<StorageObject> resumableOperationResult = ResumableOperationResult.incremental(endOffset);
                    return resumableOperationResult;
                }
                ResumableOperationResult<StorageObject> range = ResumableOperationResult.incremental(0L);
                return range;
            }
            HttpResponseException cause = new HttpResponseException(response);
            String contentType = response.getHeaders().getContentType();
            Long contentLength = response.getHeaders().getContentLength();
            if (ResumableSessionFailureScenario.isOk(code)) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            if (ResumableSessionFailureScenario.isContinue(code)) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            if (contentType == null) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            if (!contentType.startsWith("text/plain")) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            if (contentLength == null) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            if (contentLength <= 0L) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            String errorMessage = cause.getContent().toLowerCase(Locale.US);
            if (!errorMessage.contains("content-range")) throw ResumableSessionFailureScenario.toStorageException(response, cause, uploadId);
            throw ResumableSessionFailureScenario.SCENARIO_5.toStorageException(uploadId, response, (Throwable)cause, () -> ((HttpResponseException)cause).getContent());
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw ResumableSessionFailureScenario.SCENARIO_0.toStorageException(uploadId, response, e);
        }
        finally {
            if (response != null) {
                try {
                    response.ignore();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

