/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.multipartupload.model.CompletedMultipartUpload;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
public final class CompleteMultipartUploadRequest {
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final CompletedMultipartUpload multipartUpload;

    private CompleteMultipartUploadRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.multipartUpload = builder.multipartUpload;
    }

    @BetaApi
    public String bucket() {
        return this.bucket;
    }

    @BetaApi
    public String key() {
        return this.key;
    }

    @BetaApi
    public String uploadId() {
        return this.uploadId;
    }

    @BetaApi
    public CompletedMultipartUpload multipartUpload() {
        return this.multipartUpload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompleteMultipartUploadRequest)) {
            return false;
        }
        CompleteMultipartUploadRequest that = (CompleteMultipartUploadRequest)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.multipartUpload, that.multipartUpload);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key, this.uploadId, this.multipartUpload);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("uploadId", (Object)this.uploadId).add("completedMultipartUpload", (Object)this.multipartUpload).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private String bucket;
        private String key;
        private String uploadId;
        private CompletedMultipartUpload multipartUpload;

        private Builder() {
        }

        @BetaApi
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @BetaApi
        public Builder multipartUpload(CompletedMultipartUpload completedMultipartUpload) {
            this.multipartUpload = completedMultipartUpload;
            return this;
        }

        @BetaApi
        public CompleteMultipartUploadRequest build() {
            return new CompleteMultipartUploadRequest(this);
        }
    }
}

