/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workstations.v1beta.CreateWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.CreateWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.CreateWorkstationRequest;
import com.google.cloud.workstations.v1beta.DeleteWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.DeleteWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.DeleteWorkstationRequest;
import com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest;
import com.google.cloud.workstations.v1beta.GenerateAccessTokenResponse;
import com.google.cloud.workstations.v1beta.GetWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.GetWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.GetWorkstationRequest;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationConfigsRequest;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationConfigsResponse;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationsRequest;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationsResponse;
import com.google.cloud.workstations.v1beta.ListWorkstationClustersRequest;
import com.google.cloud.workstations.v1beta.ListWorkstationClustersResponse;
import com.google.cloud.workstations.v1beta.ListWorkstationConfigsRequest;
import com.google.cloud.workstations.v1beta.ListWorkstationConfigsResponse;
import com.google.cloud.workstations.v1beta.ListWorkstationsRequest;
import com.google.cloud.workstations.v1beta.ListWorkstationsResponse;
import com.google.cloud.workstations.v1beta.LocationName;
import com.google.cloud.workstations.v1beta.OperationMetadata;
import com.google.cloud.workstations.v1beta.StartWorkstationRequest;
import com.google.cloud.workstations.v1beta.StopWorkstationRequest;
import com.google.cloud.workstations.v1beta.UpdateWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.UpdateWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.UpdateWorkstationRequest;
import com.google.cloud.workstations.v1beta.Workstation;
import com.google.cloud.workstations.v1beta.WorkstationCluster;
import com.google.cloud.workstations.v1beta.WorkstationClusterName;
import com.google.cloud.workstations.v1beta.WorkstationConfig;
import com.google.cloud.workstations.v1beta.WorkstationConfigName;
import com.google.cloud.workstations.v1beta.WorkstationName;
import com.google.cloud.workstations.v1beta.WorkstationsSettings;
import com.google.cloud.workstations.v1beta.stub.WorkstationsStub;
import com.google.cloud.workstations.v1beta.stub.WorkstationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class WorkstationsClient
implements BackgroundResource {
    private final WorkstationsSettings settings;
    private final WorkstationsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final WorkstationsClient create() throws IOException {
        return WorkstationsClient.create(WorkstationsSettings.newBuilder().build());
    }

    public static final WorkstationsClient create(WorkstationsSettings settings) throws IOException {
        return new WorkstationsClient(settings);
    }

    public static final WorkstationsClient create(WorkstationsStub stub) {
        return new WorkstationsClient(stub);
    }

    protected WorkstationsClient(WorkstationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WorkstationsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected WorkstationsClient(WorkstationsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final WorkstationsSettings getSettings() {
        return this.settings;
    }

    public WorkstationsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final WorkstationCluster getWorkstationCluster(WorkstationClusterName name) {
        GetWorkstationClusterRequest request = GetWorkstationClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkstationCluster(request);
    }

    public final WorkstationCluster getWorkstationCluster(String name) {
        GetWorkstationClusterRequest request = GetWorkstationClusterRequest.newBuilder().setName(name).build();
        return this.getWorkstationCluster(request);
    }

    public final WorkstationCluster getWorkstationCluster(GetWorkstationClusterRequest request) {
        return (WorkstationCluster)this.getWorkstationClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterCallable() {
        return this.stub.getWorkstationClusterCallable();
    }

    public final ListWorkstationClustersPagedResponse listWorkstationClusters(LocationName parent) {
        ListWorkstationClustersRequest request = ListWorkstationClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkstationClusters(request);
    }

    public final ListWorkstationClustersPagedResponse listWorkstationClusters(String parent) {
        ListWorkstationClustersRequest request = ListWorkstationClustersRequest.newBuilder().setParent(parent).build();
        return this.listWorkstationClusters(request);
    }

    public final ListWorkstationClustersPagedResponse listWorkstationClusters(ListWorkstationClustersRequest request) {
        return (ListWorkstationClustersPagedResponse)((Object)this.listWorkstationClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkstationClustersRequest, ListWorkstationClustersPagedResponse> listWorkstationClustersPagedCallable() {
        return this.stub.listWorkstationClustersPagedCallable();
    }

    public final UnaryCallable<ListWorkstationClustersRequest, ListWorkstationClustersResponse> listWorkstationClustersCallable() {
        return this.stub.listWorkstationClustersCallable();
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> createWorkstationClusterAsync(LocationName parent, WorkstationCluster workstationCluster, String workstationClusterId) {
        CreateWorkstationClusterRequest request = CreateWorkstationClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkstationCluster(workstationCluster).setWorkstationClusterId(workstationClusterId).build();
        return this.createWorkstationClusterAsync(request);
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> createWorkstationClusterAsync(String parent, WorkstationCluster workstationCluster, String workstationClusterId) {
        CreateWorkstationClusterRequest request = CreateWorkstationClusterRequest.newBuilder().setParent(parent).setWorkstationCluster(workstationCluster).setWorkstationClusterId(workstationClusterId).build();
        return this.createWorkstationClusterAsync(request);
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> createWorkstationClusterAsync(CreateWorkstationClusterRequest request) {
        return this.createWorkstationClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationCallable() {
        return this.stub.createWorkstationClusterOperationCallable();
    }

    public final UnaryCallable<CreateWorkstationClusterRequest, Operation> createWorkstationClusterCallable() {
        return this.stub.createWorkstationClusterCallable();
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> updateWorkstationClusterAsync(WorkstationCluster workstationCluster, FieldMask updateMask) {
        UpdateWorkstationClusterRequest request = UpdateWorkstationClusterRequest.newBuilder().setWorkstationCluster(workstationCluster).setUpdateMask(updateMask).build();
        return this.updateWorkstationClusterAsync(request);
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> updateWorkstationClusterAsync(UpdateWorkstationClusterRequest request) {
        return this.updateWorkstationClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationCallable() {
        return this.stub.updateWorkstationClusterOperationCallable();
    }

    public final UnaryCallable<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterCallable() {
        return this.stub.updateWorkstationClusterCallable();
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> deleteWorkstationClusterAsync(WorkstationClusterName name) {
        DeleteWorkstationClusterRequest request = DeleteWorkstationClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkstationClusterAsync(request);
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> deleteWorkstationClusterAsync(String name) {
        DeleteWorkstationClusterRequest request = DeleteWorkstationClusterRequest.newBuilder().setName(name).build();
        return this.deleteWorkstationClusterAsync(request);
    }

    public final OperationFuture<WorkstationCluster, OperationMetadata> deleteWorkstationClusterAsync(DeleteWorkstationClusterRequest request) {
        return this.deleteWorkstationClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationCallable() {
        return this.stub.deleteWorkstationClusterOperationCallable();
    }

    public final UnaryCallable<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterCallable() {
        return this.stub.deleteWorkstationClusterCallable();
    }

    public final WorkstationConfig getWorkstationConfig(WorkstationConfigName name) {
        GetWorkstationConfigRequest request = GetWorkstationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkstationConfig(request);
    }

    public final WorkstationConfig getWorkstationConfig(String name) {
        GetWorkstationConfigRequest request = GetWorkstationConfigRequest.newBuilder().setName(name).build();
        return this.getWorkstationConfig(request);
    }

    public final WorkstationConfig getWorkstationConfig(GetWorkstationConfigRequest request) {
        return (WorkstationConfig)this.getWorkstationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigCallable() {
        return this.stub.getWorkstationConfigCallable();
    }

    public final ListWorkstationConfigsPagedResponse listWorkstationConfigs(WorkstationClusterName parent) {
        ListWorkstationConfigsRequest request = ListWorkstationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkstationConfigs(request);
    }

    public final ListWorkstationConfigsPagedResponse listWorkstationConfigs(String parent) {
        ListWorkstationConfigsRequest request = ListWorkstationConfigsRequest.newBuilder().setParent(parent).build();
        return this.listWorkstationConfigs(request);
    }

    public final ListWorkstationConfigsPagedResponse listWorkstationConfigs(ListWorkstationConfigsRequest request) {
        return (ListWorkstationConfigsPagedResponse)((Object)this.listWorkstationConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkstationConfigsRequest, ListWorkstationConfigsPagedResponse> listWorkstationConfigsPagedCallable() {
        return this.stub.listWorkstationConfigsPagedCallable();
    }

    public final UnaryCallable<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse> listWorkstationConfigsCallable() {
        return this.stub.listWorkstationConfigsCallable();
    }

    public final ListUsableWorkstationConfigsPagedResponse listUsableWorkstationConfigs(WorkstationClusterName parent) {
        ListUsableWorkstationConfigsRequest request = ListUsableWorkstationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUsableWorkstationConfigs(request);
    }

    public final ListUsableWorkstationConfigsPagedResponse listUsableWorkstationConfigs(String parent) {
        ListUsableWorkstationConfigsRequest request = ListUsableWorkstationConfigsRequest.newBuilder().setParent(parent).build();
        return this.listUsableWorkstationConfigs(request);
    }

    public final ListUsableWorkstationConfigsPagedResponse listUsableWorkstationConfigs(ListUsableWorkstationConfigsRequest request) {
        return (ListUsableWorkstationConfigsPagedResponse)((Object)this.listUsableWorkstationConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsPagedCallable() {
        return this.stub.listUsableWorkstationConfigsPagedCallable();
    }

    public final UnaryCallable<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse> listUsableWorkstationConfigsCallable() {
        return this.stub.listUsableWorkstationConfigsCallable();
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> createWorkstationConfigAsync(WorkstationClusterName parent, WorkstationConfig workstationConfig, String workstationConfigId) {
        CreateWorkstationConfigRequest request = CreateWorkstationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkstationConfig(workstationConfig).setWorkstationConfigId(workstationConfigId).build();
        return this.createWorkstationConfigAsync(request);
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> createWorkstationConfigAsync(String parent, WorkstationConfig workstationConfig, String workstationConfigId) {
        CreateWorkstationConfigRequest request = CreateWorkstationConfigRequest.newBuilder().setParent(parent).setWorkstationConfig(workstationConfig).setWorkstationConfigId(workstationConfigId).build();
        return this.createWorkstationConfigAsync(request);
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> createWorkstationConfigAsync(CreateWorkstationConfigRequest request) {
        return this.createWorkstationConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationCallable() {
        return this.stub.createWorkstationConfigOperationCallable();
    }

    public final UnaryCallable<CreateWorkstationConfigRequest, Operation> createWorkstationConfigCallable() {
        return this.stub.createWorkstationConfigCallable();
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> updateWorkstationConfigAsync(WorkstationConfig workstationConfig, FieldMask updateMask) {
        UpdateWorkstationConfigRequest request = UpdateWorkstationConfigRequest.newBuilder().setWorkstationConfig(workstationConfig).setUpdateMask(updateMask).build();
        return this.updateWorkstationConfigAsync(request);
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> updateWorkstationConfigAsync(UpdateWorkstationConfigRequest request) {
        return this.updateWorkstationConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationCallable() {
        return this.stub.updateWorkstationConfigOperationCallable();
    }

    public final UnaryCallable<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigCallable() {
        return this.stub.updateWorkstationConfigCallable();
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> deleteWorkstationConfigAsync(WorkstationConfigName name) {
        DeleteWorkstationConfigRequest request = DeleteWorkstationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkstationConfigAsync(request);
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> deleteWorkstationConfigAsync(String name) {
        DeleteWorkstationConfigRequest request = DeleteWorkstationConfigRequest.newBuilder().setName(name).build();
        return this.deleteWorkstationConfigAsync(request);
    }

    public final OperationFuture<WorkstationConfig, OperationMetadata> deleteWorkstationConfigAsync(DeleteWorkstationConfigRequest request) {
        return this.deleteWorkstationConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationCallable() {
        return this.stub.deleteWorkstationConfigOperationCallable();
    }

    public final UnaryCallable<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigCallable() {
        return this.stub.deleteWorkstationConfigCallable();
    }

    public final Workstation getWorkstation(WorkstationName name) {
        GetWorkstationRequest request = GetWorkstationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkstation(request);
    }

    public final Workstation getWorkstation(String name) {
        GetWorkstationRequest request = GetWorkstationRequest.newBuilder().setName(name).build();
        return this.getWorkstation(request);
    }

    public final Workstation getWorkstation(GetWorkstationRequest request) {
        return (Workstation)this.getWorkstationCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkstationRequest, Workstation> getWorkstationCallable() {
        return this.stub.getWorkstationCallable();
    }

    public final ListWorkstationsPagedResponse listWorkstations(WorkstationConfigName parent) {
        ListWorkstationsRequest request = ListWorkstationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkstations(request);
    }

    public final ListWorkstationsPagedResponse listWorkstations(String parent) {
        ListWorkstationsRequest request = ListWorkstationsRequest.newBuilder().setParent(parent).build();
        return this.listWorkstations(request);
    }

    public final ListWorkstationsPagedResponse listWorkstations(ListWorkstationsRequest request) {
        return (ListWorkstationsPagedResponse)((Object)this.listWorkstationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkstationsRequest, ListWorkstationsPagedResponse> listWorkstationsPagedCallable() {
        return this.stub.listWorkstationsPagedCallable();
    }

    public final UnaryCallable<ListWorkstationsRequest, ListWorkstationsResponse> listWorkstationsCallable() {
        return this.stub.listWorkstationsCallable();
    }

    public final ListUsableWorkstationsPagedResponse listUsableWorkstations(WorkstationConfigName parent) {
        ListUsableWorkstationsRequest request = ListUsableWorkstationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUsableWorkstations(request);
    }

    public final ListUsableWorkstationsPagedResponse listUsableWorkstations(String parent) {
        ListUsableWorkstationsRequest request = ListUsableWorkstationsRequest.newBuilder().setParent(parent).build();
        return this.listUsableWorkstations(request);
    }

    public final ListUsableWorkstationsPagedResponse listUsableWorkstations(ListUsableWorkstationsRequest request) {
        return (ListUsableWorkstationsPagedResponse)((Object)this.listUsableWorkstationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsableWorkstationsRequest, ListUsableWorkstationsPagedResponse> listUsableWorkstationsPagedCallable() {
        return this.stub.listUsableWorkstationsPagedCallable();
    }

    public final UnaryCallable<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse> listUsableWorkstationsCallable() {
        return this.stub.listUsableWorkstationsCallable();
    }

    public final OperationFuture<Workstation, OperationMetadata> createWorkstationAsync(WorkstationConfigName parent, Workstation workstation, String workstationId) {
        CreateWorkstationRequest request = CreateWorkstationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkstation(workstation).setWorkstationId(workstationId).build();
        return this.createWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> createWorkstationAsync(String parent, Workstation workstation, String workstationId) {
        CreateWorkstationRequest request = CreateWorkstationRequest.newBuilder().setParent(parent).setWorkstation(workstation).setWorkstationId(workstationId).build();
        return this.createWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> createWorkstationAsync(CreateWorkstationRequest request) {
        return this.createWorkstationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationCallable() {
        return this.stub.createWorkstationOperationCallable();
    }

    public final UnaryCallable<CreateWorkstationRequest, Operation> createWorkstationCallable() {
        return this.stub.createWorkstationCallable();
    }

    public final OperationFuture<Workstation, OperationMetadata> updateWorkstationAsync(Workstation workstation, FieldMask updateMask) {
        UpdateWorkstationRequest request = UpdateWorkstationRequest.newBuilder().setWorkstation(workstation).setUpdateMask(updateMask).build();
        return this.updateWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> updateWorkstationAsync(UpdateWorkstationRequest request) {
        return this.updateWorkstationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationCallable() {
        return this.stub.updateWorkstationOperationCallable();
    }

    public final UnaryCallable<UpdateWorkstationRequest, Operation> updateWorkstationCallable() {
        return this.stub.updateWorkstationCallable();
    }

    public final OperationFuture<Workstation, OperationMetadata> deleteWorkstationAsync(WorkstationName name) {
        DeleteWorkstationRequest request = DeleteWorkstationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> deleteWorkstationAsync(String name) {
        DeleteWorkstationRequest request = DeleteWorkstationRequest.newBuilder().setName(name).build();
        return this.deleteWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> deleteWorkstationAsync(DeleteWorkstationRequest request) {
        return this.deleteWorkstationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationCallable() {
        return this.stub.deleteWorkstationOperationCallable();
    }

    public final UnaryCallable<DeleteWorkstationRequest, Operation> deleteWorkstationCallable() {
        return this.stub.deleteWorkstationCallable();
    }

    public final OperationFuture<Workstation, OperationMetadata> startWorkstationAsync(WorkstationName name) {
        StartWorkstationRequest request = StartWorkstationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> startWorkstationAsync(String name) {
        StartWorkstationRequest request = StartWorkstationRequest.newBuilder().setName(name).build();
        return this.startWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> startWorkstationAsync(StartWorkstationRequest request) {
        return this.startWorkstationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationCallable() {
        return this.stub.startWorkstationOperationCallable();
    }

    public final UnaryCallable<StartWorkstationRequest, Operation> startWorkstationCallable() {
        return this.stub.startWorkstationCallable();
    }

    public final OperationFuture<Workstation, OperationMetadata> stopWorkstationAsync(WorkstationName name) {
        StopWorkstationRequest request = StopWorkstationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> stopWorkstationAsync(String name) {
        StopWorkstationRequest request = StopWorkstationRequest.newBuilder().setName(name).build();
        return this.stopWorkstationAsync(request);
    }

    public final OperationFuture<Workstation, OperationMetadata> stopWorkstationAsync(StopWorkstationRequest request) {
        return this.stopWorkstationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationCallable() {
        return this.stub.stopWorkstationOperationCallable();
    }

    public final UnaryCallable<StopWorkstationRequest, Operation> stopWorkstationCallable() {
        return this.stub.stopWorkstationCallable();
    }

    public final GenerateAccessTokenResponse generateAccessToken(WorkstationName workstation) {
        GenerateAccessTokenRequest request = GenerateAccessTokenRequest.newBuilder().setWorkstation(workstation == null ? null : workstation.toString()).build();
        return this.generateAccessToken(request);
    }

    public final GenerateAccessTokenResponse generateAccessToken(String workstation) {
        GenerateAccessTokenRequest request = GenerateAccessTokenRequest.newBuilder().setWorkstation(workstation).build();
        return this.generateAccessToken(request);
    }

    public final GenerateAccessTokenResponse generateAccessToken(GenerateAccessTokenRequest request) {
        return (GenerateAccessTokenResponse)this.generateAccessTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable() {
        return this.stub.generateAccessTokenCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsableWorkstationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation, ListUsableWorkstationsPage, ListUsableWorkstationsFixedSizeCollection> {
        private ListUsableWorkstationsFixedSizeCollection(List<ListUsableWorkstationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableWorkstationsFixedSizeCollection createEmptyCollection() {
            return new ListUsableWorkstationsFixedSizeCollection(null, 0);
        }

        protected ListUsableWorkstationsFixedSizeCollection createCollection(List<ListUsableWorkstationsPage> pages, int collectionSize) {
            return new ListUsableWorkstationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsableWorkstationsPage
    extends AbstractPage<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation, ListUsableWorkstationsPage> {
        private ListUsableWorkstationsPage(PageContext<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation> context, ListUsableWorkstationsResponse response) {
            super(context, (Object)response);
        }

        private static ListUsableWorkstationsPage createEmptyPage() {
            return new ListUsableWorkstationsPage(null, null);
        }

        protected ListUsableWorkstationsPage createPage(PageContext<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation> context, ListUsableWorkstationsResponse response) {
            return new ListUsableWorkstationsPage(context, response);
        }

        public ApiFuture<ListUsableWorkstationsPage> createPageAsync(PageContext<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation> context, ApiFuture<ListUsableWorkstationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsableWorkstationsPagedResponse
    extends AbstractPagedListResponse<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation, ListUsableWorkstationsPage, ListUsableWorkstationsFixedSizeCollection> {
        public static ApiFuture<ListUsableWorkstationsPagedResponse> createAsync(PageContext<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse, Workstation> context, ApiFuture<ListUsableWorkstationsResponse> futureResponse) {
            ApiFuture<ListUsableWorkstationsPage> futurePage = ListUsableWorkstationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsableWorkstationsPagedResponse((ListUsableWorkstationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsableWorkstationsPagedResponse(ListUsableWorkstationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableWorkstationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkstationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkstationsRequest, ListWorkstationsResponse, Workstation, ListWorkstationsPage, ListWorkstationsFixedSizeCollection> {
        private ListWorkstationsFixedSizeCollection(List<ListWorkstationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkstationsFixedSizeCollection createEmptyCollection() {
            return new ListWorkstationsFixedSizeCollection(null, 0);
        }

        protected ListWorkstationsFixedSizeCollection createCollection(List<ListWorkstationsPage> pages, int collectionSize) {
            return new ListWorkstationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkstationsPage
    extends AbstractPage<ListWorkstationsRequest, ListWorkstationsResponse, Workstation, ListWorkstationsPage> {
        private ListWorkstationsPage(PageContext<ListWorkstationsRequest, ListWorkstationsResponse, Workstation> context, ListWorkstationsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkstationsPage createEmptyPage() {
            return new ListWorkstationsPage(null, null);
        }

        protected ListWorkstationsPage createPage(PageContext<ListWorkstationsRequest, ListWorkstationsResponse, Workstation> context, ListWorkstationsResponse response) {
            return new ListWorkstationsPage(context, response);
        }

        public ApiFuture<ListWorkstationsPage> createPageAsync(PageContext<ListWorkstationsRequest, ListWorkstationsResponse, Workstation> context, ApiFuture<ListWorkstationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkstationsPagedResponse
    extends AbstractPagedListResponse<ListWorkstationsRequest, ListWorkstationsResponse, Workstation, ListWorkstationsPage, ListWorkstationsFixedSizeCollection> {
        public static ApiFuture<ListWorkstationsPagedResponse> createAsync(PageContext<ListWorkstationsRequest, ListWorkstationsResponse, Workstation> context, ApiFuture<ListWorkstationsResponse> futureResponse) {
            ApiFuture<ListWorkstationsPage> futurePage = ListWorkstationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkstationsPagedResponse((ListWorkstationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkstationsPagedResponse(ListWorkstationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkstationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListUsableWorkstationConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig, ListUsableWorkstationConfigsPage, ListUsableWorkstationConfigsFixedSizeCollection> {
        private ListUsableWorkstationConfigsFixedSizeCollection(List<ListUsableWorkstationConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableWorkstationConfigsFixedSizeCollection createEmptyCollection() {
            return new ListUsableWorkstationConfigsFixedSizeCollection(null, 0);
        }

        protected ListUsableWorkstationConfigsFixedSizeCollection createCollection(List<ListUsableWorkstationConfigsPage> pages, int collectionSize) {
            return new ListUsableWorkstationConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsableWorkstationConfigsPage
    extends AbstractPage<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig, ListUsableWorkstationConfigsPage> {
        private ListUsableWorkstationConfigsPage(PageContext<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig> context, ListUsableWorkstationConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListUsableWorkstationConfigsPage createEmptyPage() {
            return new ListUsableWorkstationConfigsPage(null, null);
        }

        protected ListUsableWorkstationConfigsPage createPage(PageContext<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig> context, ListUsableWorkstationConfigsResponse response) {
            return new ListUsableWorkstationConfigsPage(context, response);
        }

        public ApiFuture<ListUsableWorkstationConfigsPage> createPageAsync(PageContext<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig> context, ApiFuture<ListUsableWorkstationConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsableWorkstationConfigsPagedResponse
    extends AbstractPagedListResponse<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig, ListUsableWorkstationConfigsPage, ListUsableWorkstationConfigsFixedSizeCollection> {
        public static ApiFuture<ListUsableWorkstationConfigsPagedResponse> createAsync(PageContext<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse, WorkstationConfig> context, ApiFuture<ListUsableWorkstationConfigsResponse> futureResponse) {
            ApiFuture<ListUsableWorkstationConfigsPage> futurePage = ListUsableWorkstationConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsableWorkstationConfigsPagedResponse((ListUsableWorkstationConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsableWorkstationConfigsPagedResponse(ListUsableWorkstationConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableWorkstationConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkstationConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig, ListWorkstationConfigsPage, ListWorkstationConfigsFixedSizeCollection> {
        private ListWorkstationConfigsFixedSizeCollection(List<ListWorkstationConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkstationConfigsFixedSizeCollection createEmptyCollection() {
            return new ListWorkstationConfigsFixedSizeCollection(null, 0);
        }

        protected ListWorkstationConfigsFixedSizeCollection createCollection(List<ListWorkstationConfigsPage> pages, int collectionSize) {
            return new ListWorkstationConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkstationConfigsPage
    extends AbstractPage<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig, ListWorkstationConfigsPage> {
        private ListWorkstationConfigsPage(PageContext<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig> context, ListWorkstationConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkstationConfigsPage createEmptyPage() {
            return new ListWorkstationConfigsPage(null, null);
        }

        protected ListWorkstationConfigsPage createPage(PageContext<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig> context, ListWorkstationConfigsResponse response) {
            return new ListWorkstationConfigsPage(context, response);
        }

        public ApiFuture<ListWorkstationConfigsPage> createPageAsync(PageContext<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig> context, ApiFuture<ListWorkstationConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkstationConfigsPagedResponse
    extends AbstractPagedListResponse<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig, ListWorkstationConfigsPage, ListWorkstationConfigsFixedSizeCollection> {
        public static ApiFuture<ListWorkstationConfigsPagedResponse> createAsync(PageContext<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse, WorkstationConfig> context, ApiFuture<ListWorkstationConfigsResponse> futureResponse) {
            ApiFuture<ListWorkstationConfigsPage> futurePage = ListWorkstationConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkstationConfigsPagedResponse((ListWorkstationConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkstationConfigsPagedResponse(ListWorkstationConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkstationConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkstationClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster, ListWorkstationClustersPage, ListWorkstationClustersFixedSizeCollection> {
        private ListWorkstationClustersFixedSizeCollection(List<ListWorkstationClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkstationClustersFixedSizeCollection createEmptyCollection() {
            return new ListWorkstationClustersFixedSizeCollection(null, 0);
        }

        protected ListWorkstationClustersFixedSizeCollection createCollection(List<ListWorkstationClustersPage> pages, int collectionSize) {
            return new ListWorkstationClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkstationClustersPage
    extends AbstractPage<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster, ListWorkstationClustersPage> {
        private ListWorkstationClustersPage(PageContext<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster> context, ListWorkstationClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkstationClustersPage createEmptyPage() {
            return new ListWorkstationClustersPage(null, null);
        }

        protected ListWorkstationClustersPage createPage(PageContext<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster> context, ListWorkstationClustersResponse response) {
            return new ListWorkstationClustersPage(context, response);
        }

        public ApiFuture<ListWorkstationClustersPage> createPageAsync(PageContext<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster> context, ApiFuture<ListWorkstationClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkstationClustersPagedResponse
    extends AbstractPagedListResponse<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster, ListWorkstationClustersPage, ListWorkstationClustersFixedSizeCollection> {
        public static ApiFuture<ListWorkstationClustersPagedResponse> createAsync(PageContext<ListWorkstationClustersRequest, ListWorkstationClustersResponse, WorkstationCluster> context, ApiFuture<ListWorkstationClustersResponse> futureResponse) {
            ApiFuture<ListWorkstationClustersPage> futurePage = ListWorkstationClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkstationClustersPagedResponse((ListWorkstationClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkstationClustersPagedResponse(ListWorkstationClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkstationClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

