/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iam.admin.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.iam.admin.v1.IAMSettings;
import com.google.cloud.iam.admin.v1.stub.IAMStub;
import com.google.cloud.iam.admin.v1.stub.IAMStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.admin.v1.CreateRoleRequest;
import com.google.iam.admin.v1.CreateServiceAccountKeyRequest;
import com.google.iam.admin.v1.CreateServiceAccountRequest;
import com.google.iam.admin.v1.DeleteRoleRequest;
import com.google.iam.admin.v1.DeleteServiceAccountKeyRequest;
import com.google.iam.admin.v1.DeleteServiceAccountRequest;
import com.google.iam.admin.v1.DisableServiceAccountKeyRequest;
import com.google.iam.admin.v1.DisableServiceAccountRequest;
import com.google.iam.admin.v1.EnableServiceAccountKeyRequest;
import com.google.iam.admin.v1.EnableServiceAccountRequest;
import com.google.iam.admin.v1.GetRoleRequest;
import com.google.iam.admin.v1.GetServiceAccountKeyRequest;
import com.google.iam.admin.v1.GetServiceAccountRequest;
import com.google.iam.admin.v1.KeyName;
import com.google.iam.admin.v1.LintPolicyRequest;
import com.google.iam.admin.v1.LintPolicyResponse;
import com.google.iam.admin.v1.ListRolesRequest;
import com.google.iam.admin.v1.ListRolesResponse;
import com.google.iam.admin.v1.ListServiceAccountKeysRequest;
import com.google.iam.admin.v1.ListServiceAccountKeysResponse;
import com.google.iam.admin.v1.ListServiceAccountsRequest;
import com.google.iam.admin.v1.ListServiceAccountsResponse;
import com.google.iam.admin.v1.PatchServiceAccountRequest;
import com.google.iam.admin.v1.Permission;
import com.google.iam.admin.v1.ProjectName;
import com.google.iam.admin.v1.QueryAuditableServicesRequest;
import com.google.iam.admin.v1.QueryAuditableServicesResponse;
import com.google.iam.admin.v1.QueryGrantableRolesRequest;
import com.google.iam.admin.v1.QueryGrantableRolesResponse;
import com.google.iam.admin.v1.QueryTestablePermissionsRequest;
import com.google.iam.admin.v1.QueryTestablePermissionsResponse;
import com.google.iam.admin.v1.Role;
import com.google.iam.admin.v1.ServiceAccount;
import com.google.iam.admin.v1.ServiceAccountKey;
import com.google.iam.admin.v1.ServiceAccountKeyAlgorithm;
import com.google.iam.admin.v1.ServiceAccountName;
import com.google.iam.admin.v1.ServiceAccountPrivateKeyType;
import com.google.iam.admin.v1.ServiceAccountPublicKeyType;
import com.google.iam.admin.v1.SignBlobRequest;
import com.google.iam.admin.v1.SignBlobResponse;
import com.google.iam.admin.v1.SignJwtRequest;
import com.google.iam.admin.v1.SignJwtResponse;
import com.google.iam.admin.v1.UndeleteRoleRequest;
import com.google.iam.admin.v1.UndeleteServiceAccountRequest;
import com.google.iam.admin.v1.UndeleteServiceAccountResponse;
import com.google.iam.admin.v1.UpdateRoleRequest;
import com.google.iam.admin.v1.UploadServiceAccountKeyRequest;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IAMClient
implements BackgroundResource {
    private final IAMSettings settings;
    private final IAMStub stub;

    public static final IAMClient create() throws IOException {
        return IAMClient.create(IAMSettings.newBuilder().build());
    }

    public static final IAMClient create(IAMSettings settings) throws IOException {
        return new IAMClient(settings);
    }

    public static final IAMClient create(IAMStub stub) {
        return new IAMClient(stub);
    }

    protected IAMClient(IAMSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IAMStubSettings)settings.getStubSettings()).createStub();
    }

    protected IAMClient(IAMStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final IAMSettings getSettings() {
        return this.settings;
    }

    public IAMStub getStub() {
        return this.stub;
    }

    public final ListServiceAccountsPagedResponse listServiceAccounts(ProjectName name) {
        ListServiceAccountsRequest request = ListServiceAccountsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listServiceAccounts(request);
    }

    public final ListServiceAccountsPagedResponse listServiceAccounts(String name) {
        ListServiceAccountsRequest request = ListServiceAccountsRequest.newBuilder().setName(name).build();
        return this.listServiceAccounts(request);
    }

    public final ListServiceAccountsPagedResponse listServiceAccounts(ListServiceAccountsRequest request) {
        return (ListServiceAccountsPagedResponse)((Object)this.listServiceAccountsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceAccountsRequest, ListServiceAccountsPagedResponse> listServiceAccountsPagedCallable() {
        return this.stub.listServiceAccountsPagedCallable();
    }

    public final UnaryCallable<ListServiceAccountsRequest, ListServiceAccountsResponse> listServiceAccountsCallable() {
        return this.stub.listServiceAccountsCallable();
    }

    public final ServiceAccount getServiceAccount(ServiceAccountName name) {
        GetServiceAccountRequest request = GetServiceAccountRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceAccount(request);
    }

    public final ServiceAccount getServiceAccount(String name) {
        GetServiceAccountRequest request = GetServiceAccountRequest.newBuilder().setName(name).build();
        return this.getServiceAccount(request);
    }

    public final ServiceAccount getServiceAccount(GetServiceAccountRequest request) {
        return (ServiceAccount)this.getServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceAccountRequest, ServiceAccount> getServiceAccountCallable() {
        return this.stub.getServiceAccountCallable();
    }

    public final ServiceAccount createServiceAccount(ProjectName name, String accountId, ServiceAccount serviceAccount) {
        CreateServiceAccountRequest request = CreateServiceAccountRequest.newBuilder().setName(name == null ? null : name.toString()).setAccountId(accountId).setServiceAccount(serviceAccount).build();
        return this.createServiceAccount(request);
    }

    public final ServiceAccount createServiceAccount(String name, String accountId, ServiceAccount serviceAccount) {
        CreateServiceAccountRequest request = CreateServiceAccountRequest.newBuilder().setName(name).setAccountId(accountId).setServiceAccount(serviceAccount).build();
        return this.createServiceAccount(request);
    }

    public final ServiceAccount createServiceAccount(CreateServiceAccountRequest request) {
        return (ServiceAccount)this.createServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServiceAccountRequest, ServiceAccount> createServiceAccountCallable() {
        return this.stub.createServiceAccountCallable();
    }

    public final ServiceAccount updateServiceAccount(ServiceAccount request) {
        return (ServiceAccount)this.updateServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<ServiceAccount, ServiceAccount> updateServiceAccountCallable() {
        return this.stub.updateServiceAccountCallable();
    }

    public final ServiceAccount patchServiceAccount(PatchServiceAccountRequest request) {
        return (ServiceAccount)this.patchServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<PatchServiceAccountRequest, ServiceAccount> patchServiceAccountCallable() {
        return this.stub.patchServiceAccountCallable();
    }

    public final void deleteServiceAccount(ServiceAccountName name) {
        DeleteServiceAccountRequest request = DeleteServiceAccountRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteServiceAccount(request);
    }

    public final void deleteServiceAccount(String name) {
        DeleteServiceAccountRequest request = DeleteServiceAccountRequest.newBuilder().setName(name).build();
        this.deleteServiceAccount(request);
    }

    public final void deleteServiceAccount(DeleteServiceAccountRequest request) {
        this.deleteServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteServiceAccountRequest, Empty> deleteServiceAccountCallable() {
        return this.stub.deleteServiceAccountCallable();
    }

    public final UndeleteServiceAccountResponse undeleteServiceAccount(UndeleteServiceAccountRequest request) {
        return (UndeleteServiceAccountResponse)this.undeleteServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<UndeleteServiceAccountRequest, UndeleteServiceAccountResponse> undeleteServiceAccountCallable() {
        return this.stub.undeleteServiceAccountCallable();
    }

    public final void enableServiceAccount(EnableServiceAccountRequest request) {
        this.enableServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<EnableServiceAccountRequest, Empty> enableServiceAccountCallable() {
        return this.stub.enableServiceAccountCallable();
    }

    public final void disableServiceAccount(DisableServiceAccountRequest request) {
        this.disableServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<DisableServiceAccountRequest, Empty> disableServiceAccountCallable() {
        return this.stub.disableServiceAccountCallable();
    }

    public final ListServiceAccountKeysResponse listServiceAccountKeys(ServiceAccountName name, List<ListServiceAccountKeysRequest.KeyType> keyTypes) {
        ListServiceAccountKeysRequest request = ListServiceAccountKeysRequest.newBuilder().setName(name == null ? null : name.toString()).addAllKeyTypes(keyTypes).build();
        return this.listServiceAccountKeys(request);
    }

    public final ListServiceAccountKeysResponse listServiceAccountKeys(String name, List<ListServiceAccountKeysRequest.KeyType> keyTypes) {
        ListServiceAccountKeysRequest request = ListServiceAccountKeysRequest.newBuilder().setName(name).addAllKeyTypes(keyTypes).build();
        return this.listServiceAccountKeys(request);
    }

    public final ListServiceAccountKeysResponse listServiceAccountKeys(ListServiceAccountKeysRequest request) {
        return (ListServiceAccountKeysResponse)this.listServiceAccountKeysCallable().call((Object)request);
    }

    public final UnaryCallable<ListServiceAccountKeysRequest, ListServiceAccountKeysResponse> listServiceAccountKeysCallable() {
        return this.stub.listServiceAccountKeysCallable();
    }

    public final ServiceAccountKey getServiceAccountKey(KeyName name, ServiceAccountPublicKeyType publicKeyType) {
        GetServiceAccountKeyRequest request = GetServiceAccountKeyRequest.newBuilder().setName(name == null ? null : name.toString()).setPublicKeyType(publicKeyType).build();
        return this.getServiceAccountKey(request);
    }

    public final ServiceAccountKey getServiceAccountKey(String name, ServiceAccountPublicKeyType publicKeyType) {
        GetServiceAccountKeyRequest request = GetServiceAccountKeyRequest.newBuilder().setName(name).setPublicKeyType(publicKeyType).build();
        return this.getServiceAccountKey(request);
    }

    public final ServiceAccountKey getServiceAccountKey(GetServiceAccountKeyRequest request) {
        return (ServiceAccountKey)this.getServiceAccountKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceAccountKeyRequest, ServiceAccountKey> getServiceAccountKeyCallable() {
        return this.stub.getServiceAccountKeyCallable();
    }

    public final ServiceAccountKey createServiceAccountKey(ServiceAccountName name, ServiceAccountPrivateKeyType privateKeyType, ServiceAccountKeyAlgorithm keyAlgorithm) {
        CreateServiceAccountKeyRequest request = CreateServiceAccountKeyRequest.newBuilder().setName(name == null ? null : name.toString()).setPrivateKeyType(privateKeyType).setKeyAlgorithm(keyAlgorithm).build();
        return this.createServiceAccountKey(request);
    }

    public final ServiceAccountKey createServiceAccountKey(String name, ServiceAccountPrivateKeyType privateKeyType, ServiceAccountKeyAlgorithm keyAlgorithm) {
        CreateServiceAccountKeyRequest request = CreateServiceAccountKeyRequest.newBuilder().setName(name).setPrivateKeyType(privateKeyType).setKeyAlgorithm(keyAlgorithm).build();
        return this.createServiceAccountKey(request);
    }

    public final ServiceAccountKey createServiceAccountKey(CreateServiceAccountKeyRequest request) {
        return (ServiceAccountKey)this.createServiceAccountKeyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServiceAccountKeyRequest, ServiceAccountKey> createServiceAccountKeyCallable() {
        return this.stub.createServiceAccountKeyCallable();
    }

    public final ServiceAccountKey uploadServiceAccountKey(UploadServiceAccountKeyRequest request) {
        return (ServiceAccountKey)this.uploadServiceAccountKeyCallable().call((Object)request);
    }

    public final UnaryCallable<UploadServiceAccountKeyRequest, ServiceAccountKey> uploadServiceAccountKeyCallable() {
        return this.stub.uploadServiceAccountKeyCallable();
    }

    public final void deleteServiceAccountKey(KeyName name) {
        DeleteServiceAccountKeyRequest request = DeleteServiceAccountKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteServiceAccountKey(request);
    }

    public final void deleteServiceAccountKey(String name) {
        DeleteServiceAccountKeyRequest request = DeleteServiceAccountKeyRequest.newBuilder().setName(name).build();
        this.deleteServiceAccountKey(request);
    }

    public final void deleteServiceAccountKey(DeleteServiceAccountKeyRequest request) {
        this.deleteServiceAccountKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteServiceAccountKeyRequest, Empty> deleteServiceAccountKeyCallable() {
        return this.stub.deleteServiceAccountKeyCallable();
    }

    public final void disableServiceAccountKey(KeyName name) {
        DisableServiceAccountKeyRequest request = DisableServiceAccountKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.disableServiceAccountKey(request);
    }

    public final void disableServiceAccountKey(String name) {
        DisableServiceAccountKeyRequest request = DisableServiceAccountKeyRequest.newBuilder().setName(name).build();
        this.disableServiceAccountKey(request);
    }

    public final void disableServiceAccountKey(DisableServiceAccountKeyRequest request) {
        this.disableServiceAccountKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DisableServiceAccountKeyRequest, Empty> disableServiceAccountKeyCallable() {
        return this.stub.disableServiceAccountKeyCallable();
    }

    public final void enableServiceAccountKey(KeyName name) {
        EnableServiceAccountKeyRequest request = EnableServiceAccountKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.enableServiceAccountKey(request);
    }

    public final void enableServiceAccountKey(String name) {
        EnableServiceAccountKeyRequest request = EnableServiceAccountKeyRequest.newBuilder().setName(name).build();
        this.enableServiceAccountKey(request);
    }

    public final void enableServiceAccountKey(EnableServiceAccountKeyRequest request) {
        this.enableServiceAccountKeyCallable().call((Object)request);
    }

    public final UnaryCallable<EnableServiceAccountKeyRequest, Empty> enableServiceAccountKeyCallable() {
        return this.stub.enableServiceAccountKeyCallable();
    }

    @Deprecated
    public final SignBlobResponse signBlob(ServiceAccountName name, ByteString bytesToSign) {
        SignBlobRequest request = SignBlobRequest.newBuilder().setName(name == null ? null : name.toString()).setBytesToSign(bytesToSign).build();
        return this.signBlob(request);
    }

    @Deprecated
    public final SignBlobResponse signBlob(String name, ByteString bytesToSign) {
        SignBlobRequest request = SignBlobRequest.newBuilder().setName(name).setBytesToSign(bytesToSign).build();
        return this.signBlob(request);
    }

    @Deprecated
    public final SignBlobResponse signBlob(SignBlobRequest request) {
        return (SignBlobResponse)this.signBlobCallable().call((Object)request);
    }

    @Deprecated
    public final UnaryCallable<SignBlobRequest, SignBlobResponse> signBlobCallable() {
        return this.stub.signBlobCallable();
    }

    @Deprecated
    public final SignJwtResponse signJwt(ServiceAccountName name, String payload) {
        SignJwtRequest request = SignJwtRequest.newBuilder().setName(name == null ? null : name.toString()).setPayload(payload).build();
        return this.signJwt(request);
    }

    @Deprecated
    public final SignJwtResponse signJwt(String name, String payload) {
        SignJwtRequest request = SignJwtRequest.newBuilder().setName(name).setPayload(payload).build();
        return this.signJwt(request);
    }

    @Deprecated
    public final SignJwtResponse signJwt(SignJwtRequest request) {
        return (SignJwtResponse)this.signJwtCallable().call((Object)request);
    }

    @Deprecated
    public final UnaryCallable<SignJwtRequest, SignJwtResponse> signJwtCallable() {
        return this.stub.signJwtCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final QueryGrantableRolesPagedResponse queryGrantableRoles(String fullResourceName) {
        QueryGrantableRolesRequest request = QueryGrantableRolesRequest.newBuilder().setFullResourceName(fullResourceName).build();
        return this.queryGrantableRoles(request);
    }

    public final QueryGrantableRolesPagedResponse queryGrantableRoles(QueryGrantableRolesRequest request) {
        return (QueryGrantableRolesPagedResponse)((Object)this.queryGrantableRolesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryGrantableRolesRequest, QueryGrantableRolesPagedResponse> queryGrantableRolesPagedCallable() {
        return this.stub.queryGrantableRolesPagedCallable();
    }

    public final UnaryCallable<QueryGrantableRolesRequest, QueryGrantableRolesResponse> queryGrantableRolesCallable() {
        return this.stub.queryGrantableRolesCallable();
    }

    public final ListRolesPagedResponse listRoles(ListRolesRequest request) {
        return (ListRolesPagedResponse)((Object)this.listRolesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRolesRequest, ListRolesPagedResponse> listRolesPagedCallable() {
        return this.stub.listRolesPagedCallable();
    }

    public final UnaryCallable<ListRolesRequest, ListRolesResponse> listRolesCallable() {
        return this.stub.listRolesCallable();
    }

    public final Role getRole(GetRoleRequest request) {
        return (Role)this.getRoleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRoleRequest, Role> getRoleCallable() {
        return this.stub.getRoleCallable();
    }

    public final Role createRole(CreateRoleRequest request) {
        return (Role)this.createRoleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRoleRequest, Role> createRoleCallable() {
        return this.stub.createRoleCallable();
    }

    public final Role updateRole(UpdateRoleRequest request) {
        return (Role)this.updateRoleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRoleRequest, Role> updateRoleCallable() {
        return this.stub.updateRoleCallable();
    }

    public final Role deleteRole(DeleteRoleRequest request) {
        return (Role)this.deleteRoleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRoleRequest, Role> deleteRoleCallable() {
        return this.stub.deleteRoleCallable();
    }

    public final Role undeleteRole(UndeleteRoleRequest request) {
        return (Role)this.undeleteRoleCallable().call((Object)request);
    }

    public final UnaryCallable<UndeleteRoleRequest, Role> undeleteRoleCallable() {
        return this.stub.undeleteRoleCallable();
    }

    public final QueryTestablePermissionsPagedResponse queryTestablePermissions(QueryTestablePermissionsRequest request) {
        return (QueryTestablePermissionsPagedResponse)((Object)this.queryTestablePermissionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryTestablePermissionsRequest, QueryTestablePermissionsPagedResponse> queryTestablePermissionsPagedCallable() {
        return this.stub.queryTestablePermissionsPagedCallable();
    }

    public final UnaryCallable<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse> queryTestablePermissionsCallable() {
        return this.stub.queryTestablePermissionsCallable();
    }

    public final QueryAuditableServicesResponse queryAuditableServices(QueryAuditableServicesRequest request) {
        return (QueryAuditableServicesResponse)this.queryAuditableServicesCallable().call((Object)request);
    }

    public final UnaryCallable<QueryAuditableServicesRequest, QueryAuditableServicesResponse> queryAuditableServicesCallable() {
        return this.stub.queryAuditableServicesCallable();
    }

    public final LintPolicyResponse lintPolicy(LintPolicyRequest request) {
        return (LintPolicyResponse)this.lintPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<LintPolicyRequest, LintPolicyResponse> lintPolicyCallable() {
        return this.stub.lintPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class QueryTestablePermissionsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission, QueryTestablePermissionsPage, QueryTestablePermissionsFixedSizeCollection> {
        private QueryTestablePermissionsFixedSizeCollection(List<QueryTestablePermissionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryTestablePermissionsFixedSizeCollection createEmptyCollection() {
            return new QueryTestablePermissionsFixedSizeCollection(null, 0);
        }

        protected QueryTestablePermissionsFixedSizeCollection createCollection(List<QueryTestablePermissionsPage> pages, int collectionSize) {
            return new QueryTestablePermissionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryTestablePermissionsPage
    extends AbstractPage<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission, QueryTestablePermissionsPage> {
        private QueryTestablePermissionsPage(PageContext<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission> context, QueryTestablePermissionsResponse response) {
            super(context, (Object)response);
        }

        private static QueryTestablePermissionsPage createEmptyPage() {
            return new QueryTestablePermissionsPage(null, null);
        }

        protected QueryTestablePermissionsPage createPage(PageContext<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission> context, QueryTestablePermissionsResponse response) {
            return new QueryTestablePermissionsPage(context, response);
        }

        public ApiFuture<QueryTestablePermissionsPage> createPageAsync(PageContext<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission> context, ApiFuture<QueryTestablePermissionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryTestablePermissionsPagedResponse
    extends AbstractPagedListResponse<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission, QueryTestablePermissionsPage, QueryTestablePermissionsFixedSizeCollection> {
        public static ApiFuture<QueryTestablePermissionsPagedResponse> createAsync(PageContext<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission> context, ApiFuture<QueryTestablePermissionsResponse> futureResponse) {
            ApiFuture<QueryTestablePermissionsPage> futurePage = QueryTestablePermissionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryTestablePermissionsPagedResponse((QueryTestablePermissionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryTestablePermissionsPagedResponse(QueryTestablePermissionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryTestablePermissionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRolesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRolesRequest, ListRolesResponse, Role, ListRolesPage, ListRolesFixedSizeCollection> {
        private ListRolesFixedSizeCollection(List<ListRolesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRolesFixedSizeCollection createEmptyCollection() {
            return new ListRolesFixedSizeCollection(null, 0);
        }

        protected ListRolesFixedSizeCollection createCollection(List<ListRolesPage> pages, int collectionSize) {
            return new ListRolesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRolesPage
    extends AbstractPage<ListRolesRequest, ListRolesResponse, Role, ListRolesPage> {
        private ListRolesPage(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ListRolesResponse response) {
            super(context, (Object)response);
        }

        private static ListRolesPage createEmptyPage() {
            return new ListRolesPage(null, null);
        }

        protected ListRolesPage createPage(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ListRolesResponse response) {
            return new ListRolesPage(context, response);
        }

        public ApiFuture<ListRolesPage> createPageAsync(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ApiFuture<ListRolesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRolesPagedResponse
    extends AbstractPagedListResponse<ListRolesRequest, ListRolesResponse, Role, ListRolesPage, ListRolesFixedSizeCollection> {
        public static ApiFuture<ListRolesPagedResponse> createAsync(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ApiFuture<ListRolesResponse> futureResponse) {
            ApiFuture<ListRolesPage> futurePage = ListRolesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRolesPagedResponse((ListRolesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRolesPagedResponse(ListRolesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRolesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryGrantableRolesFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role, QueryGrantableRolesPage, QueryGrantableRolesFixedSizeCollection> {
        private QueryGrantableRolesFixedSizeCollection(List<QueryGrantableRolesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryGrantableRolesFixedSizeCollection createEmptyCollection() {
            return new QueryGrantableRolesFixedSizeCollection(null, 0);
        }

        protected QueryGrantableRolesFixedSizeCollection createCollection(List<QueryGrantableRolesPage> pages, int collectionSize) {
            return new QueryGrantableRolesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryGrantableRolesPage
    extends AbstractPage<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role, QueryGrantableRolesPage> {
        private QueryGrantableRolesPage(PageContext<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role> context, QueryGrantableRolesResponse response) {
            super(context, (Object)response);
        }

        private static QueryGrantableRolesPage createEmptyPage() {
            return new QueryGrantableRolesPage(null, null);
        }

        protected QueryGrantableRolesPage createPage(PageContext<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role> context, QueryGrantableRolesResponse response) {
            return new QueryGrantableRolesPage(context, response);
        }

        public ApiFuture<QueryGrantableRolesPage> createPageAsync(PageContext<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role> context, ApiFuture<QueryGrantableRolesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryGrantableRolesPagedResponse
    extends AbstractPagedListResponse<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role, QueryGrantableRolesPage, QueryGrantableRolesFixedSizeCollection> {
        public static ApiFuture<QueryGrantableRolesPagedResponse> createAsync(PageContext<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role> context, ApiFuture<QueryGrantableRolesResponse> futureResponse) {
            ApiFuture<QueryGrantableRolesPage> futurePage = QueryGrantableRolesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryGrantableRolesPagedResponse((QueryGrantableRolesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryGrantableRolesPagedResponse(QueryGrantableRolesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryGrantableRolesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceAccountsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount, ListServiceAccountsPage, ListServiceAccountsFixedSizeCollection> {
        private ListServiceAccountsFixedSizeCollection(List<ListServiceAccountsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceAccountsFixedSizeCollection createEmptyCollection() {
            return new ListServiceAccountsFixedSizeCollection(null, 0);
        }

        protected ListServiceAccountsFixedSizeCollection createCollection(List<ListServiceAccountsPage> pages, int collectionSize) {
            return new ListServiceAccountsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceAccountsPage
    extends AbstractPage<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount, ListServiceAccountsPage> {
        private ListServiceAccountsPage(PageContext<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount> context, ListServiceAccountsResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceAccountsPage createEmptyPage() {
            return new ListServiceAccountsPage(null, null);
        }

        protected ListServiceAccountsPage createPage(PageContext<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount> context, ListServiceAccountsResponse response) {
            return new ListServiceAccountsPage(context, response);
        }

        public ApiFuture<ListServiceAccountsPage> createPageAsync(PageContext<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount> context, ApiFuture<ListServiceAccountsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceAccountsPagedResponse
    extends AbstractPagedListResponse<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount, ListServiceAccountsPage, ListServiceAccountsFixedSizeCollection> {
        public static ApiFuture<ListServiceAccountsPagedResponse> createAsync(PageContext<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount> context, ApiFuture<ListServiceAccountsResponse> futureResponse) {
            ApiFuture<ListServiceAccountsPage> futurePage = ListServiceAccountsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceAccountsPagedResponse((ListServiceAccountsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceAccountsPagedResponse(ListServiceAccountsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceAccountsFixedSizeCollection.createEmptyCollection());
        }
    }
}

