/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v2.CreatePolicyRequest;
import com.google.iam.v2.DeletePolicyRequest;
import com.google.iam.v2.GetPolicyRequest;
import com.google.iam.v2.ListPoliciesRequest;
import com.google.iam.v2.ListPoliciesResponse;
import com.google.iam.v2.PoliciesClient;
import com.google.iam.v2.Policy;
import com.google.iam.v2.PolicyOperationMetadata;
import com.google.iam.v2.UpdatePolicyRequest;
import com.google.iam.v2.stub.HttpJsonPoliciesCallableFactory;
import com.google.iam.v2.stub.PoliciesStub;
import com.google.iam.v2.stub.PoliciesStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonPoliciesStub
extends PoliciesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(PolicyOperationMetadata.getDescriptor()).add(Policy.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListPoliciesRequest, ListPoliciesResponse> listPoliciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v2.Policies/ListPolicies").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=policies/*/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPoliciesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPolicyRequest, Policy> getPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v2.Policies/GetPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=policies/*/*/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreatePolicyRequest, Operation> createPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v2.Policies/CreatePolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=policies/*/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "policyId", (Object)request.getPolicyId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("policy", (Message)request.getPolicy(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdatePolicyRequest, Operation> updatePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v2.Policies/UpdatePolicy").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{policy.name=policies/*/*/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "policy.name", (Object)request.getPolicy().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("policy", (Message)request.getPolicy(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeletePolicyRequest, Operation> deletePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v2.Policies/DeletePolicy").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=policies/*/*/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable;
    private final UnaryCallable<ListPoliciesRequest, PoliciesClient.ListPoliciesPagedResponse> listPoliciesPagedCallable;
    private final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable;
    private final UnaryCallable<CreatePolicyRequest, Operation> createPolicyCallable;
    private final OperationCallable<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationCallable;
    private final UnaryCallable<UpdatePolicyRequest, Operation> updatePolicyCallable;
    private final OperationCallable<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationCallable;
    private final UnaryCallable<DeletePolicyRequest, Operation> deletePolicyCallable;
    private final OperationCallable<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPoliciesStub create(PoliciesStubSettings settings) throws IOException {
        return new HttpJsonPoliciesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPoliciesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPoliciesStub(PoliciesStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPoliciesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPoliciesStub(PoliciesStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPoliciesStub(PoliciesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPoliciesCallableFactory());
    }

    protected HttpJsonPoliciesStub(PoliciesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=policies/*/*/*/operations/*}").build()).build());
        HttpJsonCallSettings listPoliciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPoliciesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updatePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updatePolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("policy.name", String.valueOf(request.getPolicy().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deletePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deletePolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listPoliciesCallable = callableFactory.createUnaryCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.listPoliciesPagedCallable = callableFactory.createPagedCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.getPolicyCallable = callableFactory.createUnaryCallable(getPolicyTransportSettings, settings.getPolicySettings(), clientContext);
        this.createPolicyCallable = callableFactory.createUnaryCallable(createPolicyTransportSettings, settings.createPolicySettings(), clientContext);
        this.createPolicyOperationCallable = callableFactory.createOperationCallable(createPolicyTransportSettings, settings.createPolicyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updatePolicyCallable = callableFactory.createUnaryCallable(updatePolicyTransportSettings, settings.updatePolicySettings(), clientContext);
        this.updatePolicyOperationCallable = callableFactory.createOperationCallable(updatePolicyTransportSettings, settings.updatePolicyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deletePolicyCallable = callableFactory.createUnaryCallable(deletePolicyTransportSettings, settings.deletePolicySettings(), clientContext);
        this.deletePolicyOperationCallable = callableFactory.createOperationCallable(deletePolicyTransportSettings, settings.deletePolicyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listPoliciesMethodDescriptor);
        methodDescriptors.add(getPolicyMethodDescriptor);
        methodDescriptors.add(createPolicyMethodDescriptor);
        methodDescriptors.add(updatePolicyMethodDescriptor);
        methodDescriptors.add(deletePolicyMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable() {
        return this.listPoliciesCallable;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, PoliciesClient.ListPoliciesPagedResponse> listPoliciesPagedCallable() {
        return this.listPoliciesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.getPolicyCallable;
    }

    @Override
    public UnaryCallable<CreatePolicyRequest, Operation> createPolicyCallable() {
        return this.createPolicyCallable;
    }

    @Override
    public OperationCallable<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationCallable() {
        return this.createPolicyOperationCallable;
    }

    @Override
    public UnaryCallable<UpdatePolicyRequest, Operation> updatePolicyCallable() {
        return this.updatePolicyCallable;
    }

    @Override
    public OperationCallable<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationCallable() {
        return this.updatePolicyOperationCallable;
    }

    @Override
    public UnaryCallable<DeletePolicyRequest, Operation> deletePolicyCallable() {
        return this.deletePolicyCallable;
    }

    @Override
    public OperationCallable<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationCallable() {
        return this.deletePolicyOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

