/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSqlUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.mutable.IndexedSeq;

public class ProtobufUtils {
    static final Logger logger = LoggerFactory.getLogger(ProtobufUtils.class);
    private static final int MAX_BIGQUERY_NESTED_DEPTH = 15;
    private static final String RESERVED_NESTED_TYPE_NAME = "STRUCT";
    private static final LoadingCache<MapType, StructType> MAP_TYPE_STRUCT_TYPE_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<MapType, StructType>(){

        public StructType load(MapType key) {
            return ProtobufUtils.createMapStructType(key);
        }
    });
    private static final ImmutableMap<LegacySQLTypeName, DescriptorProtos.FieldDescriptorProto.Type> BigQueryToProtoType = new ImmutableMap.Builder().put((Object)LegacySQLTypeName.BYTES, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)LegacySQLTypeName.INTEGER, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)LegacySQLTypeName.BOOLEAN, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)LegacySQLTypeName.FLOAT, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)LegacySQLTypeName.NUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)LegacySQLTypeName.BIGNUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)LegacySQLTypeName.STRING, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)LegacySQLTypeName.JSON, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)LegacySQLTypeName.TIMESTAMP, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)LegacySQLTypeName.DATE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)LegacySQLTypeName.DATETIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)LegacySQLTypeName.GEOGRAPHY, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).build();
    private static final ImmutableMap<String, DescriptorProtos.FieldDescriptorProto.Type> SparkToProtoType = new ImmutableMap.Builder().put((Object)DataTypes.BinaryType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)DataTypes.ByteType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)DataTypes.ShortType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)DataTypes.IntegerType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)DataTypes.LongType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)DataTypes.BooleanType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)DataTypes.FloatType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)DataTypes.DoubleType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)SchemaConverters.NUMERIC_SPARK_TYPE.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)DataTypes.StringType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)DataTypes.TimestampType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)DataTypes.DateType.json(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).build();
    private static final ImmutableMap<Field.Mode, DescriptorProtos.FieldDescriptorProto.Label> BigQueryModeToProtoFieldLabel = new ImmutableMap.Builder().put((Object)Field.Mode.NULLABLE, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).put((Object)Field.Mode.REPEATED, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).put((Object)Field.Mode.REQUIRED, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED).build();

    public static ProtoSchema toProtoSchema(Schema schema) throws IllegalArgumentException {
        try {
            Descriptors.Descriptor descriptor = ProtobufUtils.toDescriptor(schema);
            return ProtoSchemaConverter.convert((Descriptors.Descriptor)descriptor);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalArgumentException("Could not build Proto-Schema from BigQuery schema", e);
        }
    }

    public static ProtoSchema toProtoSchema(StructType schema) throws IllegalArgumentException {
        try {
            Descriptors.Descriptor descriptor = ProtobufUtils.toDescriptor(schema);
            return ProtoSchemaConverter.convert((Descriptors.Descriptor)descriptor);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalArgumentException("Could not build Proto-Schema from Spark schema", e);
        }
    }

    private static Descriptors.Descriptor toDescriptor(Schema schema) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder().setName("Schema");
        FieldList fields = schema.getFields();
        int initialDepth = 0;
        DescriptorProtos.DescriptorProto descriptorProto = ProtobufUtils.buildDescriptorProtoWithFields(descriptorBuilder, fields, initialDepth);
        return ProtobufUtils.createDescriptorFromProto(descriptorProto);
    }

    private static Descriptors.Descriptor createDescriptorFromProto(DescriptorProtos.DescriptorProto descriptorProto) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.Descriptor descriptor = (Descriptors.Descriptor)Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]).getMessageTypes().get(0);
        return descriptor;
    }

    @VisibleForTesting
    protected static DescriptorProtos.DescriptorProto buildDescriptorProtoWithFields(DescriptorProtos.DescriptorProto.Builder descriptorBuilder, FieldList fields, int depth) {
        Preconditions.checkArgument((depth < 15 ? 1 : 0) != 0, (Object)"Tried to convert a BigQuery schema that exceeded BigQuery maximum nesting depth");
        int messageNumber = 1;
        for (Field field : fields) {
            String fieldName = field.getName();
            DescriptorProtos.FieldDescriptorProto.Label fieldLabel = ProtobufUtils.toProtoFieldLabel(field.getMode());
            FieldList subFields = field.getSubFields();
            if (field.getType() == LegacySQLTypeName.RECORD) {
                String recordTypeName = RESERVED_NESTED_TYPE_NAME + messageNumber;
                DescriptorProtos.DescriptorProto.Builder nestedFieldTypeBuilder = descriptorBuilder.addNestedTypeBuilder();
                nestedFieldTypeBuilder.setName(recordTypeName);
                DescriptorProtos.DescriptorProto nestedFieldType = ProtobufUtils.buildDescriptorProtoWithFields(nestedFieldTypeBuilder, subFields, depth + 1);
                descriptorBuilder.addField(ProtobufUtils.createProtoFieldBuilder(fieldName, fieldLabel, messageNumber).setTypeName(recordTypeName));
            } else {
                DescriptorProtos.FieldDescriptorProto.Type fieldType = ProtobufUtils.toProtoFieldType(field.getType());
                descriptorBuilder.addField(ProtobufUtils.createProtoFieldBuilder(fieldName, fieldLabel, messageNumber, fieldType));
            }
            ++messageNumber;
        }
        return descriptorBuilder.build();
    }

    private static DescriptorProtos.FieldDescriptorProto.Builder createProtoFieldBuilder(String fieldName, DescriptorProtos.FieldDescriptorProto.Label fieldLabel, int messageNumber) {
        return DescriptorProtos.FieldDescriptorProto.newBuilder().setName(fieldName).setLabel(fieldLabel).setNumber(messageNumber);
    }

    @VisibleForTesting
    protected static DescriptorProtos.FieldDescriptorProto.Builder createProtoFieldBuilder(String fieldName, DescriptorProtos.FieldDescriptorProto.Label fieldLabel, int messageNumber, DescriptorProtos.FieldDescriptorProto.Type fieldType) {
        return ProtobufUtils.createProtoFieldBuilder(fieldName, fieldLabel, messageNumber).setType(fieldType);
    }

    private static DescriptorProtos.FieldDescriptorProto.Label toProtoFieldLabel(Field.Mode mode) {
        return (DescriptorProtos.FieldDescriptorProto.Label)Preconditions.checkNotNull((Object)BigQueryModeToProtoFieldLabel.get((Object)mode), (Object)new IllegalArgumentException("A BigQuery Field Mode was invalid: " + mode.name()));
    }

    private static DescriptorProtos.FieldDescriptorProto.Type toProtoFieldType(LegacySQLTypeName bqType) {
        if (LegacySQLTypeName.RECORD.equals((Object)bqType)) {
            throw new IllegalStateException("Program attempted to return an atomic data-type for a RECORD");
        }
        return (DescriptorProtos.FieldDescriptorProto.Type)Preconditions.checkNotNull((Object)BigQueryToProtoType.get((Object)bqType), (Object)new IllegalArgumentException("Unexpected type: " + bqType.name()));
    }

    public static ProtoRows toProtoRows(StructType sparkSchema, InternalRow[] rows) {
        try {
            Descriptors.Descriptor schemaDescriptor = ProtobufUtils.toDescriptor(sparkSchema);
            ProtoRows.Builder protoRows = ProtoRows.newBuilder();
            for (InternalRow row : rows) {
                DynamicMessage rowMessage = ProtobufUtils.buildSingleRowMessage(sparkSchema, schemaDescriptor, row);
                protoRows.addSerializedRows(rowMessage.toByteString());
            }
            return protoRows.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert Internal Rows to Proto Rows.", e);
        }
    }

    public static DynamicMessage buildSingleRowMessage(StructType schema, Descriptors.Descriptor schemaDescriptor, InternalRow row) {
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)schemaDescriptor);
        for (int fieldIndex = 0; fieldIndex < schemaDescriptor.getFields().size(); ++fieldIndex) {
            Descriptors.Descriptor nestedTypeDescriptor;
            boolean nullable;
            Object sparkValue;
            int protoFieldNumber = fieldIndex + 1;
            StructField sparkField = schema.fields()[fieldIndex];
            DataType sparkType = sparkField.dataType();
            Object protoValue = ProtobufUtils.convertSparkValueToProtoRowValue(sparkType, sparkValue = row.get(fieldIndex, sparkType), nullable = sparkField.nullable(), nestedTypeDescriptor = schemaDescriptor.findNestedTypeByName(RESERVED_NESTED_TYPE_NAME + protoFieldNumber));
            if (protoValue == null) continue;
            messageBuilder.setField(schemaDescriptor.findFieldByNumber(protoFieldNumber), protoValue);
        }
        return messageBuilder.build();
    }

    public static Descriptors.Descriptor toDescriptor(StructType schema) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder().setName("Schema");
        int initialDepth = 0;
        DescriptorProtos.DescriptorProto descriptorProto = ProtobufUtils.buildDescriptorProtoWithFields(descriptorBuilder, schema.fields(), initialDepth);
        return ProtobufUtils.createDescriptorFromProto(descriptorProto);
    }

    private static Object convertSparkValueToProtoRowValue(DataType sparkType, Object sparkValue, boolean nullable, Descriptors.Descriptor nestedTypeDescriptor) {
        if (sparkValue == null) {
            if (!nullable) {
                throw new IllegalArgumentException("Non-nullable field was null.");
            }
            return null;
        }
        DataType finalSparkType = sparkType;
        Optional<Object> protoValueFromConverter = SparkBigQueryUtil.getTypeConverterStream().filter(tc -> tc.supportsSparkType(finalSparkType)).map(tc -> tc.sparkToProtoValue(sparkValue)).findFirst();
        if (protoValueFromConverter.isPresent()) {
            return protoValueFromConverter.get();
        }
        Optional<SupportedCustomDataType> customDataType = SupportedCustomDataType.of(sparkType);
        sparkType = customDataType.map(SupportedCustomDataType::getSqlType).orElse(sparkType);
        if (customDataType.isPresent()) {
            InternalRow internalRow = sparkValue instanceof InternalRow ? (InternalRow)sparkValue : customDataType.get().serialize(sparkValue);
            return ProtobufUtils.buildSingleRowMessage((StructType)sparkType, nestedTypeDescriptor, internalRow);
        }
        if (sparkType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)sparkType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            ArrayList<Object> protoValue = new ArrayList<Object>();
            if (sparkValue instanceof ArrayData) {
                Object[] sparkArrayData;
                for (Object sparkElement : sparkArrayData = ((ArrayData)sparkValue).toObjectArray(elementType)) {
                    Object converted = ProtobufUtils.convertSparkValueToProtoRowValue(elementType, sparkElement, containsNull, nestedTypeDescriptor);
                    if (converted == null) continue;
                    protoValue.add(converted);
                }
            } else {
                IndexedSeq sparkArrayData = (IndexedSeq)sparkValue;
                int sparkArrayDataLength = sparkArrayData.length();
                for (int i = 0; i < sparkArrayDataLength; ++i) {
                    Object converted = ProtobufUtils.convertSparkValueToProtoRowValue(elementType, sparkArrayData.apply(i), containsNull, nestedTypeDescriptor);
                    if (converted == null) continue;
                    protoValue.add(converted);
                }
            }
            return protoValue;
        }
        if (sparkType instanceof StructType) {
            InternalRow internalRow = null;
            internalRow = sparkValue instanceof Row ? SparkSqlUtils.getInstance().rowToInternalRow((Row)sparkValue) : (InternalRow)sparkValue;
            return ProtobufUtils.buildSingleRowMessage((StructType)sparkType, nestedTypeDescriptor, internalRow);
        }
        if (sparkType instanceof ByteType || sparkType instanceof ShortType || sparkType instanceof IntegerType || sparkType instanceof LongType) {
            return ((Number)sparkValue).longValue();
        }
        if (sparkType instanceof TimestampType) {
            return SparkBigQueryUtil.sparkTimestampToBigQuery(sparkValue);
        }
        if (sparkType instanceof DateType) {
            return SparkBigQueryUtil.sparkDateToBigQuery(sparkValue);
        }
        if (sparkType instanceof FloatType || sparkType instanceof DoubleType) {
            return ((Number)sparkValue).doubleValue();
        }
        if (sparkType instanceof DecimalType) {
            return ProtobufUtils.convertDecimalToString(sparkValue);
        }
        if (sparkType instanceof BooleanType) {
            return sparkValue;
        }
        if (sparkType instanceof BinaryType) {
            return sparkValue;
        }
        if (sparkType instanceof StringType) {
            return sparkValue.toString();
        }
        if (sparkType instanceof MapType) {
            Map map;
            MapType mapType = (MapType)sparkType;
            StructType mapStructType = (StructType)MAP_TYPE_STRUCT_TYPE_CACHE.getUnchecked((Object)mapType);
            final ArrayList<GenericInternalRow> entries = new ArrayList<GenericInternalRow>();
            if (sparkValue instanceof Map) {
                map = (Map)sparkValue;
                map.foreach((Function1)new Function1<Tuple2, Object>(){

                    public Object apply(Tuple2 entry) {
                        return entries.add(new GenericInternalRow(new Object[]{entry._1(), entry._2()}));
                    }

                    public <A> Function1<A, Object> compose(Function1<A, Tuple2> g) {
                        return super.compose(g);
                    }

                    public <A> Function1<Tuple2, A> andThen(Function1<Object, A> g) {
                        return super.andThen(g);
                    }
                });
            } else {
                map = (MapData)sparkValue;
                Object[] keys = map.keyArray().toObjectArray(mapType.keyType());
                Object[] values = map.valueArray().toObjectArray(mapType.valueType());
                for (int i = 0; i < map.numElements(); ++i) {
                    Object key = ProtobufUtils.convertSparkValueToProtoRowValue(mapType.keyType(), keys[i], false, nestedTypeDescriptor);
                    Object value = ProtobufUtils.convertSparkValueToProtoRowValue(mapType.valueType(), values[i], mapType.valueContainsNull(), nestedTypeDescriptor);
                    entries.add(new GenericInternalRow(new Object[]{key, value}));
                }
            }
            ArrayData resultArray = ArrayData.toArrayData((Object)entries.stream().toArray());
            ArrayType resultArrayType = ArrayType.apply((DataType)mapStructType, (boolean)false);
            return ProtobufUtils.convertSparkValueToProtoRowValue((DataType)resultArrayType, resultArray, nullable, nestedTypeDescriptor);
        }
        throw new IllegalStateException("Unexpected type: " + sparkType);
    }

    private static DescriptorProtos.DescriptorProto buildDescriptorProtoWithFields(DescriptorProtos.DescriptorProto.Builder descriptorBuilder, StructField[] fields, int depth) {
        Preconditions.checkArgument((depth < 15 ? 1 : 0) != 0, (Object)"Spark Schema exceeds BigQuery maximum nesting depth.");
        int messageNumber = 1;
        for (StructField field : fields) {
            DescriptorProtos.FieldDescriptorProto.Builder protoFieldBuilder;
            String fieldName = field.name();
            DescriptorProtos.FieldDescriptorProto.Label fieldLabel = field.nullable() ? DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL : DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
            DataType sparkType = field.dataType();
            if ((sparkType = SupportedCustomDataType.of(sparkType).map(SupportedCustomDataType::getSqlType).orElse(sparkType)) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)sparkType;
                sparkType = arrayType.elementType();
                fieldLabel = DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
            }
            if (sparkType instanceof StructType || sparkType instanceof MapType) {
                String nestedName = RESERVED_NESTED_TYPE_NAME + messageNumber;
                StructField[] subFields = null;
                if (sparkType instanceof StructType) {
                    StructType structType = (StructType)sparkType;
                    subFields = structType.fields();
                } else {
                    MapType mapType = (MapType)sparkType;
                    fieldLabel = DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
                    subFields = ProtobufUtils.createMapStructFields(mapType);
                }
                DescriptorProtos.DescriptorProto.Builder nestedFieldTypeBuilder = descriptorBuilder.addNestedTypeBuilder().setName(nestedName);
                ProtobufUtils.buildDescriptorProtoWithFields(nestedFieldTypeBuilder, subFields, depth + 1);
                protoFieldBuilder = ProtobufUtils.createProtoFieldBuilder(fieldName, fieldLabel, messageNumber).setTypeName(nestedName);
            } else {
                DescriptorProtos.FieldDescriptorProto.Type fieldType = ProtobufUtils.toProtoFieldType(sparkType);
                protoFieldBuilder = ProtobufUtils.createProtoFieldBuilder(fieldName, fieldLabel, messageNumber, fieldType);
            }
            descriptorBuilder.addField(protoFieldBuilder);
            ++messageNumber;
        }
        return descriptorBuilder.build();
    }

    static StructType createMapStructType(MapType mapType) {
        return new StructType(ProtobufUtils.createMapStructFields(mapType));
    }

    @NotNull
    static StructField[] createMapStructFields(MapType mapType) {
        return new StructField[]{StructField.apply((String)"key", (DataType)mapType.keyType(), (boolean)false, (Metadata)Metadata.empty()), StructField.apply((String)"value", (DataType)mapType.valueType(), (boolean)mapType.valueContainsNull(), (Metadata)Metadata.empty())};
    }

    private static DescriptorProtos.FieldDescriptorProto.Type toProtoFieldType(DataType sparkType) {
        Optional<DescriptorProtos.FieldDescriptorProto.Type> protoFieldType = SparkBigQueryUtil.getTypeConverterStream().filter(tc -> tc.supportsSparkType(sparkType)).map(tc -> tc.toProtoFieldType(sparkType)).findFirst();
        if (protoFieldType.isPresent()) {
            return protoFieldType.get();
        }
        if (sparkType instanceof MapType) {
            // empty if block
        }
        if (sparkType instanceof DecimalType) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        return (DescriptorProtos.FieldDescriptorProto.Type)Preconditions.checkNotNull((Object)SparkToProtoType.get((Object)sparkType.json()), (Object)new IllegalStateException("Unexpected type: " + sparkType));
    }

    private static String convertDecimalToString(Object decimal) {
        BigDecimal bigDecimal = decimal instanceof Decimal ? ((Decimal)decimal).toJavaBigDecimal() : (BigDecimal)decimal;
        return bigDecimal.toPlainString();
    }
}

