/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.spark.ml.linalg.SQLDataTypes;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.UserDefinedType;

public enum SupportedCustomDataType {
    SPARK_ML_VECTOR("vector", SQLDataTypes.VectorType()),
    SPARK_ML_MATRIX("matrix", SQLDataTypes.MatrixType());

    private final String typeMarker;
    private final UserDefinedType sparkDataType;

    private SupportedCustomDataType(String typeMarker, DataType sparkDataType) {
        this.typeMarker = "{spark.type=" + typeMarker + "}";
        this.sparkDataType = (UserDefinedType)sparkDataType;
    }

    public UserDefinedType getSparkDataType() {
        return this.sparkDataType;
    }

    public String getTypeMarker() {
        return this.typeMarker;
    }

    public DataType getSqlType() {
        return this.sparkDataType.sqlType();
    }

    public InternalRow serialize(Object obj) {
        return (InternalRow)this.sparkDataType.serialize(obj);
    }

    public static Optional<SupportedCustomDataType> of(DataType dataType) {
        Preconditions.checkNotNull((Object)dataType);
        return Stream.of(SupportedCustomDataType.values()).filter(supportedCustomDataType -> supportedCustomDataType.sparkDataType.equals((Object)dataType)).findFirst();
    }

    public static Optional<SupportedCustomDataType> forDescription(String description) {
        Preconditions.checkNotNull((Object)description, (Object)"description cannot be null");
        return Stream.of(SupportedCustomDataType.values()).filter(dataType -> description.endsWith(dataType.typeMarker)).findFirst();
    }

    public static DataType toSqlType(DataType dataType) {
        return SupportedCustomDataType.of(dataType).map(SupportedCustomDataType::getSqlType).orElse(dataType);
    }
}

