/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write;

import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.write.BigQueryInsertableRelationBase;
import com.google.cloud.spark.bigquery.write.DataSourceWriterContextPartitionHandler;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectDataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.BigQueryIndirectDataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.DataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;

public class BigQueryDataSourceWriterInsertableRelation
extends BigQueryInsertableRelationBase {
    private final Injector injector;

    public BigQueryDataSourceWriterInsertableRelation(BigQueryClient bigQueryClient, SQLContext sqlContext, SparkBigQueryConfig config, Injector injector) {
        super(bigQueryClient, sqlContext, config);
        this.injector = injector;
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        block12: {
            this.logger.debug("Inserting data={}, overwrite={}", data, (Object)overwrite);
            DataSourceWriterContext ctx = null;
            SparkBigQueryConfig.WriteMethod writeMethod = this.config.getWriteMethod();
            if (writeMethod == SparkBigQueryConfig.WriteMethod.DIRECT) {
                ctx = (DataSourceWriterContext)this.injector.getInstance(BigQueryDirectDataSourceWriterContext.class);
            } else if (writeMethod == SparkBigQueryConfig.WriteMethod.INDIRECT) {
                ctx = (DataSourceWriterContext)this.injector.getInstance(BigQueryIndirectDataSourceWriterContext.class);
            } else {
                throw new IllegalArgumentException("Unknown write method " + (Object)((Object)writeMethod));
            }
            try {
                JavaRDD rowsRDD = data.toJavaRDD();
                int numPartitions = rowsRDD.getNumPartitions();
                if (numPartitions == 0) {
                    Schema bigQuerySchema = SchemaConverters.from(SchemaConvertersConfiguration.from(this.config)).toBigQuerySchema(data.schema());
                    this.bigQueryClient.createTableIfNeeded(this.getTableId(), bigQuerySchema, (BigQueryClient.CreateTableOptions)this.config);
                    break block12;
                }
                DataSourceWriterContextPartitionHandler partitionHandler = new DataSourceWriterContextPartitionHandler(ctx.createWriterContextFactory(), System.currentTimeMillis());
                JavaRDD writerCommitMessagesRDD = rowsRDD.mapPartitionsWithIndex((Function2)partitionHandler, false);
                WriterCommitMessageContext[] writerCommitMessages = writerCommitMessagesRDD.collect().toArray(new WriterCommitMessageContext[0]);
                if (writerCommitMessages.length == numPartitions) {
                    List errors = Arrays.stream(writerCommitMessages).filter(msg -> msg.getError().isPresent()).map(msg -> msg.getError().get()).collect(Collectors.toList());
                    if (errors.isEmpty()) {
                        ctx.commit(writerCommitMessages);
                        break block12;
                    }
                    if (errors.size() == 1) {
                        this.logger.error("Encountered errors in one partition, aborting the write", (Throwable)errors.get(0));
                    } else {
                        this.logger.error("Encountered errors in " + errors.size() + " partitions, aborting the write. Errors listed below");
                        int i = 1;
                        for (Exception e : errors) {
                            this.logger.error("Error #" + i, (Throwable)e);
                            ++i;
                        }
                    }
                    throw new BigQueryConnectorException("Write error in partitions.", (Throwable)errors.get(0));
                }
                ctx.abort(writerCommitMessages);
                throw new BigQueryConnectorException(String.format("It seems that %s out of %s partitions have failed, aborting", numPartitions - writerCommitMessages.length, numPartitions));
            }
            catch (Exception e) {
                ctx.abort(new WriterCommitMessageContext[0]);
                throw new BigQueryConnectorException("unexpected issue trying to save " + data, (Throwable)e);
            }
        }
    }
}

