/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.pushdowns.SparkBigQueryPushdown;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ServiceLoader;
import org.apache.spark.sql.SparkSession;

public class BigQueryConnectorUtils {
    private static Supplier<SparkBigQueryPushdown> sparkBigQueryPushdownSupplier = Suppliers.memoize(BigQueryConnectorUtils::createSparkBigQueryPushdown);

    private BigQueryConnectorUtils() {
    }

    public static void enablePushdownSession(SparkSession spark) {
        SparkBigQueryPushdown sparkBigQueryPushdown = (SparkBigQueryPushdown)sparkBigQueryPushdownSupplier.get();
        sparkBigQueryPushdown.enable(spark);
    }

    public static void disablePushdownSession(SparkSession spark) {
        SparkBigQueryPushdown sparkBigQueryPushdown = (SparkBigQueryPushdown)sparkBigQueryPushdownSupplier.get();
        sparkBigQueryPushdown.disable(spark);
    }

    static SparkBigQueryPushdown createSparkBigQueryPushdown() {
        String sparkVersion = SparkSession.active().version();
        ServiceLoader<SparkBigQueryPushdown> loader = ServiceLoader.load(SparkBigQueryPushdown.class);
        for (SparkBigQueryPushdown p : loader) {
            if (!p.supportsSparkVersion(sparkVersion)) continue;
            return p;
        }
        throw new IllegalStateException(String.format("Could not find an implementation of %s that supports Spark version %s", SparkBigQueryPushdown.class.getName(), sparkVersion));
    }
}

