/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClientModule;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryConnectorModule;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class InjectorBuilder {
    private SparkSession spark = SparkSession.active();
    private Optional<StructType> schema = Optional.empty();
    private Map<String, String> options = ImmutableMap.of();
    private Map<String, String> customDefaults = ImmutableMap.of();
    private boolean tableIsMandatory = true;
    private DataSourceVersion dataSourceVersion = DataSourceVersion.V2;
    private Optional<SparkBigQueryConfig> config = Optional.empty();

    public InjectorBuilder withSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public InjectorBuilder withSchema(StructType schema) {
        this.schema = Optional.ofNullable(schema);
        return this;
    }

    public InjectorBuilder withOptions(Map<String, String> options) {
        this.options = ImmutableMap.copyOf(options);
        return this;
    }

    public InjectorBuilder withTableIsMandatory(boolean tableIsMandatory) {
        this.tableIsMandatory = tableIsMandatory;
        return this;
    }

    public InjectorBuilder withDataSourceVersion(DataSourceVersion dataSourceVersion) {
        this.dataSourceVersion = dataSourceVersion;
        return this;
    }

    public InjectorBuilder withCustomDefaults(Map<String, String> customDefaults) {
        this.customDefaults = customDefaults;
        return this;
    }

    public InjectorBuilder withConfig(SparkBigQueryConfig config) {
        this.config = Optional.of(config);
        return this;
    }

    public Injector build() {
        return Guice.createInjector((Module[])new Module[]{new BigQueryClientModule(), new SparkBigQueryConnectorModule(this.spark, this.options, this.customDefaults, this.schema, this.dataSourceVersion, this.tableIsMandatory, this.config)});
    }
}

