/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.common.base.Objects;
import java.io.Serializable;

public class SchemaConvertersConfiguration
implements Serializable {
    private final boolean allowMapTypeConversion;

    private SchemaConvertersConfiguration(boolean allowMapTypeConversion) {
        this.allowMapTypeConversion = allowMapTypeConversion;
    }

    public static SchemaConvertersConfiguration from(SparkBigQueryConfig config) {
        return SchemaConvertersConfiguration.of(config.getAllowMapTypeConversion());
    }

    public static SchemaConvertersConfiguration of(boolean allowMapTypeConversion) {
        return new SchemaConvertersConfiguration(allowMapTypeConversion);
    }

    public static SchemaConvertersConfiguration createDefault() {
        return new SchemaConvertersConfiguration(SparkBigQueryConfig.ALLOW_MAP_TYPE_CONVERSION_DEFAULT);
    }

    public boolean getAllowMapTypeConversion() {
        return this.allowMapTypeConversion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaConvertersConfiguration that = (SchemaConvertersConfiguration)o;
        return Objects.equal((Object)this.allowMapTypeConversion, (Object)that.allowMapTypeConversion);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.allowMapTypeConversion});
    }

    public String toString() {
        return "SchemaConvertersConfiguration{allowMapTypeConversion=" + this.allowMapTypeConversion + '}';
    }
}

