/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.write.IntermediateDataCleaner;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectDataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.BigQueryIndirectDataSourceWriterContext;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class BigQueryDataSourceWriterModule
implements Module {
    private final SparkBigQueryConfig tableConfig;
    private final String writeUUID;
    private final StructType sparkSchema;
    private final SaveMode mode;

    public BigQueryDataSourceWriterModule(SparkBigQueryConfig tableConfig, String writeUUID, StructType sparkSchema, SaveMode mode) {
        this.tableConfig = tableConfig;
        this.writeUUID = writeUUID;
        this.sparkSchema = sparkSchema;
        this.mode = mode;
    }

    public void configure(Binder binder) {
    }

    @Singleton
    @Provides
    public BigQueryDirectDataSourceWriterContext provideDirectDataSourceWriterContext(BigQueryClient bigQueryClient, BigQueryClientFactory bigQueryWriteClientFactory, SparkSession spark) {
        TableId tableId = this.tableConfig.getTableId();
        RetrySettings bigqueryDataWriteHelperRetrySettings = this.tableConfig.getBigqueryDataWriteHelperRetrySettings();
        return new BigQueryDirectDataSourceWriterContext(bigQueryClient, bigQueryWriteClientFactory, tableId, this.writeUUID, this.mode, this.sparkSchema, bigqueryDataWriteHelperRetrySettings, (com.google.common.base.Optional<String>)com.google.common.base.Optional.fromJavaUtil(this.tableConfig.getTraceId()), this.tableConfig.getEnableModeCheckForSchemaFields(), this.tableConfig.getBigQueryTableLabels(), SchemaConvertersConfiguration.from(this.tableConfig), this.tableConfig.getKmsKeyName(), this.tableConfig.isWriteAtLeastOnce() && !this.mode.equals((Object)SaveMode.Overwrite), this.tableConfig.getPartitionOverwriteModeValue(), spark.sparkContext());
    }

    @Singleton
    @Provides
    public BigQueryIndirectDataSourceWriterContext provideIndirectDataSourceWriterContext(BigQueryClient bigQueryClient, SparkSession spark) throws IOException {
        Path gcsPath = SparkBigQueryUtil.createGcsPath(this.tableConfig, spark.sparkContext().hadoopConfiguration(), spark.sparkContext().applicationId());
        Optional<IntermediateDataCleaner> intermediateDataCleaner = this.tableConfig.getTemporaryGcsBucket().map(ignored -> new IntermediateDataCleaner(gcsPath, spark.sparkContext().hadoopConfiguration()));
        intermediateDataCleaner.ifPresent(cleaner -> Runtime.getRuntime().addShutdownHook((Thread)cleaner));
        return new BigQueryIndirectDataSourceWriterContext(bigQueryClient, this.tableConfig, spark.sparkContext().hadoopConfiguration(), this.sparkSchema, this.writeUUID, this.mode, gcsPath, intermediateDataCleaner, spark.sparkContext());
    }
}

