/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.cloud.spark.bigquery.AvroSchemaConverter;
import com.google.cloud.spark.bigquery.write.context.BigQueryIndirectWriterCommitMessageContext;
import com.google.cloud.spark.bigquery.write.context.DataWriterContext;
import com.google.cloud.spark.bigquery.write.context.IntermediateRecordWriter;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryIndirectDataWriterContext
implements DataWriterContext<InternalRow> {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryIndirectDataWriterContext.class);
    Path path;
    FileSystem fs;
    FSDataOutputStream outputStream;
    StructType sparkSchema;
    Schema avroSchema;
    IntermediateRecordWriter intermediateRecordWriter;
    private int partitionId;

    protected BigQueryIndirectDataWriterContext(int partitionId, Path path, FileSystem fs, StructType sparkSchema, Schema avroSchema, IntermediateRecordWriter intermediateRecordWriter) {
        this.partitionId = partitionId;
        this.path = path;
        this.fs = fs;
        this.sparkSchema = sparkSchema;
        this.avroSchema = avroSchema;
        this.intermediateRecordWriter = intermediateRecordWriter;
    }

    @Override
    public void write(InternalRow record) throws IOException {
        GenericData.Record avroRecord = AvroSchemaConverter.sparkRowToAvroGenericData(record, this.sparkSchema, this.avroSchema);
        this.intermediateRecordWriter.write((GenericRecord)avroRecord);
    }

    @Override
    public WriterCommitMessageContext commit() throws IOException {
        this.intermediateRecordWriter.close();
        return new BigQueryIndirectWriterCommitMessageContext(this.path.toString());
    }

    @Override
    public void abort() throws IOException {
        logger.warn("Writing of partition {} has been aborted, attempting to delete {}", (Object)this.partitionId, (Object)this.path);
        this.fs.delete(this.path, false);
    }

    @Override
    public void close() throws IOException {
    }
}

