/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.pushdowns;

import com.google.cloud.bigquery.connector.common.BigQueryPushdownException;
import com.google.cloud.bigquery.connector.common.BigQueryPushdownUnsupportedException;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.direct.BigQueryRDDFactory;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation;
import com.google.cloud.spark.bigquery.pushdowns.AggregateQuery;
import com.google.cloud.spark.bigquery.pushdowns.BigQuerySQLQuery;
import com.google.cloud.spark.bigquery.pushdowns.BinaryOperationExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.CastExpressionExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.FilterQuery;
import com.google.cloud.spark.bigquery.pushdowns.FilterQuery$;
import com.google.cloud.spark.bigquery.pushdowns.JoinExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.JoinQuery;
import com.google.cloud.spark.bigquery.pushdowns.LeftSemiJoinQuery;
import com.google.cloud.spark.bigquery.pushdowns.ProjectQuery;
import com.google.cloud.spark.bigquery.pushdowns.SortLimitQuery;
import com.google.cloud.spark.bigquery.pushdowns.SourceQuery;
import com.google.cloud.spark.bigquery.pushdowns.SourceQuery$;
import com.google.cloud.spark.bigquery.pushdowns.SparkBigQueryPushdownUtil$;
import com.google.cloud.spark.bigquery.pushdowns.SparkExpressionConverter;
import com.google.cloud.spark.bigquery.pushdowns.SparkExpressionFactory;
import com.google.cloud.spark.bigquery.pushdowns.SparkPlanFactory;
import com.google.cloud.spark.bigquery.pushdowns.UnaryOperationExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.UnionOperationExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.WindowQuery;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.Limit$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud!\u0002\n\u0014\u0003\u0003\u0001\u0003\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0002U\u0011\u0019)\u0007\u0001)A\u0007+\")a\r\u0001C!O\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011Q\f\u0001\u0007\u0002\u0005}\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003W\u0002a\u0011AA7\u0005A\u0011\u0015nZ)vKJL8\u000b\u001e:bi\u0016<\u0017P\u0003\u0002\u0015+\u0005I\u0001/^:iI><hn\u001d\u0006\u0003-]\t\u0001BY5hcV,'/\u001f\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\u000b\rdw.\u001e3\u000b\u0005qi\u0012AB4p_\u001edWMC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011E\u000f\t\u0003E]r!a\t\u001b\u000f\u0005\u0011\ndBA\u00130\u001d\t1CF\u0004\u0002(U5\t\u0001F\u0003\u0002*?\u00051AH]8pizJ\u0011aK\u0001\u0004_J<\u0017BA\u0017/\u0003\u0019\t\u0007/Y2iK*\t1&\u0003\u0002\u0019a)\u0011QFL\u0005\u0003eM\n1a]9m\u0015\tA\u0002'\u0003\u00026m\u00059\u0001/Y2lC\u001e,'B\u0001\u001a4\u0013\tA\u0014H\u0001\u0005TiJ\fG/Z4z\u0015\t)d\u0007\u0005\u0002<}5\tAH\u0003\u0002>g\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002@y\t9Aj\\4hS:<\u0017aE3yaJ,7o]5p]\u000e{gN^3si\u0016\u0014\bC\u0001\"D\u001b\u0005\u0019\u0012B\u0001#\u0014\u0005a\u0019\u0006/\u0019:l\u000bb\u0004(/Z:tS>t7i\u001c8wKJ$XM]\u0001\u0012Kb\u0004(/Z:tS>tg)Y2u_JL\bC\u0001\"H\u0013\tA5C\u0001\fTa\u0006\u00148.\u0012=qe\u0016\u001c8/[8o\r\u0006\u001cGo\u001c:z\u0003A\u0019\b/\u0019:l!2\fgNR1di>\u0014\u0018\u0010\u0005\u0002C\u0017&\u0011Aj\u0005\u0002\u0011'B\f'o\u001b)mC:4\u0015m\u0019;pef\fa\u0001P5oSRtD\u0003B(Q#J\u0003\"A\u0011\u0001\t\u000b\u0001#\u0001\u0019A!\t\u000b\u0015#\u0001\u0019\u0001$\t\u000b%#\u0001\u0019\u0001&\u0002\u000b\u0005d\u0017.Y:\u0016\u0003U\u00032AV.^\u001b\u00059&B\u0001-Z\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u00025\u0006)1oY1mC&\u0011Al\u0016\u0002\t\u0013R,'/\u0019;peB\u0011aL\u0019\b\u0003?\u0002\u0004\"aJ-\n\u0005\u0005L\u0016A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y-\u0002\r\u0005d\u0017.Y:!\u0003\u0015\t\u0007\u000f\u001d7z)\tAg\u000fE\u0002j[Bt!A\u001b7\u000f\u0005\u001dZ\u0017\"\u0001.\n\u0005UJ\u0016B\u00018p\u0005\r\u0019V-\u001d\u0006\u0003ke\u0003\"!\u001d;\u000e\u0003IT!a\u001d\u001c\u0002\u0013\u0015DXmY;uS>t\u0017BA;s\u0005%\u0019\u0006/\u0019:l!2\fg\u000eC\u0003x\u000f\u0001\u0007\u00010\u0001\u0003qY\u0006t\u0007cA=\u0002\u00025\t!P\u0003\u0002|y\u00069An\\4jG\u0006d'BA?\u007f\u0003\u0015\u0001H.\u00198t\u0015\tyh'\u0001\u0005dCR\fG._:u\u0013\r\t\u0019A\u001f\u0002\f\u0019><\u0017nY1m!2\fg.A\niCN,fn];qa>\u0014H/\u001a3O_\u0012,7\u000f\u0006\u0003\u0002\n\u0005E\u0001\u0003BA\u0006\u0003\u001bi\u0011!W\u0005\u0004\u0003\u001fI&a\u0002\"p_2,\u0017M\u001c\u0005\u0006o\"\u0001\r\u0001_\u0001!O\u0016tWM]1uKN\u0003\u0018M]6QY\u0006tgI]8n\u0019><\u0017nY1m!2\fg\u000eF\u0002i\u0003/AQa^\u0005A\u0002a\f!c\u00197fC:,\u0006\u000fT8hS\u000e\fG\u000e\u00157b]R\u0019\u00010!\b\t\u000b]T\u0001\u0019\u0001=\u0002K\u001d,G\u000fV8q\u001b>\u001cH\u000f\u0015:pU\u0016\u001cGOT8eK^KG\u000f[!mS\u0006\u001cX\rZ\"bgR\u001cH\u0003BA\u0012\u0003_\u0001b!a\u0003\u0002&\u0005%\u0012bAA\u00143\n1q\n\u001d;j_:\u00042!_A\u0016\u0013\r\tiC\u001f\u0002\b!J|'.Z2u\u0011\u001598\u00021\u0001y\u0003\r:WM\\3sCR,')[4Rk\u0016\u0014\u0018\u0010\u00157b]\u001a\u0013x.\u001c'pO&\u001c\u0017\r\u001c)mC:$2\u0001]A\u001b\u0011\u00159H\u00021\u0001y\u0003\t:WM\\3sCR,\u0007K]8kK\u000e$\b\u000b\\1o\rJ|W\u000eT8hS\u000e\fG\u000e\u00157b]R)\u0001/a\u000f\u0002>!)q/\u0004a\u0001q\"9\u0011qH\u0007A\u0002\u0005%\u0012a\u00039s_*,7\r\u001e(pI\u0016\fQbZ3u%\u0012#e)Y2u_JLH\u0003BA#\u0003'\u0002b!a\u0003\u0002&\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055S#\u0001\u0004eSJ,7\r^\u0005\u0005\u0003#\nYE\u0001\nCS\u001e\fV/\u001a:z%\u0012#e)Y2u_JL\bbBA+\u001d\u0001\u0007\u0011qK\u0001\ncV,'/\u001f*p_R\u00042AQA-\u0013\r\tYf\u0005\u0002\u0011\u0005&<\u0017+^3ssN\u000bF*U;fef\fAeZ3oKJ\fG/Z)vKJLhI]8n!2\fgNR8s\t\u0006$\u0018mU8ve\u000e,gK\r\u000b\u0005\u0003C\n\u0019\u0007\u0005\u0004\u0002\f\u0005\u0015\u0012q\u000b\u0005\u0006o>\u0001\r\u0001_\u0001\u0016O\u0016tWM]1uKF+XM]=Ge>l\u0007\u000b\\1o)\u0011\t\t'!\u001b\t\u000b]\u0004\u0002\u0019\u0001=\u0002!\r\u0014X-\u0019;f+:LwN\\)vKJLH\u0003BA1\u0003_Bq!!\u001d\u0012\u0001\u0004\t\u0019(\u0001\u0005dQ&dGM]3o!\rIW\u000e\u001f")
public abstract class BigQueryStrategy
extends SparkStrategy {
    private final SparkExpressionConverter expressionConverter;
    private final SparkExpressionFactory expressionFactory;
    private final SparkPlanFactory sparkPlanFactory;
    private final Iterator<String> alias;

    public final Iterator<String> alias() {
        return this.alias;
    }

    public Seq<SparkPlan> apply(LogicalPlan plan) {
        Nil$ nil$;
        if (this.hasUnsupportedNodes(plan)) {
            return Nil$.MODULE$;
        }
        try {
            nil$ = this.generateSparkPlanFromLogicalPlan(plan);
        }
        catch (Exception e) {
            this.logDebug((Function0 & Serializable)() -> "Query pushdown failed: ", e);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public boolean hasUnsupportedNodes(LogicalPlan plan) {
        boolean bl;
        Object object = new Object();
        try {
            plan.foreach((Function1 & Serializable)x0$1 -> {
                BigQueryStrategy.$anonfun$hasUnsupportedNodes$1(this, object, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Seq<SparkPlan> generateSparkPlanFromLogicalPlan(LogicalPlan plan) {
        Option<Project> projectNodeAddedBySpark;
        LogicalPlan cleanedPlan = this.cleanUpLogicalPlan(plan);
        if (SparkBigQueryUtil.isDataFrameShowMethodInStackTrace() && (projectNodeAddedBySpark = this.getTopMostProjectNodeWithAliasedCasts(cleanedPlan)).isDefined()) {
            if (!SparkBigQueryPushdownUtil$.MODULE$.isLimitTheChildToProjectNode((Project)projectNodeAddedBySpark.get())) {
                cleanedPlan = SparkBigQueryPushdownUtil$.MODULE$.addProjectNodeToThePlan(cleanedPlan, (Project)projectNodeAddedBySpark.get(), this.expressionFactory);
                projectNodeAddedBySpark = this.getTopMostProjectNodeWithAliasedCasts(cleanedPlan);
            }
            return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{this.generateProjectPlanFromLogicalPlan(cleanedPlan, (Project)projectNodeAddedBySpark.get())}));
        }
        return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{this.generateBigQueryPlanFromLogicalPlan(cleanedPlan)}));
    }

    public LogicalPlan cleanUpLogicalPlan(LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    Project project = (Project)A1;
                    Seq seq = project.projectList();
                    LogicalPlan child = project.child();
                    if (Nil$.MODULE$.equals(seq)) {
                        object = child;
                        return (B1)object;
                    }
                }
                if (A1 instanceof SubqueryAlias) {
                    SubqueryAlias subqueryAlias = (SubqueryAlias)A1;
                    LogicalPlan child = subqueryAlias.child();
                    object = child;
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Project project;
                Seq seq;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Project && Nil$.MODULE$.equals(seq = (project = (Project)logicalPlan).projectList()) ? true : logicalPlan instanceof SubqueryAlias;
                return bl;
            }
        });
    }

    public Option<Project> getTopMostProjectNodeWithAliasedCasts(LogicalPlan plan) {
        None$ none$;
        Object object = new Object();
        try {
            plan.foreach((Function1 & Serializable)x0$1 -> {
                BigQueryStrategy.$anonfun$getTopMostProjectNodeWithAliasedCasts$1(object, x0$1);
                return BoxedUnit.UNIT;
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public SparkPlan generateBigQueryPlanFromLogicalPlan(LogicalPlan plan) {
        Option<BigQuerySQLQuery> queryRoot = this.generateQueryFromPlan(plan);
        Option<BigQueryRDDFactory> bigQueryRDDFactory = this.getRDDFactory((BigQuerySQLQuery)queryRoot.get());
        return (SparkPlan)this.sparkPlanFactory.createBigQueryPlan((BigQuerySQLQuery)queryRoot.get(), (BigQueryRDDFactory)bigQueryRDDFactory.get()).getOrElse((Function0 & Serializable)() -> {
            throw new BigQueryPushdownException("Could not generate BigQuery physical plan from query");
        });
    }

    public SparkPlan generateProjectPlanFromLogicalPlan(LogicalPlan plan, Project projectNode) {
        LogicalPlan planWithoutProjectNode = SparkBigQueryPushdownUtil$.MODULE$.removeProjectNodeFromPlan(plan, projectNode);
        SparkPlan bigQueryPlan = this.generateBigQueryPlanFromLogicalPlan(planWithoutProjectNode);
        return (SparkPlan)this.sparkPlanFactory.createProjectPlan(projectNode, bigQueryPlan).getOrElse((Function0 & Serializable)() -> {
            throw new BigQueryPushdownException("Could not generate BigQuery physical plan from query");
        });
    }

    public Option<BigQueryRDDFactory> getRDDFactory(BigQuerySQLQuery queryRoot) {
        SourceQuery sourceQuery = (SourceQuery)queryRoot.find(new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends BigQuerySQLQuery, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SourceQuery) {
                    SourceQuery sourceQuery = (SourceQuery)A1;
                    object = sourceQuery;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(BigQuerySQLQuery x1) {
                BigQuerySQLQuery bigQuerySQLQuery = x1;
                boolean bl = bigQuerySQLQuery instanceof SourceQuery;
                return bl;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new BigQueryPushdownException("Something went wrong: a query tree was generated with no SourceQuery.");
        });
        return new Some((Object)sourceQuery.bigQueryRDDFactory());
    }

    public abstract Option<BigQuerySQLQuery> generateQueryFromPlanForDataSourceV2(LogicalPlan var1);

    public Option<BigQuerySQLQuery> generateQueryFromPlan(LogicalPlan plan) {
        Union union;
        Option<Seq<LogicalPlan>> option;
        Option<LogicalPlan> option2;
        Option<LogicalPlan> option3;
        LogicalRelation logicalRelation;
        BaseRelation bqRelation;
        Option<BigQuerySQLQuery> option4;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof NamedRelation) {
            option4 = this.generateQueryFromPlanForDataSourceV2(plan);
        } else if (logicalPlan instanceof LogicalRelation && (bqRelation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof DirectBigQueryRelation) {
            DirectBigQueryRelation directBigQueryRelation = (DirectBigQueryRelation)bqRelation;
            option4 = new Some((Object)new SourceQuery(this.expressionConverter, this.expressionFactory, directBigQueryRelation.getBigQueryRDDFactory(), directBigQueryRelation.getTableName(), (Seq<Attribute>)logicalRelation.output(), (String)this.alias().next(), SourceQuery$.MODULE$.apply$default$7()));
        } else if (logicalPlan != null && !(option3 = UnaryOperationExtractor$.MODULE$.unapply(logicalPlan)).isEmpty()) {
            LogicalPlan node = (LogicalPlan)option3.get();
            option4 = this.generateQueryFromPlan((LogicalPlan)node.children().head()).map((Function1 & Serializable)subQuery -> {
                Option option;
                Option option2;
                void var3_20;
                boolean bl = false;
                GlobalLimit globalLimit = null;
                boolean bl2 = false;
                Sort sort = null;
                LogicalPlan logicalPlan = plan;
                if (logicalPlan instanceof Filter) {
                    Filter filter = (Filter)logicalPlan;
                    Expression condition = filter.condition();
                    FilterQuery filterQuery = new FilterQuery($this.expressionConverter, $this.expressionFactory, (Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{condition}))), (BigQuerySQLQuery)subQuery, (String)this.alias().next(), FilterQuery$.MODULE$.apply$default$6());
                    return var3_20;
                }
                if (logicalPlan instanceof Project) {
                    Project project = (Project)logicalPlan;
                    Seq fields = project.projectList();
                    ProjectQuery projectQuery = new ProjectQuery($this.expressionConverter, $this.expressionFactory, (Seq<NamedExpression>)fields, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                    return var3_20;
                }
                if (logicalPlan instanceof Aggregate) {
                    Aggregate aggregate = (Aggregate)logicalPlan;
                    Seq groups = aggregate.groupingExpressions();
                    Seq fields = aggregate.aggregateExpressions();
                    AggregateQuery aggregateQuery = new AggregateQuery($this.expressionConverter, $this.expressionFactory, (Seq<NamedExpression>)fields, (Seq<Expression>)groups, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                    return var3_20;
                }
                if (logicalPlan instanceof GlobalLimit) {
                    bl = true;
                    globalLimit = (GlobalLimit)logicalPlan;
                    Option option3 = Limit$.MODULE$.unapply(globalLimit);
                    if (!option3.isEmpty()) {
                        LogicalPlan logicalPlan2;
                        GlobalLimit globalLimit2;
                        Option option4;
                        Expression limitExpr = (Expression)((Tuple2)option3.get())._1();
                        LogicalPlan logicalPlan3 = (LogicalPlan)((Tuple2)option3.get())._2();
                        if (logicalPlan3 instanceof GlobalLimit && !(option4 = Limit$.MODULE$.unapply(globalLimit2 = (GlobalLimit)logicalPlan3)).isEmpty() && (logicalPlan2 = (LogicalPlan)((Tuple2)option4.get())._2()) instanceof Sort) {
                            Sort sort2 = (Sort)logicalPlan2;
                            Seq orderExpr = sort2.order();
                            boolean bl3 = sort2.global();
                            if (bl3) {
                                SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                                return var3_20;
                            }
                        }
                    }
                }
                if (bl && !(option2 = Limit$.MODULE$.unapply(globalLimit)).isEmpty()) {
                    Expression limitExpr = (Expression)((Tuple2)option2.get())._1();
                    LogicalPlan logicalPlan4 = (LogicalPlan)((Tuple2)option2.get())._2();
                    if (logicalPlan4 instanceof Sort) {
                        Sort sort3 = (Sort)logicalPlan4;
                        Seq orderExpr = sort3.order();
                        boolean bl4 = sort3.global();
                        if (bl4) {
                            SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                            return var3_20;
                        }
                    }
                }
                if (bl && !(option = Limit$.MODULE$.unapply(globalLimit)).isEmpty()) {
                    Expression limitExpr = (Expression)((Tuple2)option.get())._1();
                    SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)((Seq)Seq$.MODULE$.empty()), (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                    return var3_20;
                }
                if (logicalPlan instanceof Sort) {
                    GlobalLimit globalLimit3;
                    Option option5;
                    bl2 = true;
                    sort = (Sort)logicalPlan;
                    Seq orderExpr = sort.order();
                    boolean bl5 = sort.global();
                    LogicalPlan logicalPlan5 = sort.child();
                    if (bl5 && logicalPlan5 instanceof GlobalLimit && !(option5 = Limit$.MODULE$.unapply(globalLimit3 = (GlobalLimit)logicalPlan5)).isEmpty()) {
                        Expression limitExpr = (Expression)((Tuple2)option5.get())._1();
                        SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                        return var3_20;
                    }
                }
                if (bl2) {
                    Seq orderExpr = sort.order();
                    boolean bl6 = sort.global();
                    if (bl6) {
                        SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)None$.MODULE$, (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                        return var3_20;
                    }
                }
                if (!(logicalPlan instanceof Window)) {
                    BigQuerySQLQuery bigQuerySQLQuery = subQuery;
                    return var3_20;
                }
                Window window = (Window)logicalPlan;
                Seq windowExpressions = window.windowExpressions();
                WindowQuery windowQuery = new WindowQuery($this.expressionConverter, $this.expressionFactory, (Seq<NamedExpression>)windowExpressions, (BigQuerySQLQuery)subQuery, (Option<Seq<Attribute>>)(plan.output().isEmpty() ? None$.MODULE$ : new Some((Object)plan.output())), (String)this.alias().next());
                return var3_20;
            });
        } else if (logicalPlan != null && !(option2 = BinaryOperationExtractor$.MODULE$.unapply(logicalPlan)).isEmpty()) {
            LogicalPlan node = (LogicalPlan)option2.get();
            option4 = this.generateQueryFromPlan((LogicalPlan)node.children().head()).flatMap((Function1 & Serializable)l -> this.generateQueryFromPlan((LogicalPlan)node.children().apply(1)).map((Function1 & Serializable)r -> {
                void var5_14;
                LogicalPlan logicalPlan = plan;
                if (!(logicalPlan instanceof Join)) throw new MatchError((Object)logicalPlan);
                Join join = (Join)logicalPlan;
                Option<Tuple2<JoinType, Option<Expression>>> option = JoinExtractor$.MODULE$.unapply(join);
                if (option.isEmpty()) throw new MatchError((Object)logicalPlan);
                JoinType joinType = (JoinType)((Tuple2)option.get())._1();
                Option condition = (Option)((Tuple2)option.get())._2();
                JoinType joinType2 = joinType;
                boolean bl = Inner$.MODULE$.equals(joinType2) ? true : (LeftOuter$.MODULE$.equals(joinType2) ? true : (RightOuter$.MODULE$.equals(joinType2) ? true : (FullOuter$.MODULE$.equals(joinType2) ? true : Cross$.MODULE$.equals(joinType2))));
                if (bl) {
                    JoinQuery joinQuery = new JoinQuery($this.expressionConverter, $this.expressionFactory, (BigQuerySQLQuery)l, (BigQuerySQLQuery)r, (Option<Expression>)condition, joinType, (String)this.alias().next());
                    return var5_14;
                } else if (LeftSemi$.MODULE$.equals(joinType2)) {
                    LeftSemiJoinQuery leftSemiJoinQuery = new LeftSemiJoinQuery($this.expressionConverter, $this.expressionFactory, (BigQuerySQLQuery)l, (BigQuerySQLQuery)r, (Option<Expression>)condition, false, this.alias());
                    return var5_14;
                } else {
                    if (!LeftAnti$.MODULE$.equals(joinType2)) throw new MatchError((Object)BoxedUnit.UNIT);
                    LeftSemiJoinQuery leftSemiJoinQuery = new LeftSemiJoinQuery($this.expressionConverter, $this.expressionFactory, (BigQuerySQLQuery)l, (BigQuerySQLQuery)r, (Option<Expression>)condition, true, this.alias());
                }
                return var5_14;
            }));
        } else if (logicalPlan instanceof Union && !(option = UnionOperationExtractor$.MODULE$.unapply(union = (Union)logicalPlan)).isEmpty()) {
            Seq children = (Seq)option.get();
            option4 = this.createUnionQuery((Seq<LogicalPlan>)children);
        } else if (logicalPlan instanceof Expand) {
            Expand expand = (Expand)logicalPlan;
            Seq projections = expand.projections();
            Seq output = expand.output();
            LogicalPlan child = expand.child();
            Seq projectPlan = (Seq)projections.map((Function1 & Serializable)p -> {
                Seq<NamedExpression> namedExpressions = SparkBigQueryPushdownUtil$.MODULE$.convertExpressionToNamedExpression((Seq<Expression>)p, (Seq<Attribute>)output, $this.expressionFactory);
                return new Project(namedExpressions, child);
            });
            option4 = this.createUnionQuery((Seq<LogicalPlan>)projectPlan);
        } else {
            throw new BigQueryPushdownUnsupportedException(new StringBuilder(54).append("Query pushdown failed in generateQueries for node ").append(plan.nodeName()).append(" in ").append(plan.getClass().getName()).toString());
        }
        return option4;
    }

    public abstract Option<BigQuerySQLQuery> createUnionQuery(Seq<LogicalPlan> var1);

    public static final /* synthetic */ String $anonfun$alias$1(int n) {
        return new StringBuilder(9).append("SUBQUERY_").append(n).toString();
    }

    public static final /* synthetic */ void $anonfun$hasUnsupportedNodes$1(BigQueryStrategy $this, Object nonLocalReturnKey1$1, LogicalPlan x0$1) {
        Union union;
        Option<Seq<LogicalPlan>> option;
        Option<LogicalPlan> option2;
        Option<LogicalPlan> option3;
        LogicalPlan logicalPlan = x0$1;
        boolean bl = logicalPlan != null && !(option3 = UnaryOperationExtractor$.MODULE$.unapply(logicalPlan)).isEmpty() ? true : (logicalPlan != null && !(option2 = BinaryOperationExtractor$.MODULE$.unapply(logicalPlan)).isEmpty() ? true : logicalPlan instanceof Union && !(option = UnionOperationExtractor$.MODULE$.unapply(union = (Union)logicalPlan)).isEmpty());
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl2 = logicalPlan instanceof LogicalRelation ? true : (logicalPlan instanceof NamedRelation ? true : logicalPlan instanceof Expand);
            if (bl2) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.logDebug((Function0 & Serializable)() -> new StringBuilder(58).append("LogicalPlan has unsupported node for query pushdown : ").append(logicalPlan.nodeName()).append(" in ").append(logicalPlan.getClass().getName()).toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getTopMostProjectNodeWithAliasedCasts$2(Object nonLocalReturnKey2$1, Project x2$1, NamedExpression x0$2) {
        NamedExpression namedExpression = x0$2;
        if (namedExpression instanceof Alias) {
            Option<Expression> option;
            Alias alias = (Alias)namedExpression;
            Expression child = alias.child();
            Expression expression = child;
            if (expression != null && !(option = CastExpressionExtractor$.MODULE$.unapply(expression)).isEmpty()) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Some((Object)x2$1));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$getTopMostProjectNodeWithAliasedCasts$1(Object nonLocalReturnKey2$1, LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        boolean bl = logicalPlan instanceof Aggregate ? true : (logicalPlan instanceof Join ? true : (logicalPlan instanceof LogicalRelation ? true : logicalPlan instanceof NamedRelation));
        if (bl) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)None$.MODULE$);
        }
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq projectList = project.projectList();
            projectList.foreach((Function1 & Serializable)x0$2 -> {
                BigQueryStrategy.$anonfun$getTopMostProjectNodeWithAliasedCasts$2(nonLocalReturnKey2$1, project, x0$2);
                return BoxedUnit.UNIT;
            });
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)None$.MODULE$);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BigQueryStrategy(SparkExpressionConverter expressionConverter, SparkExpressionFactory expressionFactory, SparkPlanFactory sparkPlanFactory) {
        this.expressionConverter = expressionConverter;
        this.expressionFactory = expressionFactory;
        this.sparkPlanFactory = sparkPlanFactory;
        this.alias = package$.MODULE$.Iterator().from(0).map((Function1 & Serializable)n -> BigQueryStrategy.$anonfun$alias$1(BoxesRunTime.unboxToInt((Object)n)));
    }
}

