/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.pushdowns;

import com.google.cloud.spark.bigquery.pushdowns.BigQuerySQLStatement;
import com.google.cloud.spark.bigquery.pushdowns.BigQueryStrategy;
import com.google.cloud.spark.bigquery.pushdowns.CastExpressionExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.ConstantString;
import com.google.cloud.spark.bigquery.pushdowns.EmptyBigQuerySQLStatement$;
import com.google.cloud.spark.bigquery.pushdowns.SparkExpressionFactory;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class SparkBigQueryPushdownUtil$ {
    public static final SparkBigQueryPushdownUtil$ MODULE$ = new SparkBigQueryPushdownUtil$();

    public void enableBigQueryStrategy(SparkSession session, BigQueryStrategy bigQueryStrategy) {
        block0: {
            if (session.experimental().extraStrategies().exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkBigQueryPushdownUtil$.$anonfun$enableBigQueryStrategy$1(s)))) break block0;
            ExperimentalMethods experimentalMethods = session.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((IterableOnce)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BigQueryStrategy[]{bigQueryStrategy}))));
        }
    }

    public void disableBigQueryStrategy(SparkSession session) {
        session.experimental().extraStrategies_$eq((Seq)session.experimental().extraStrategies().filterNot((Function1 & Serializable)strategy -> BoxesRunTime.boxToBoolean((boolean)SparkBigQueryPushdownUtil$.$anonfun$disableBigQueryStrategy$1(strategy))));
    }

    public BigQuerySQLStatement blockStatement(BigQuerySQLStatement stmt, String alias) {
        return this.blockStatement(stmt).$plus("AS").$plus(new ConstantString(alias.toUpperCase()).toStatement());
    }

    public BigQuerySQLStatement blockStatement(BigQuerySQLStatement stmt) {
        return new ConstantString("(").$plus(stmt).$plus(")");
    }

    public BigQuerySQLStatement makeStatement(Seq<BigQuerySQLStatement> seq, String delimiter) {
        return this.makeStatement(seq, new ConstantString(delimiter).toStatement());
    }

    public BigQuerySQLStatement makeStatement(Seq<BigQuerySQLStatement> seq, BigQuerySQLStatement delimiter) {
        return (BigQuerySQLStatement)seq.foldLeft((Object)EmptyBigQuerySQLStatement$.MODULE$.apply(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigQuerySQLStatement left = (BigQuerySQLStatement)tuple2._1();
            BigQuerySQLStatement stmt = (BigQuerySQLStatement)tuple2._2();
            BigQuerySQLStatement bigQuerySQLStatement = left.isEmpty() ? stmt : left.$plus(delimiter).$plus(stmt);
            return bigQuerySQLStatement;
        });
    }

    public BigQuerySQLStatement addAttributeStatement(Attribute attr, Seq<Attribute> fields) {
        BigQuerySQLStatement bigQuerySQLStatement;
        Option option = fields.find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SparkBigQueryPushdownUtil$.$anonfun$addAttributeStatement$1(attr, e)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Attribute resolved = (Attribute)some.value();
            bigQuerySQLStatement = this.qualifiedAttributeStatement((Seq<String>)resolved.qualifier(), resolved.name());
        } else if (None$.MODULE$.equals(option)) {
            bigQuerySQLStatement = this.qualifiedAttributeStatement((Seq<String>)attr.qualifier(), attr.name());
        } else {
            throw new MatchError((Object)option);
        }
        return bigQuerySQLStatement;
    }

    public BigQuerySQLStatement qualifiedAttributeStatement(Seq<String> alias, String name) {
        return new ConstantString(this.qualifiedAttribute(alias, name)).toStatement();
    }

    public String qualifiedAttribute(Seq<String> alias, String name) {
        String str = alias.isEmpty() ? "" : new StringBuilder(1).append(((IterableOnceOps)alias.map((Function1 & Serializable)a -> a.toUpperCase())).mkString(".")).append(".").toString();
        return new StringBuilder(0).append(str).append(name.toUpperCase()).toString();
    }

    public Seq<NamedExpression> renameColumns(Seq<NamedExpression> origOutput, String alias, SparkExpressionFactory expressionFactory) {
        Iterator col_names = package$.MODULE$.Iterator().from(0).map((Function1 & Serializable)n -> SparkBigQueryPushdownUtil$.$anonfun$renameColumns$1(BoxesRunTime.unboxToInt((Object)n)));
        return (Seq)origOutput.map((Function1 & Serializable)expr -> {
            Metadata metadata = expr.metadata();
            String altName = new StringBuilder(1).append(alias).append("_").append(col_names.next()).toString();
            NamedExpression namedExpression = expr;
            if (!(namedExpression instanceof Alias)) return expressionFactory.createAlias((Expression)expr, altName, expr.exprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)new Some((Object)metadata));
            Alias alias = (Alias)namedExpression;
            Expression child = alias.child();
            String name = alias.name();
            if (child == null) return expressionFactory.createAlias((Expression)expr, altName, expr.exprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)new Some((Object)metadata));
            Expression expression = child;
            if (name == null) return expressionFactory.createAlias((Expression)expr, altName, expr.exprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)new Some((Object)metadata));
            return expressionFactory.createAlias(expression, altName, alias.exprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)new Some((Object)metadata));
        });
    }

    public Seq<NamedExpression> convertExpressionToNamedExpression(Seq<Expression> projections, Seq<Attribute> output, SparkExpressionFactory expressionFactory) {
        return (Seq)((IterableOps)projections.zip(output)).map((Function1 & Serializable)expression -> {
            NamedExpression namedExpression;
            Expression expression2 = (Expression)expression._1();
            Object object = expression2 instanceof NamedExpression ? (namedExpression = (NamedExpression)expression2) : expressionFactory.createAlias((Expression)expression._1(), ((NamedExpression)expression._2()).name(), ((NamedExpression)expression._2()).exprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)new Some((Object)((NamedExpression)expression._2()).metadata()));
            return object;
        });
    }

    public RDD<InternalRow> doExecuteSparkPlan(Seq<Attribute> output, RDD<InternalRow> rdd) {
        StructType schema = StructType$.MODULE$.apply((Seq)output.map((Function1 & Serializable)attr -> new StructField(attr.name(), attr.dataType(), attr.nullable(), StructField$.MODULE$.apply$default$4())));
        return rdd.mapPartitions((Function1 & Serializable)iter -> {
            UnsafeProjection project = UnsafeProjection$.MODULE$.create(schema);
            return iter.map((Function1)project);
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public LogicalPlan removeProjectNodeFromPlan(LogicalPlan plan, Project nodeToRemove) {
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(nodeToRemove){
            private static final long serialVersionUID = 0L;
            private final Project nodeToRemove$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    Project project = (Project)A1;
                    LogicalPlan child = project.child();
                    if (project.fastEquals((TreeNode)this.nodeToRemove$1)) {
                        object = child;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Project project;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Project && (project = (Project)logicalPlan).fastEquals((TreeNode)this.nodeToRemove$1);
                return bl;
            }
            {
                this.nodeToRemove$1 = nodeToRemove$1;
            }
        });
    }

    public Project removeCastFromProjectList(Project node, SparkExpressionFactory expressionFactory) {
        ObjectRef projectList = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        node.projectList().foreach((Function1 & Serializable)x0$1 -> {
            SparkBigQueryPushdownUtil$.$anonfun$removeCastFromProjectList$1(projectList, expressionFactory, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Project((Seq)projectList.elem, node.child());
    }

    public Seq<NamedExpression> createProjectListWithCastToString(Project node, SparkExpressionFactory expressionFactory) {
        ObjectRef projectList = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        node.projectList().foreach((Function1 & Serializable)child -> {
            projectList.elem = (Seq)((Seq)projectList.elem).$colon$plus((Object)expressionFactory.createAlias((Expression)new Cast((Expression)child.toAttribute(), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), child.name(), NamedExpression$.MODULE$.newExprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)None$.MODULE$));
            return BoxedUnit.UNIT;
        });
        return (Seq)projectList.elem;
    }

    public LogicalPlan addProjectNodeToThePlan(LogicalPlan plan, Project nodeToUpdate, SparkExpressionFactory expressionFactory) {
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(nodeToUpdate, expressionFactory){
            private static final long serialVersionUID = 0L;
            private final Project nodeToUpdate$1;
            private final SparkExpressionFactory expressionFactory$5;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Project project;
                A1 A1 = x1;
                if (A1 instanceof Project && (project = (Project)A1).fastEquals((TreeNode)this.nodeToUpdate$1)) {
                    Project projectWithoutCast = SparkBigQueryPushdownUtil$.MODULE$.removeCastFromProjectList(this.nodeToUpdate$1, this.expressionFactory$5);
                    Seq<NamedExpression> projectListWithCast = SparkBigQueryPushdownUtil$.MODULE$.createProjectListWithCastToString(projectWithoutCast, this.expressionFactory$5);
                    object = new Project(projectListWithCast, (LogicalPlan)projectWithoutCast);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Project project;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Project && (project = (Project)logicalPlan).fastEquals((TreeNode)this.nodeToUpdate$1);
                return bl;
            }
            {
                this.nodeToUpdate$1 = nodeToUpdate$1;
                this.expressionFactory$5 = expressionFactory$5;
            }
        });
    }

    public boolean isLimitTheChildToProjectNode(Project node) {
        return node.child() instanceof GlobalLimit;
    }

    public static final /* synthetic */ boolean $anonfun$enableBigQueryStrategy$1(SparkStrategy s) {
        return s instanceof BigQueryStrategy;
    }

    public static final /* synthetic */ boolean $anonfun$disableBigQueryStrategy$1(SparkStrategy strategy) {
        return strategy instanceof BigQueryStrategy;
    }

    public static final /* synthetic */ boolean $anonfun$addAttributeStatement$1(Attribute attr$1, Attribute e) {
        ExprId exprId = e.exprId();
        ExprId exprId2 = attr$1.exprId();
        return !(exprId != null ? !exprId.equals(exprId2) : exprId2 != null);
    }

    public static final /* synthetic */ String $anonfun$renameColumns$1(int n) {
        return new StringBuilder(4).append("COL_").append(n).toString();
    }

    public static final /* synthetic */ void $anonfun$removeCastFromProjectList$1(ObjectRef projectList$1, SparkExpressionFactory expressionFactory$3, NamedExpression x0$1) {
        NamedExpression namedExpression = x0$1;
        if (namedExpression instanceof Alias) {
            Option<Expression> option;
            Alias alias = (Alias)namedExpression;
            Expression child = alias.child();
            String name = alias.name();
            Expression expression = child;
            if (expression != null && !(option = CastExpressionExtractor$.MODULE$.unapply(expression)).isEmpty()) {
                Expression expression2 = (Expression)option.get();
                projectList$1.elem = (Seq)((Seq)projectList$1.elem).$colon$plus((Object)expressionFactory$3.createAlias(((Cast)expression2).child(), name, NamedExpression$.MODULE$.newExprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)None$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                projectList$1.elem = (Seq)((Seq)projectList$1.elem).$colon$plus((Object)expressionFactory$3.createAlias(expression, name, NamedExpression$.MODULE$.newExprId(), (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Option<Metadata>)None$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            projectList$1.elem = (Seq)((Seq)projectList$1.elem).$colon$plus((Object)namedExpression);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SparkBigQueryPushdownUtil$() {
    }
}

