/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace;

import brave.TracingCustomizer;
import brave.baggage.BaggagePropagation;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.stackdriver.StackdriverTracePropagation;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.auth.Credentials;
import com.google.cloud.spring.autoconfigure.trace.GcpTraceProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.tracing.BraveAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.reporter.brave.ZipkinSpanHandler;
import zipkin2.reporter.stackdriver.StackdriverEncoder;
import zipkin2.reporter.stackdriver.StackdriverSender;

@AutoConfiguration
@EnableConfigurationProperties(value={GcpTraceProperties.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.trace.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={StackdriverSender.class})
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
public class StackdriverTraceAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(StackdriverTraceAutoConfiguration.class);
    public static final String REPORTER_BEAN_NAME = "stackdriverReporter";
    public static final String SENDER_BEAN_NAME = "stackdriverSender";
    public static final String SPAN_HANDLER_BEAN_NAME = "stackdriverSpanHandler";
    public static final String CUSTOMIZER_BEAN_NAME = "stackdriverTracingCustomizer";
    private final GcpProjectIdProvider finalProjectIdProvider;
    private final CredentialsProvider finalCredentialsProvider;
    private final UserAgentHeaderProvider headerProvider = new UserAgentHeaderProvider(this.getClass());
    private ThreadPoolTaskScheduler defaultTraceSenderThreadPool;

    public StackdriverTraceAutoConfiguration(GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider, GcpTraceProperties gcpTraceProperties) throws IOException {
        this.finalProjectIdProvider = gcpTraceProperties.getProjectId() != null ? gcpTraceProperties::getProjectId : gcpProjectIdProvider;
        this.finalCredentialsProvider = gcpTraceProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpTraceProperties) : credentialsProvider;
    }

    @Bean(value={"stackdriverTracingCustomizer"})
    @ConditionalOnMissingBean(name={"stackdriverTracingCustomizer"})
    public TracingCustomizer stackdriverTracingCustomizer(@Qualifier(value="stackdriverSpanHandler") SpanHandler spanHandler) {
        return builder -> builder.supportsJoin(false).traceId128Bit(true).addSpanHandler(spanHandler);
    }

    @Bean(value={"stackdriverSpanHandler"})
    @ConditionalOnMissingBean(name={"stackdriverSpanHandler"})
    public SpanHandler stackdriverSpanHandler(@Qualifier(value="stackdriverReporter") Reporter<Span> stackdriverReporter) {
        return ZipkinSpanHandler.create(stackdriverReporter);
    }

    @Bean
    @ConditionalOnMissingBean
    ReporterMetrics reporterMetrics() {
        return ReporterMetrics.NOOP_METRICS;
    }

    @Bean
    @ConditionalOnMissingBean(name={"traceExecutorProvider"})
    public ExecutorProvider traceExecutorProvider(GcpTraceProperties traceProperties, @Qualifier(value="traceSenderThreadPool") Optional<ThreadPoolTaskScheduler> userProvidedScheduler) {
        ThreadPoolTaskScheduler scheduler;
        if (userProvidedScheduler.isPresent()) {
            scheduler = userProvidedScheduler.get();
        } else {
            scheduler = this.defaultTraceSenderThreadPool = new ThreadPoolTaskScheduler();
            scheduler.setPoolSize(traceProperties.getNumExecutorThreads());
            scheduler.setThreadNamePrefix("gcp-trace-sender");
            scheduler.setDaemon(true);
            scheduler.initialize();
        }
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean(destroyMethod="shutdownNow")
    @ConditionalOnMissingBean(name={"stackdriverSenderChannel"})
    public ManagedChannel stackdriverSenderChannel() {
        return ManagedChannelBuilder.forTarget((String)"dns:///cloudtrace.googleapis.com").userAgent(this.headerProvider.getUserAgent()).build();
    }

    @Bean(value={"stackdriverReporter"})
    @ConditionalOnMissingBean(name={"stackdriverReporter"})
    public Reporter<Span> stackdriverReporter(ReporterMetrics reporterMetrics, GcpTraceProperties trace, @Qualifier(value="stackdriverSender") Sender sender) {
        AsyncReporter asyncReporter = AsyncReporter.builder((Sender)sender).queuedMaxSpans(1000).messageTimeout((long)trace.getMessageTimeout(), TimeUnit.SECONDS).metrics(reporterMetrics).build((BytesEncoder)StackdriverEncoder.V2);
        CheckResult checkResult = asyncReporter.check();
        if (!checkResult.ok()) {
            LOGGER.warn((Object)"Error when performing Stackdriver AsyncReporter health check.", checkResult.error());
        }
        return asyncReporter;
    }

    @Bean(value={"stackdriverSender"})
    @ConditionalOnMissingBean(name={"stackdriverSender"})
    public Sender stackdriverSender(GcpTraceProperties traceProperties, @Qualifier(value="traceExecutorProvider") ExecutorProvider executorProvider, @Qualifier(value="stackdriverSenderChannel") ManagedChannel channel) throws IOException {
        CallOptions callOptions = CallOptions.DEFAULT.withCallCredentials(MoreCallCredentials.from((Credentials)this.finalCredentialsProvider.getCredentials())).withExecutor((Executor)executorProvider.getExecutor());
        if (traceProperties.getAuthority() != null) {
            callOptions = callOptions.withAuthority(traceProperties.getAuthority());
        }
        if (traceProperties.getCompression() != null) {
            callOptions = callOptions.withCompression(traceProperties.getCompression());
        }
        if (traceProperties.getDeadlineMs() != null) {
            callOptions = callOptions.withDeadlineAfter(traceProperties.getDeadlineMs().longValue(), TimeUnit.MILLISECONDS);
        }
        if (traceProperties.getMaxInboundSize() != null) {
            callOptions = callOptions.withMaxInboundMessageSize(traceProperties.getMaxInboundSize().intValue());
        }
        if (traceProperties.getMaxOutboundSize() != null) {
            callOptions = callOptions.withMaxOutboundMessageSize(traceProperties.getMaxOutboundSize().intValue());
        }
        if (traceProperties.isWaitForReady() != null) {
            callOptions = Boolean.TRUE.equals(traceProperties.isWaitForReady()) ? callOptions.withWaitForReady() : callOptions.withoutWaitForReady();
        }
        StackdriverSender.Builder builder = StackdriverSender.newBuilder((Channel)channel).projectId(this.finalProjectIdProvider.getProjectId()).callOptions(callOptions);
        if (traceProperties.getServerResponseTimeoutMs() != null) {
            builder.serverResponseTimeoutMs(traceProperties.getServerResponseTimeoutMs().longValue());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public BaggagePropagation.FactoryBuilder baggagePropagationFactoryBuilder() {
        Propagation.Factory primary = B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.MULTI).build();
        return BaggagePropagation.newFactoryBuilder((Propagation.Factory)StackdriverTracePropagation.newFactory((Propagation.Factory)primary));
    }

    @PreDestroy
    public void closeScheduler() {
        if (this.defaultTraceSenderThreadPool != null) {
            this.defaultTraceSenderThreadPool.shutdown();
        }
    }
}

