/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.sql.CredentialsPropertiesSetter;
import com.google.cloud.spring.autoconfigure.sql.DatabaseType;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import com.google.cloud.spring.autoconfigure.sql.PropertiesRetriever;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class R2dbcCloudSqlEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log LOGGER = LogFactory.getLog(R2dbcCloudSqlEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().contains("bootstrap")) {
            return;
        }
        DatabaseType databaseType = this.getEnabledDatabaseType(environment);
        if (databaseType != null) {
            PropertiesRetriever propertiesRetriever = new PropertiesRetriever((Environment)environment);
            GcpCloudSqlProperties sqlProperties = propertiesRetriever.getCloudSqlProperties();
            String r2dbcUrl = this.createUrl(databaseType, sqlProperties);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Default " + databaseType.name() + " R2dbcUrl provider. Connecting to " + r2dbcUrl));
            }
            HashMap<String, String> fallbackMap = new HashMap<String, String>();
            fallbackMap.put("spring.r2dbc.username", databaseType.getDefaultUsername());
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("CLOUD_SQL_R2DBC_USERNAME", fallbackMap));
            HashMap<String, String> primaryMap = new HashMap<String, String>();
            primaryMap.put("spring.r2dbc.url", r2dbcUrl);
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("CLOUD_SQL_R2DBC_URL", primaryMap));
            CredentialsPropertiesSetter.setCredentials(sqlProperties, propertiesRetriever.getGcpProperties());
        }
    }

    String createUrl(DatabaseType databaseType, GcpCloudSqlProperties sqlProperties) {
        Assert.hasText((String)sqlProperties.getDatabaseName(), (String)"A database name must be provided.");
        Assert.hasText((String)sqlProperties.getInstanceConnectionName(), (String)"An instance connection name must be provided in the format <PROJECT_ID>:<REGION>:<INSTANCE_ID>.");
        return String.format(databaseType.getR2dbcUrlTemplate(), sqlProperties.getInstanceConnectionName(), sqlProperties.getDatabaseName());
    }

    DatabaseType getEnabledDatabaseType(ConfigurableEnvironment environment) {
        if (this.isR2dbcEnabled(environment) && this.isOnClasspath("com.google.cloud.sql.CredentialFactory") && this.isOnClasspath("io.r2dbc.spi.ConnectionFactory") && this.isOnClasspath("com.google.cloud.sql.core.GcpConnectionFactoryProviderPostgres") && this.isOnClasspath("io.r2dbc.postgresql.PostgresqlConnectionFactoryProvider")) {
            return DatabaseType.POSTGRESQL;
        }
        return null;
    }

    private boolean isOnClasspath(String className) {
        return ClassUtils.isPresent((String)className, null);
    }

    private boolean isR2dbcEnabled(ConfigurableEnvironment environment) {
        return Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.sql.enabled", "true")) && Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.sql.r2dbc.enabled", "true"));
    }
}

