/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Tracing;
import brave.messaging.MessagingTracing;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubAutoConfiguration;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TraceHelper;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracePubSubBeanPostProcessor;
import com.google.cloud.spring.pubsub.core.publisher.PublisherCustomizer;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.pubsub.v1.PubsubMessage;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.aop.ObservedAspect;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.actuate.autoconfigure.tracing.BraveAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.trace.pubsub.enabled"})
@ConditionalOnClass(value={PublisherFactory.class, MessagingTracing.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@AutoConfigureBefore(value={GcpPubSubAutoConfiguration.class})
class TracePubSubAutoConfiguration {
    TracePubSubAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    static TracePubSubBeanPostProcessor tracePubSubBeanPostProcessor(BeanFactory beanFactory) {
        return new TracePubSubBeanPostProcessor(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    PubSubTracing pubSubTracing(MessagingTracing messagingTracing) {
        return PubSubTracing.newBuilder(messagingTracing).build();
    }

    @Bean
    @Order(value=-2147483648)
    PublisherCustomizer tracePublisherCustomizer(PubSubTracing pubSubTracing) {
        TraceHelper helper = new TraceHelper(pubSubTracing);
        return (publisherBuilder, topic) -> publisherBuilder.setTransform(msg -> helper.instrumentMessage((PubsubMessage)msg, topic));
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagingTracing messagingTracing(Tracing tracing) {
        return MessagingTracing.create((Tracing)tracing);
    }

    @Bean
    @ConditionalOnMissingBean
    ObservedAspect observedAspect(ObservationRegistry observationRegistry) {
        return new ObservedAspect(observationRegistry);
    }
}

