/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.spanner.health;

import com.google.cloud.spring.autoconfigure.spanner.GcpSpannerAutoConfiguration;
import com.google.cloud.spring.autoconfigure.spanner.health.SpannerHealthIndicator;
import com.google.cloud.spring.autoconfigure.spanner.health.SpannerHealthIndicatorProperties;
import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnClass(value={SpannerTemplate.class, HealthIndicator.class})
@ConditionalOnBean(value={SpannerTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="spanner")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@AutoConfigureAfter(value={GcpSpannerAutoConfiguration.class})
@EnableConfigurationProperties(value={SpannerHealthIndicatorProperties.class})
public class SpannerHealthIndicatorAutoConfiguration
extends CompositeHealthContributorConfiguration<SpannerHealthIndicator, SpannerTemplate> {
    public SpannerHealthIndicatorAutoConfiguration(SpannerHealthIndicatorProperties spannerHealthProperties) {
        super(spannerTemplate -> new SpannerHealthIndicator((SpannerTemplate)spannerTemplate, spannerHealthProperties.getQuery()));
    }

    @Bean
    @ConditionalOnMissingBean(name={"spannerHealthIndicator", "spannerHealthContributor"})
    public HealthContributor spannerHealthContributor(Map<String, SpannerTemplate> spannerTemplates) {
        Assert.notNull(spannerTemplates, (String)"SpannerTemplates must be provided");
        return (HealthContributor)this.createContributor(spannerTemplates);
    }
}

