/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.parametermanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterManagerSettings;
import com.google.cloud.spring.autoconfigure.core.GcpProperties;
import com.google.cloud.spring.autoconfigure.parametermanager.DefaultParameterManagerClientFactory;
import com.google.cloud.spring.autoconfigure.parametermanager.GcpParameterManagerProperties;
import com.google.cloud.spring.autoconfigure.parametermanager.ParameterManagerConfigDataLoader;
import com.google.cloud.spring.autoconfigure.parametermanager.ParameterManagerConfigDataResource;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.parametermanager.ParameterManagerClientFactory;
import com.google.cloud.spring.parametermanager.ParameterManagerTemplate;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.util.VisibleForTesting;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;

public class ParameterManagerConfigDataLocationResolver
implements ConfigDataLocationResolver<ParameterManagerConfigDataResource> {
    public static final String PARAMETER_MANAGER_PREFIX = "pm@";
    private static ParameterManagerClient parameterManagerClient;
    private static ParameterManagerClientFactory parameterManagerClientFactory;

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(PARAMETER_MANAGER_PREFIX);
    }

    public List<ParameterManagerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        ParameterManagerConfigDataLocationResolver.registerParameterManagerBeans(context);
        return Collections.singletonList(new ParameterManagerConfigDataResource(location));
    }

    private static void registerParameterManagerBeans(ConfigDataLocationResolverContext context) {
        ParameterManagerConfigDataLocationResolver.registerBean(context, GcpProperties.class, ParameterManagerConfigDataLocationResolver.getGcpProperties(context));
        ParameterManagerConfigDataLocationResolver.registerBean(context, GcpParameterManagerProperties.class, ParameterManagerConfigDataLocationResolver.getParameterManagerProperties(context));
        ParameterManagerConfigDataLocationResolver.registerBean(context, CredentialsProvider.class, ParameterManagerConfigDataLocationResolver.getCredentialsProvider(context));
        ParameterManagerConfigDataLocationResolver.registerAndPromoteBean(context, ParameterManagerClientFactory.class, BootstrapRegistry.InstanceSupplier.from(() -> ParameterManagerConfigDataLocationResolver.createParameterManagerClientFactory(context)));
        ParameterManagerConfigDataLocationResolver.registerAndPromoteBean(context, ParameterManagerClient.class, BootstrapRegistry.InstanceSupplier.from(() -> ParameterManagerConfigDataLocationResolver.createParameterManagerClient(context)));
        ParameterManagerConfigDataLocationResolver.registerBean(context, GcpProjectIdProvider.class, ParameterManagerConfigDataLocationResolver.createProjectIdProvider(context));
        ParameterManagerConfigDataLocationResolver.registerAndPromoteBean(context, ParameterManagerTemplate.class, BootstrapRegistry.InstanceSupplier.of((Object)ParameterManagerConfigDataLocationResolver.createParameterManagerTemplate(context)));
    }

    private static GcpProperties getGcpProperties(ConfigDataLocationResolverContext context) {
        return (GcpProperties)context.getBinder().bind("spring.cloud.gcp", GcpProperties.class).orElse((Object)new GcpProperties());
    }

    private static GcpParameterManagerProperties getParameterManagerProperties(ConfigDataLocationResolverContext context) {
        return (GcpParameterManagerProperties)context.getBinder().bind("spring.cloud.gcp.parametermanager", GcpParameterManagerProperties.class).orElse((Object)new GcpParameterManagerProperties());
    }

    private static CredentialsProvider getCredentialsProvider(ConfigDataLocationResolverContext context) {
        try {
            GcpParameterManagerProperties properties = (GcpParameterManagerProperties)context.getBootstrapContext().get(GcpParameterManagerProperties.class);
            return (CredentialsProvider)context.getBinder().bind("spring.cloud.gcp.parametermanager", CredentialsProvider.class).orElse((Object)new DefaultCredentialsProvider((CredentialsSupplier)properties));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the Parameter Manager Client Factory for ConfigData loading.", e);
        }
    }

    @VisibleForTesting
    static GcpProjectIdProvider createProjectIdProvider(ConfigDataLocationResolverContext context) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        GcpParameterManagerProperties parameterManagerProperties = (GcpParameterManagerProperties)bootstrapContext.get(GcpParameterManagerProperties.class);
        if (parameterManagerProperties.getProjectId() != null) {
            return parameterManagerProperties::getProjectId;
        }
        GcpProperties gcpProperties = (GcpProperties)bootstrapContext.get(GcpProperties.class);
        if (gcpProperties.getProjectId() != null) {
            return gcpProperties::getProjectId;
        }
        return new DefaultGcpProjectIdProvider();
    }

    @VisibleForTesting
    static synchronized ParameterManagerClient createParameterManagerClient(ConfigDataLocationResolverContext context) {
        if (parameterManagerClient != null && !parameterManagerClient.isTerminated()) {
            return parameterManagerClient;
        }
        try {
            GcpParameterManagerProperties properties = (GcpParameterManagerProperties)context.getBootstrapContext().get(GcpParameterManagerProperties.class);
            DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider((CredentialsSupplier)properties);
            ParameterManagerSettings settings = ((ParameterManagerSettings.Builder)((ParameterManagerSettings.Builder)ParameterManagerSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(ParameterManagerConfigDataLoader.class))).build();
            parameterManagerClient = ParameterManagerClient.create((ParameterManagerSettings)settings);
            return parameterManagerClient;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the Parameter Manager Client for ConfigData loading.", e);
        }
    }

    @VisibleForTesting
    static synchronized ParameterManagerClientFactory createParameterManagerClientFactory(ConfigDataLocationResolverContext context) {
        if (parameterManagerClientFactory != null) {
            return parameterManagerClientFactory;
        }
        ParameterManagerClient client = (ParameterManagerClient)context.getBootstrapContext().get(ParameterManagerClient.class);
        return new DefaultParameterManagerClientFactory((CredentialsProvider)context.getBootstrapContext().get(CredentialsProvider.class), client);
    }

    private static ParameterManagerTemplate createParameterManagerTemplate(ConfigDataLocationResolverContext context) {
        ParameterManagerClient client = (ParameterManagerClient)context.getBootstrapContext().get(ParameterManagerClient.class);
        ParameterManagerClientFactory clientFactory = (ParameterManagerClientFactory)context.getBootstrapContext().get(ParameterManagerClientFactory.class);
        GcpProjectIdProvider projectIdProvider = (GcpProjectIdProvider)context.getBootstrapContext().get(GcpProjectIdProvider.class);
        GcpParameterManagerProperties properties = (GcpParameterManagerProperties)context.getBootstrapContext().get(GcpParameterManagerProperties.class);
        if (clientFactory != null) {
            return new ParameterManagerTemplate(clientFactory, projectIdProvider).setAllowDefaultParameterValue(properties.isAllowDefaultParameter());
        }
        return new ParameterManagerTemplate(client, projectIdProvider).setAllowDefaultParameterValue(properties.isAllowDefaultParameter());
    }

    private static <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, T instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    private static <T> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        context.getBootstrapContext().registerIfAbsent(type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            Object instance = event.getBootstrapContext().get(type);
            String beanName = "gcp-parametermanager-config-data-" + type.getSimpleName();
            ConfigurableListableBeanFactory factory = event.getApplicationContext().getBeanFactory();
            if (!factory.containsSingleton(beanName)) {
                factory.registerSingleton(beanName, instance);
            }
        });
    }

    @VisibleForTesting
    static void setParameterManagerClient(ParameterManagerClient client) {
        parameterManagerClient = client;
    }

    @VisibleForTesting
    static void setParameterManagerClientFactory(ParameterManagerClientFactory clientFactory) {
        parameterManagerClientFactory = clientFactory;
    }
}

