/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.query;

import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.repository.query.AbstractSpannerQuery;
import com.google.cloud.spring.data.spanner.repository.query.SpannerQueryMethod;
import com.google.cloud.spring.data.spanner.repository.query.SpannerStatementQueryExecutor;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeSpannerQuery<T>
extends AbstractSpannerQuery<T> {
    private final PartTree tree;

    public PartTreeSpannerQuery(Class<T> type, SpannerQueryMethod queryMethod, SpannerTemplate spannerTemplate, SpannerMappingContext spannerMappingContext) {
        super(type, queryMethod, spannerTemplate, spannerMappingContext);
        this.tree = new PartTree(queryMethod.getName(), type);
    }

    @Override
    protected List executeRawResult(Object[] parameters) {
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (this.isCountOrExistsQuery()) {
            return SpannerStatementQueryExecutor.executeQuery(struct -> this.isCountQuery() ? (Constable)Long.valueOf(struct.getLong(0)) : (Constable)Boolean.valueOf(struct.getBoolean(0)), this.entityType, this.tree, (ParameterAccessor)paramAccessor, this.getQueryMethod().getQueryMethod().getParameters(), this.spannerTemplate, this.spannerMappingContext);
        }
        if (this.tree.isDelete()) {
            return this.spannerTemplate.performReadWriteTransaction(this.getDeleteFunction(parameters));
        }
        return SpannerStatementQueryExecutor.executeQuery(this.entityType, this.tree, (ParameterAccessor)paramAccessor, this.getQueryMethod().getQueryMethod().getParameters(), this.spannerTemplate, this.spannerMappingContext);
    }

    private Function<SpannerTemplate, List> getDeleteFunction(Object[] parameters) {
        return transactionTemplate -> {
            ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
            List entitiesToDelete = SpannerStatementQueryExecutor.executeQuery(this.entityType, this.tree, (ParameterAccessor)paramAccessor, this.getQueryMethod().getQueryMethod().getParameters(), transactionTemplate, this.spannerMappingContext);
            transactionTemplate.deleteAll(entitiesToDelete);
            List<Object> result = null;
            if (this.queryMethod.isCollectionQuery()) {
                result = entitiesToDelete;
            } else if (this.queryMethod.getReturnedObjectType() != Void.TYPE) {
                result = Collections.singletonList(entitiesToDelete.size());
            }
            return result;
        };
    }

    private boolean isCountOrExistsQuery() {
        return this.isCountQuery() || this.isExistsQuery();
    }

    private boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    private boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }
}

