/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.stream.binder.pubsub.provisioning;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.cloud.spring.pubsub.PubSubAdmin;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubConsumerProperties;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubProducerProperties;
import com.google.cloud.spring.stream.binder.pubsub.provisioning.PubSubConsumerDestination;
import com.google.cloud.spring.stream.binder.pubsub.provisioning.PubSubProducerDestination;
import com.google.pubsub.v1.DeadLetterPolicy;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PubSubChannelProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>> {
    private static final Log LOGGER = LogFactory.getLog(PubSubChannelProvisioner.class);
    private final PubSubAdmin pubSubAdmin;
    private final Set<String> anonymousGroupSubscriptionNames = new HashSet<String>();

    public PubSubChannelProvisioner(PubSubAdmin pubSubAdmin) {
        this.pubSubAdmin = pubSubAdmin;
    }

    public ProducerDestination provisionProducerDestination(String topic, ExtendedProducerProperties<PubSubProducerProperties> properties) {
        this.ensureTopicExists(topic, ((PubSubProducerProperties)properties.getExtension()).isAutoCreateResources());
        return new PubSubProducerDestination(topic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConsumerDestination provisionConsumerDestination(String topicName, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        Object subscriptionName;
        Subscription subscription;
        String customName = ((PubSubConsumerProperties)properties.getExtension()).getSubscriptionName();
        boolean autoCreate = ((PubSubConsumerProperties)properties.getExtension()).isAutoCreateResources();
        PubSubConsumerProperties.DeadLetterPolicy deadLetterPolicy = ((PubSubConsumerProperties)properties.getExtension()).getDeadLetterPolicy();
        String topicShortName = TopicName.isParsableFrom((String)topicName) ? TopicName.parse((String)topicName).getTopic() : topicName;
        Topic topic = this.ensureTopicExists(topicName, autoCreate);
        if (StringUtils.hasText((String)customName)) {
            if (StringUtils.hasText((String)group)) {
                LOGGER.warn((Object)("Either subscriptionName or group can be specified, but not both. Using subscriptionName '" + customName + "'."));
            }
            subscription = this.pubSubAdmin.getSubscription(customName);
            subscriptionName = customName;
        } else if (StringUtils.hasText((String)group)) {
            subscriptionName = topicShortName + "." + group;
            subscription = this.pubSubAdmin.getSubscription((String)subscriptionName);
        } else {
            subscriptionName = "anonymous." + topicShortName + "." + UUID.randomUUID().toString();
            subscription = this.createSubscription((String)subscriptionName, topicName, deadLetterPolicy, autoCreate);
            this.anonymousGroupSubscriptionNames.add((String)subscriptionName);
        }
        if (subscription == null) {
            if (!autoCreate) throw new ProvisioningException("Non-existing '" + (String)subscriptionName + "' subscription.");
            this.createSubscription((String)subscriptionName, topicName, deadLetterPolicy, autoCreate);
            return new PubSubConsumerDestination((String)subscriptionName);
        } else {
            if (subscription.getTopic().equals(topic.getName())) return new PubSubConsumerDestination((String)subscriptionName);
            throw new ProvisioningException("Existing '" + (String)subscriptionName + "' subscription is for a different topic '" + subscription.getTopic() + "'.");
        }
    }

    public void afterUnbindConsumer(ConsumerDestination destination) {
        if (this.anonymousGroupSubscriptionNames.remove(destination.getName())) {
            try {
                this.pubSubAdmin.deleteSubscription(destination.getName());
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Failed to delete auto-created anonymous subscription '" + destination.getName() + "'."));
            }
        }
    }

    Topic ensureTopicExists(String topicName, boolean autoCreate) {
        Topic topic = this.pubSubAdmin.getTopic(topicName);
        if (topic != null) {
            return topic;
        }
        if (autoCreate) {
            try {
                return this.pubSubAdmin.createTopic(topicName);
            }
            catch (AlreadyExistsException alreadyExistsException) {
                return this.ensureTopicExists(topicName, false);
            }
        }
        throw new ProvisioningException("Non-existing '" + topicName + "' topic.");
    }

    private Subscription createSubscription(String subscriptionName, String topicName, PubSubConsumerProperties.DeadLetterPolicy deadLetterPolicy, boolean autoCreate) {
        Subscription.Builder builder = Subscription.newBuilder().setName(subscriptionName).setTopic(topicName);
        if (deadLetterPolicy != null) {
            String dlTopicName = deadLetterPolicy.getDeadLetterTopic();
            Assert.hasText((String)dlTopicName, (String)"Dead letter policy cannot have null or empty topic");
            Topic dlTopic = this.ensureTopicExists(dlTopicName, autoCreate);
            DeadLetterPolicy.Builder dlpBuilder = DeadLetterPolicy.newBuilder().setDeadLetterTopic(dlTopic.getName());
            Integer maxAttempts = deadLetterPolicy.getMaxDeliveryAttempts();
            if (maxAttempts != null) {
                dlpBuilder.setMaxDeliveryAttempts(maxAttempts.intValue());
            }
            builder.setDeadLetterPolicy(dlpBuilder);
        }
        return this.pubSubAdmin.createSubscription(builder);
    }
}

