/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.integration.inbound;

import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberOperations;
import com.google.cloud.spring.pubsub.integration.AckMode;
import com.google.cloud.spring.pubsub.integration.PubSubHeaderMapper;
import com.google.cloud.spring.pubsub.support.converter.ConvertedBasicAcknowledgeablePubsubMessage;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;

public class PubSubInboundChannelAdapter
extends MessageProducerSupport {
    private static final Log LOGGER = LogFactory.getLog(PubSubInboundChannelAdapter.class);
    private final String subscriptionName;
    private final PubSubSubscriberOperations pubSubSubscriberOperations;
    private Subscriber subscriber;
    private AckMode ackMode = AckMode.AUTO;
    private HeaderMapper<Map<String, String>> headerMapper = new PubSubHeaderMapper();
    private Class<?> payloadType = byte[].class;
    private HealthTrackerRegistry healthTrackerRegistry;

    public PubSubInboundChannelAdapter(PubSubSubscriberOperations pubSubSubscriberOperations, String subscriptionName) {
        Assert.notNull((Object)pubSubSubscriberOperations, (String)"Pub/Sub subscriber template can't be null.");
        Assert.notNull((Object)subscriptionName, (String)"Pub/Sub subscription name can't be null.");
        this.pubSubSubscriberOperations = pubSubSubscriberOperations;
        this.subscriptionName = subscriptionName;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"The acknowledgement mode can't be null.");
        this.ackMode = ackMode;
    }

    public void setHealthTrackerRegistry(HealthTrackerRegistry healthTrackerRegistry) {
        this.healthTrackerRegistry = healthTrackerRegistry;
    }

    public Class<?> getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(Class<?> payloadType) {
        Assert.notNull(payloadType, (String)"The payload type cannot be null.");
        this.payloadType = payloadType;
    }

    public void setHeaderMapper(HeaderMapper<Map<String, String>> headerMapper) {
        Assert.notNull(headerMapper, (String)"The header mapper can't be null.");
        this.headerMapper = headerMapper;
    }

    protected void doStart() {
        super.doStart();
        this.addToHealthRegistry();
        this.subscriber = this.pubSubSubscriberOperations.subscribeAndConvert(this.subscriptionName, this::consumeMessage, this.payloadType);
        this.addListeners();
    }

    protected void doStop() {
        if (this.subscriber != null) {
            this.subscriber.stopAsync();
        }
        super.doStop();
    }

    private void consumeMessage(ConvertedBasicAcknowledgeablePubsubMessage<?> message) {
        Map messageHeaders = this.headerMapper.toHeaders((Object)message.getPubsubMessage().getAttributesMap());
        messageHeaders.put("gcp_pubsub_original_message", message);
        try {
            this.sendMessage(this.getMessageBuilderFactory().withPayload(message.getPayload()).copyHeaders(messageHeaders).build());
            this.processedMessage(message.getProjectSubscriptionName());
            if (this.ackMode == AckMode.AUTO_ACK || this.ackMode == AckMode.AUTO) {
                message.ack();
            }
        }
        catch (RuntimeException re) {
            if (this.ackMode == AckMode.AUTO) {
                message.nack();
                this.logWarning(message, re, "message nacked automatically.");
            }
            this.logWarning(message, re, "message neither acked nor nacked.");
        }
    }

    private void logWarning(ConvertedBasicAcknowledgeablePubsubMessage<?> message, RuntimeException re, String actionMessage) {
        LOGGER.warn((Object)String.format("Sending Spring message [%s] failed; %s", message.getPubsubMessage().getMessageId(), actionMessage));
        if (re instanceof MessageDeliveryException) {
            MessageDeliveryException messageDeliveryException = (MessageDeliveryException)re;
            LOGGER.warn((Object)messageDeliveryException.getFailedMessage(), (Throwable)messageDeliveryException);
        } else {
            LOGGER.warn((Object)re.getMessage(), (Throwable)re);
        }
    }

    private void addToHealthRegistry() {
        if (this.healthCheckEnabled()) {
            this.healthTrackerRegistry.registerTracker(this.subscriptionName);
        }
    }

    private void addListeners() {
        if (this.healthCheckEnabled()) {
            this.healthTrackerRegistry.addListener(this.subscriber);
        }
    }

    private void processedMessage(ProjectSubscriptionName projectSubscriptionName) {
        if (this.healthCheckEnabled()) {
            this.healthTrackerRegistry.processedMessage(projectSubscriptionName);
        }
    }

    public boolean healthCheckEnabled() {
        return this.healthTrackerRegistry != null;
    }
}

