/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration.inbound;

import com.google.cloud.spring.storage.integration.GcsSessionFactory;
import com.google.cloud.spring.storage.integration.filters.GcsPersistentAcceptOnceFileListFilter;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class GcsInboundFileSynchronizer
extends AbstractInboundFileSynchronizer<BlobInfo> {
    public GcsInboundFileSynchronizer(Storage gcs) {
        super((SessionFactory)new GcsSessionFactory(gcs));
        this.doSetFilter((FileListFilter)new GcsPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "gcsMessageSource"));
    }

    protected boolean isFile(BlobInfo file) {
        return true;
    }

    protected String getFilename(BlobInfo file) {
        return file.getName();
    }

    protected long getModified(BlobInfo file) {
        return file.getUpdateTimeOffsetDateTime().toInstant().toEpochMilli();
    }

    protected String protocol() {
        return "gs";
    }
}

