/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage;

import com.google.cloud.spring.storage.GoogleStorageLocation;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.WritableResource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GoogleStorageResource
implements WritableResource {
    private static final Log LOGGER = LogFactory.getLog(GoogleStorageResource.class);
    private final Storage storage;
    private final GoogleStorageLocation location;
    private final boolean autoCreateFiles;

    public GoogleStorageResource(Storage storage, String locationUri, boolean autoCreateFiles) {
        this(storage, new GoogleStorageLocation(locationUri), autoCreateFiles);
    }

    public GoogleStorageResource(Storage storage, String locationUri) {
        this(storage, locationUri, true);
    }

    public GoogleStorageResource(Storage storage, GoogleStorageLocation googleStorageLocation, boolean autoCreateFiles) {
        Assert.notNull((Object)storage, (String)"Storage object can not be null");
        this.storage = storage;
        this.location = googleStorageLocation;
        this.autoCreateFiles = autoCreateFiles;
    }

    public boolean isAutoCreateFiles() {
        return this.autoCreateFiles;
    }

    public boolean exists() {
        return this.isBucket() ? this.getBucket() != null : this.getBlob() != null;
    }

    public boolean isReadable() {
        return !this.isBucket();
    }

    public boolean isOpen() {
        return false;
    }

    @NonNull
    public URL getURL() throws IOException {
        String url;
        if (this.isBucket()) {
            Bucket bucket = this.getBucket();
            Assert.notNull((Object)bucket, (String)("The bucket " + this.getBucketName() + " does not exist."));
            url = bucket.getSelfLink();
        } else {
            Blob b = this.getBlob();
            Assert.notNull((Object)b, (String)("The object at " + this.getURI() + " does not exist."));
            url = this.getBlob().getSelfLink();
        }
        return new URL(url);
    }

    @NonNull
    public URI getURI() {
        return this.location.uri();
    }

    public Blob getBlob() {
        return this.storage.get(this.getBlobId());
    }

    public URL createSignedUrl(TimeUnit timeUnit, long timePeriods, Storage.SignUrlOption ... options) {
        if (LOGGER.isWarnEnabled() && !this.exists()) {
            LOGGER.warn((Object)("Creating signed URL for non-existing GCS object " + this.getURI()));
        }
        return this.storage.signUrl(BlobInfo.newBuilder((BlobId)this.getBlobId()).build(), timePeriods, timeUnit, options);
    }

    public Blob createBlob() {
        return this.storage.create(BlobInfo.newBuilder((BlobId)this.getBlobId()).build(), new Storage.BlobTargetOption[0]);
    }

    public Blob createBlob(byte[] contents) {
        return this.storage.create(BlobInfo.newBuilder((BlobId)this.getBlobId()).build(), contents, new Storage.BlobTargetOption[0]);
    }

    public Bucket createBucket() {
        return this.storage.create(BucketInfo.newBuilder((String)this.getBucketName()).build(), new Storage.BucketTargetOption[0]);
    }

    public Bucket getBucket() {
        return this.storage.get(this.location.getBucketName(), new Storage.BucketGetOption[0]);
    }

    public boolean bucketExists() {
        return this.getBucket() != null;
    }

    private Blob throwExceptionForNullBlob(Blob blob) throws IOException {
        if (blob == null) {
            throw new FileNotFoundException("The blob was not found: " + this.getURI());
        }
        return blob;
    }

    @NonNull
    public File getFile() {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        return this.throwExceptionForNullBlob(this.getBlob()).getSize();
    }

    public long lastModified() throws IOException {
        return this.throwExceptionForNullBlob(this.getBlob()).getUpdateTimeOffsetDateTime().toInstant().toEpochMilli();
    }

    @NonNull
    public GoogleStorageResource createRelative(@NonNull String relativePath) {
        return new GoogleStorageResource(this.storage, this.getURI().resolve(relativePath).toString(), this.autoCreateFiles);
    }

    public String getFilename() {
        return this.isBucket() ? this.getBucketName() : this.getBlobName();
    }

    @NonNull
    public String getDescription() {
        return this.getURI().toString();
    }

    @NonNull
    public InputStream getInputStream() throws IOException {
        if (this.isBucket()) {
            throw new IllegalStateException("Cannot open an input stream to a bucket: '" + this.getURI() + "'");
        }
        return Channels.newInputStream((ReadableByteChannel)this.throwExceptionForNullBlob(this.getBlob()).reader(new Blob.BlobSourceOption[0]));
    }

    public boolean isWritable() {
        return !this.isBucket() && (this.autoCreateFiles || this.exists());
    }

    @NonNull
    public OutputStream getOutputStream() throws IOException {
        if (this.isBucket()) {
            throw new IllegalStateException("Cannot open an output stream to a bucket: '" + this.getURI() + "'");
        }
        Blob blob = this.getBlob();
        if (!(blob != null && blob.exists(new Blob.BlobSourceOption[0]) || this.autoCreateFiles)) {
            throw new FileNotFoundException("The blob was not found: " + this.getURI());
        }
        return Channels.newOutputStream((WritableByteChannel)this.storage.writer(BlobInfo.newBuilder((BlobId)this.getBlobId()).build(), new Storage.BlobWriteOption[0]));
    }

    public String getBlobName() {
        return this.location.getBlobName();
    }

    public boolean isBucket() {
        return this.location.isBucket();
    }

    public String getBucketName() {
        return this.location.getBucketName();
    }

    public GoogleStorageLocation getGoogleStorageLocation() {
        return this.location;
    }

    private BlobId getBlobId() {
        if (this.isBucket()) {
            throw new IllegalStateException("No blob id specified in the location: '" + this.getURI() + "', and the operation is not allowed on buckets.");
        }
        return BlobId.of((String)this.getBucketName(), (String)this.getBlobName());
    }
}

