/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.springdata;

import com.google.cloud.spanner.r2dbc.v2.JsonWrapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

@ReadingConverter
public class JsonToMapConverter<K, V>
implements Converter<JsonWrapper, Map<K, V>> {
    private final Gson gson;

    @Autowired
    public JsonToMapConverter(Gson gson) {
        this.gson = gson;
    }

    public Map<K, V> convert(JsonWrapper json) throws JsonSyntaxException {
        return (Map)this.gson.fromJson(json.toString(), Map.class);
    }
}

