/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.postgres;

import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.InternalConnectorRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketFactory
extends javax.net.SocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(SocketFactory.class);
    private static final String DEPRECATED_SOCKET_ARG = "SocketFactoryArg";
    private static final String POSTGRES_SUFFIX = "/.s.PGSQL.5432";
    private final Properties props;

    public SocketFactory(Properties info) {
        String oldInstanceKey = info.getProperty(DEPRECATED_SOCKET_ARG);
        if (oldInstanceKey != null) {
            logger.debug(String.format("The '%s' property has been deprecated. Please update your postgres driver and usethe  '%s' property in your JDBC url instead.", DEPRECATED_SOCKET_ARG, "cloudSqlInstance"));
            info.setProperty("cloudSqlInstance", oldInstanceKey);
        }
        this.props = info;
    }

    @Deprecated
    public SocketFactory(String instanceName) {
        this(SocketFactory.createDefaultProperties(instanceName));
    }

    private static Properties createDefaultProperties(String instanceName) {
        Properties info = new Properties();
        info.setProperty(DEPRECATED_SOCKET_ARG, instanceName);
        info.setProperty("cloudSqlUnixSocketPathSuffix", POSTGRES_SUFFIX);
        return info;
    }

    @Override
    public Socket createSocket() throws IOException {
        try {
            return InternalConnectorRegistry.getInstance().connect(ConnectionConfig.fromConnectionProperties((Properties)this.props));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Socket createSocket(String host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        throw new UnsupportedOperationException();
    }

    static {
        InternalConnectorRegistry.addArtifactId((String)"postgres-socket-factory");
    }
}

