/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplate;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class PushContainerConfigurationStep
implements Callable<BlobDescriptor> {
    private static final String DESCRIPTION = "Pushing container configuration";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    @Nullable
    private final Authorization pushAuthorization;
    private final Image builtImage;

    PushContainerConfigurationStep(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, @Nullable Authorization authenticatePushStep, Image builtImage) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.pushAuthorization = authenticatePushStep;
        this.builtImage = builtImage;
    }

    @Override
    public BlobDescriptor call() throws IOException, RegistryException {
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = this.progressEventDispatcherFactory.create("pushing container configuration", 1L);){
            BlobDescriptor blobDescriptor;
            TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventHandlers(), DESCRIPTION);
            Throwable throwable2 = null;
            try {
                JsonTemplate containerConfiguration = new ImageToJsonTranslator(this.builtImage).getContainerConfiguration();
                blobDescriptor = new PushBlobStep(this.buildConfiguration, progressEventDispatcher.newChildProducer(), this.pushAuthorization, Digests.computeDigest(containerConfiguration), Blobs.from(containerConfiguration), false).call();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        PushContainerConfigurationStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            PushContainerConfigurationStep.$closeResource(throwable2, ignored);
            return blobDescriptor;
        }
    }
}

