/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.progress.ThrottledAccumulatingConsumer;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;

public class SaveDockerStep
implements Callable<Path> {
    private final BuildConfiguration buildConfiguration;
    private final DockerClient dockerClient;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;

    SaveDockerStep(BuildConfiguration buildConfiguration, DockerClient dockerClient, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildConfiguration = buildConfiguration;
        this.dockerClient = dockerClient;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
    }

    @Override
    public Path call() throws IOException, InterruptedException {
        Path outputDir = Files.createTempDirectory("jib-docker-save", new FileAttribute[0]);
        FileOperations.deleteRecursiveOnExit(outputDir);
        Path outputPath = outputDir.resolve("out.tar");
        ImageReference imageReference = this.buildConfiguration.getBaseImageConfiguration().getImage();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventHandlers(), "Saving " + imageReference + " from Docker daemon");){
            long size = this.dockerClient.sizeOf(imageReference);
            try (ProgressEventDispatcher progressEventDispatcher = this.progressEventDispatcherFactory.create("saving base image " + imageReference, size);
                 ThrottledAccumulatingConsumer throttledProgressReporter = new ThrottledAccumulatingConsumer(progressEventDispatcher::dispatchProgress);){
                this.dockerClient.save(imageReference, outputPath, throttledProgressReporter);
            }
            Path path = outputPath;
            return path;
        }
    }
}

