/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class UserCacheHome {
    private static final Logger logger = Logger.getLogger(UserCacheHome.class.getName());

    public static Path getCacheHome() {
        return UserCacheHome.getCacheHome(System.getProperties(), System.getenv());
    }

    @VisibleForTesting
    static Path getCacheHome(Properties properties, Map<String, String> environment) {
        String xdgCacheHome = environment.get("XDG_CACHE_HOME");
        if (xdgCacheHome != null && !xdgCacheHome.trim().isEmpty()) {
            return Paths.get(xdgCacheHome, new String[0]);
        }
        String userHome = properties.getProperty("user.home");
        Path xdgPath = Paths.get(userHome, ".cache");
        String rawOsName = properties.getProperty("os.name");
        String osName = rawOsName.toLowerCase(Locale.ENGLISH);
        if (osName.contains("linux")) {
            return xdgPath;
        }
        if (osName.contains("windows")) {
            String localAppDataEnv = environment.get("LOCALAPPDATA");
            if (localAppDataEnv == null || localAppDataEnv.trim().isEmpty()) {
                logger.warning("LOCALAPPDATA environment is invalid or missing");
                return xdgPath;
            }
            Path localAppData = Paths.get(localAppDataEnv, new String[0]);
            if (!Files.exists(localAppData, new LinkOption[0])) {
                logger.warning(localAppData + " does not exist");
                return xdgPath;
            }
            return localAppData;
        }
        if (osName.contains("mac") || osName.contains("darwin")) {
            Path applicationSupport = Paths.get(userHome, "Library", "Application Support");
            if (!Files.exists(applicationSupport, new LinkOption[0])) {
                logger.warning(applicationSupport + " does not exist");
                return xdgPath;
            }
            return applicationSupport;
        }
        throw new IllegalStateException("Unknown OS: " + rawOsName);
    }

    private UserCacheHome() {
    }
}

