/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.plugins.common.VersionChecker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MojoCommon {
    @VisibleForTesting
    public static final String REQUIRED_VERSION_PROPERTY_NAME = "jib.requiredVersion";

    @Deprecated
    static void checkUseCurrentTimestampDeprecation(JibPluginConfiguration jibPluginConfiguration) {
        if (jibPluginConfiguration.getUseCurrentTimestamp()) {
            if (!jibPluginConfiguration.getCreationTime().equals("EPOCH")) {
                throw new IllegalArgumentException("You cannot configure both <container><useCurrentTimestamp> and <container><creationTime>");
            }
            jibPluginConfiguration.getLog().warn((CharSequence)"<container><useCurrentTimestamp> is deprecated; use <container><creationTime> with the value USE_CURRENT_TIMESTAMP instead");
        }
    }

    static List<Path> getExtraDirectories(JibPluginConfiguration jibPluginConfiguration) {
        List<Path> paths = jibPluginConfiguration.getExtraDirectories();
        if (!paths.isEmpty()) {
            return paths;
        }
        MavenProject project = (MavenProject)Preconditions.checkNotNull((Object)jibPluginConfiguration.getProject());
        return Collections.singletonList(project.getBasedir().toPath().resolve("src").resolve("main").resolve("jib"));
    }

    @VisibleForTesting
    static Map<AbsoluteUnixPath, FilePermissions> convertPermissionsList(List<JibPluginConfiguration.PermissionConfiguration> permissionList) {
        HashMap<AbsoluteUnixPath, FilePermissions> permissionsMap = new HashMap<AbsoluteUnixPath, FilePermissions>();
        for (JibPluginConfiguration.PermissionConfiguration permission : permissionList) {
            if (!permission.getFile().isPresent() || !permission.getMode().isPresent()) {
                throw new IllegalArgumentException("Incomplete <permission> configuration; requires <file> and <mode> fields to be set");
            }
            AbsoluteUnixPath key = AbsoluteUnixPath.get(permission.getFile().get());
            FilePermissions value = FilePermissions.fromOctalString(permission.getMode().get());
            permissionsMap.put(key, value);
        }
        return permissionsMap;
    }

    public static void checkJibVersion(PluginDescriptor descriptor) throws MojoExecutionException {
        String acceptableVersionSpec = System.getProperty(REQUIRED_VERSION_PROPERTY_NAME);
        if (acceptableVersionSpec == null) {
            return;
        }
        String actualVersion = descriptor.getVersion();
        if (actualVersion == null) {
            throw new MojoExecutionException("Could not determine Jib plugin version");
        }
        VersionChecker<DefaultArtifactVersion> checker = new VersionChecker<DefaultArtifactVersion>(DefaultArtifactVersion::new);
        if (!checker.compatibleVersion(acceptableVersionSpec, actualVersion)) {
            String failure = String.format("Jib plugin version is %s but is required to be %s", actualVersion, acceptableVersionSpec);
            throw new MojoExecutionException(failure);
        }
    }

    public static boolean shouldSkipJibExecution(JibPluginConfiguration jibPluginConfiguration) {
        Log log = jibPluginConfiguration.getLog();
        if (jibPluginConfiguration.isSkipped()) {
            log.info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return true;
        }
        if (!jibPluginConfiguration.isContainerizable()) {
            log.info((CharSequence)"Skipping containerization of this module (not specified in jib.containerize)");
            return true;
        }
        if ("pom".equals(jibPluginConfiguration.getProject().getPackaging())) {
            log.info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return true;
        }
        return false;
    }

    private MojoCommon() {
    }
}

