/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.LayerEntry;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Deprecated
@Immutable
public class LayerConfiguration {
    public static final BiFunction<Path, AbsoluteUnixPath, FilePermissions> DEFAULT_FILE_PERMISSIONS_PROVIDER = FileEntriesLayer.DEFAULT_FILE_PERMISSIONS_PROVIDER;
    public static final Instant DEFAULT_MODIFICATION_TIME = FileEntriesLayer.DEFAULT_MODIFICATION_TIME;
    public static final BiFunction<Path, AbsoluteUnixPath, Instant> DEFAULT_MODIFICATION_TIME_PROVIDER = FileEntriesLayer.DEFAULT_MODIFICATION_TIME_PROVIDER;
    private final FileEntriesLayer fileEntriesLayer;

    public static Builder builder() {
        return new Builder();
    }

    private LayerConfiguration(FileEntriesLayer fileEntriesLayer) {
        this.fileEntriesLayer = fileEntriesLayer;
    }

    public String getName() {
        return this.fileEntriesLayer.getName();
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        List entries = this.fileEntriesLayer.getEntries();
        return (ImmutableList)entries.stream().map(LayerEntry::new).collect(ImmutableList.toImmutableList());
    }

    FileEntriesLayer toFileEntriesLayer() {
        return this.fileEntriesLayer;
    }

    public static class Builder {
        private FileEntriesLayer.Builder builder = FileEntriesLayer.builder();

        private Builder() {
        }

        public Builder setName(String name) {
            this.builder.setName(name);
            return this;
        }

        public Builder setEntries(List<LayerEntry> entries) {
            this.builder.setEntries(entries.stream().map(LayerEntry::toFileEntry).collect(Collectors.toList()));
            return this;
        }

        public Builder addEntry(LayerEntry entry) {
            this.builder.addEntry(entry.toFileEntry());
            return this;
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer) {
            this.builder.addEntry(sourceFile, pathInContainer);
            return this;
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissions permissions) {
            this.builder.addEntry(sourceFile, pathInContainer, permissions);
            return this;
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, Instant modificationTime) {
            this.builder.addEntry(sourceFile, pathInContainer, modificationTime);
            return this;
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissions permissions, Instant modificationTime) {
            this.builder.addEntry(new FileEntry(sourceFile, pathInContainer, permissions, modificationTime));
            return this;
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer) throws IOException {
            this.builder.addEntryRecursive(sourceFile, pathInContainer);
            return this;
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer, BiFunction<Path, AbsoluteUnixPath, FilePermissions> filePermissionProvider) throws IOException {
            this.builder.addEntryRecursive(sourceFile, pathInContainer, filePermissionProvider);
            return this;
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer, BiFunction<Path, AbsoluteUnixPath, FilePermissions> filePermissionProvider, BiFunction<Path, AbsoluteUnixPath, Instant> modificationTimeProvider) throws IOException {
            this.builder.addEntryRecursive(sourceFile, pathInContainer, filePermissionProvider, modificationTimeProvider);
            return this;
        }

        public LayerConfiguration build() {
            return new LayerConfiguration(this.builder.build());
        }
    }
}

