/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.HttpContent;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class BlobHttpContent
implements HttpContent {
    private final Blob blob;
    private final String contentType;
    private final Consumer<Long> writtenByteCountListener;

    public BlobHttpContent(Blob blob, String contentType) {
        this(blob, contentType, ignored -> {});
    }

    public BlobHttpContent(Blob blob, String contentType, Consumer<Long> writtenByteCountListener) {
        this.blob = blob;
        this.contentType = contentType;
        this.writtenByteCountListener = writtenByteCountListener;
    }

    public long getLength() {
        return -1L;
    }

    public String getType() {
        return this.contentType;
    }

    public boolean retrySupported() {
        return false;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.blob.writeTo(new NotifyingOutputStream(outputStream, this.writtenByteCountListener));
        outputStream.flush();
    }
}

