/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.CheckImageStep;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.LocalBaseImageSteps;
import com.google.cloud.tools.jib.builder.steps.ObtainBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayerStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StepsRunner {
    private final StepResults results = new StepResults();
    private final ExecutorService executorService;
    private final BuildContext buildContext;
    private final TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
    private final List<Runnable> stepsToRun = new ArrayList<Runnable>();
    @Nullable
    private String rootProgressDescription;
    @Nullable
    private ProgressEventDispatcher rootProgressDispatcher;

    public static StepsRunner begin(BuildContext buildContext) {
        Object executorService = JibSystemProperties.serializeExecution() ? MoreExecutors.newDirectExecutorService() : buildContext.getExecutorService();
        return new StepsRunner(MoreExecutors.listeningDecorator((ExecutorService)executorService), buildContext);
    }

    private static <E> List<E> realizeFutures(List<Future<E>> futures) throws InterruptedException, ExecutionException {
        ArrayList<E> values = new ArrayList<E>();
        for (Future<E> future : futures) {
            values.add(future.get());
        }
        return values;
    }

    private StepsRunner(ListeningExecutorService executorService, BuildContext buildContext) {
        this.executorService = executorService;
        this.buildContext = buildContext;
    }

    public StepsRunner dockerLoadSteps(DockerClient dockerClient) {
        this.rootProgressDescription = "building image to Docker daemon";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImages);
        this.stepsToRun.add(() -> this.loadDocker(dockerClient));
        return this;
    }

    public StepsRunner tarBuildSteps(Path outputPath) {
        this.rootProgressDescription = "building image to tar file";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImages);
        this.stepsToRun.add(() -> this.writeTarFile(outputPath));
        return this;
    }

    public StepsRunner registryPushSteps() {
        this.rootProgressDescription = "building image to registry";
        boolean layersRequiredLocally = this.buildContext.getAlwaysCacheBaseImage();
        this.stepsToRun.add(this::authenticateBearerPush);
        this.addRetrievalSteps(layersRequiredLocally);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImages);
        this.stepsToRun.add(this::pushBaseImageLayers);
        this.stepsToRun.add(this::pushApplicationLayers);
        this.stepsToRun.add(this::pushContainerConfiguration);
        this.stepsToRun.add(this::checkImageInTargetRegistry);
        this.stepsToRun.add(this::pushImages);
        return this;
    }

    /*
     * Exception decompiling
     */
    public BuildResult run() throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addRetrievalSteps(boolean layersRequiredLocally) {
        ImageConfiguration baseImageConfiguration = this.buildContext.getBaseImageConfiguration();
        if (baseImageConfiguration.getTarPath().isPresent()) {
            this.stepsToRun.add(this::extractTar);
        } else if (baseImageConfiguration.getDockerClient().isPresent()) {
            this.stepsToRun.add(this::saveDocker);
        } else {
            this.stepsToRun.add(this::pullBaseImages);
            this.stepsToRun.add(() -> this.obtainBaseImageLayers(layersRequiredLocally));
        }
    }

    private void authenticateBearerPush() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.targetRegistryClient = this.executorService.submit(() -> new AuthenticatePushStep(this.buildContext, childProgressDispatcherFactory).call());
    }

    private void saveDocker() {
        Optional<DockerClient> dockerClient = this.buildContext.getBaseImageConfiguration().getDockerClient();
        Preconditions.checkArgument((boolean)dockerClient.isPresent());
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.assignLocalImageResult(this.executorService.submit(LocalBaseImageSteps.retrieveDockerDaemonLayersStep(this.buildContext, childProgressDispatcherFactory, dockerClient.get(), this.tempDirectoryProvider)));
    }

    private void extractTar() {
        Optional<Path> tarPath = this.buildContext.getBaseImageConfiguration().getTarPath();
        Preconditions.checkArgument((boolean)tarPath.isPresent());
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.assignLocalImageResult(this.executorService.submit(LocalBaseImageSteps.retrieveTarLayersStep(this.buildContext, childProgressDispatcherFactory, tarPath.get(), this.tempDirectoryProvider)));
    }

    private void assignLocalImageResult(Future<LocalBaseImageSteps.LocalImage> localImage) {
        this.results.baseImagesAndRegistryClient = this.executorService.submit(() -> LocalBaseImageSteps.returnImageAndRegistryClientStep(StepsRunner.realizeFutures(((LocalBaseImageSteps.LocalImage)localImage.get()).layers), ((LocalBaseImageSteps.LocalImage)localImage.get()).configurationTemplate).call());
        this.results.baseImagesAndLayers = this.executorService.submit(() -> Collections.singletonMap(((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).images.get(0), ((LocalBaseImageSteps.LocalImage)localImage.get()).layers));
    }

    private void pullBaseImages() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImagesAndRegistryClient = this.executorService.submit(new PullBaseImageStep(this.buildContext, childProgressDispatcherFactory));
    }

    private void obtainBaseImageLayers(boolean layersRequiredLocally) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImagesAndLayers = this.executorService.submit(() -> {
            HashMap baseImagesAndLayers = new HashMap();
            for (Image image : ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).images) {
                List layers = this.scheduleCallables(layersRequiredLocally ? ObtainBaseImageLayerStep.makeListForForcedDownload(this.buildContext, childProgressDispatcherFactory, image, ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).registryClient) : ObtainBaseImageLayerStep.makeListForSelectiveDownload(this.buildContext, childProgressDispatcherFactory, image, ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).registryClient, (RegistryClient)this.results.targetRegistryClient.get()));
                baseImagesAndLayers.put(image, layers);
            }
            return baseImagesAndLayers;
        });
    }

    private void pushBaseImageLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageLayerPushResults = this.executorService.submit(() -> {
            ArrayList pushResults = new ArrayList();
            for (List baseImageLayers : ((Map)this.results.baseImagesAndLayers.get()).values()) {
                List baseImageLayerPushResult = this.scheduleCallables(PushLayerStep.makeList(this.buildContext, childProgressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (List)Verify.verifyNotNull((Object)baseImageLayers)));
                pushResults.add(baseImageLayerPushResult);
            }
            return pushResults;
        });
    }

    private void buildAndCacheApplicationLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.applicationLayers = this.scheduleCallables(BuildAndCacheApplicationLayerStep.makeList(this.buildContext, childProgressDispatcherFactory));
    }

    private void buildImages() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.builtImages = this.executorService.submit(() -> {
            ArrayList<Future<Image>> builtImages = new ArrayList<Future<Image>>();
            for (Map.Entry entry : ((Map)this.results.baseImagesAndLayers.get()).entrySet()) {
                Future<Image> builtImage = this.executorService.submit(() -> new BuildImageStep(this.buildContext, childProgressDispatcherFactory, (Image)entry.getKey(), StepsRunner.realizeFutures((List)Verify.verifyNotNull((Object)((List)entry.getValue()))), StepsRunner.realizeFutures((List)Verify.verifyNotNull((Object)this.results.applicationLayers))).call());
                builtImages.add(builtImage);
            }
            return builtImages;
        });
    }

    private void pushContainerConfiguration() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.builtImagesAndContainerConfigurationPushResults = this.executorService.submit(() -> {
            HashMap<Future, Future<BlobDescriptor>> pushResults = new HashMap<Future, Future<BlobDescriptor>>();
            for (Future builtImage : (List)this.results.builtImages.get()) {
                Future<BlobDescriptor> configPushResult = this.executorService.submit(() -> new PushContainerConfigurationStep(this.buildContext, childProgressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (Image)builtImage.get()).call());
                pushResults.put(builtImage, configPushResult);
            }
            return pushResults;
        });
    }

    private void pushApplicationLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.applicationLayerPushResults = this.executorService.submit(() -> this.scheduleCallables(PushLayerStep.makeList(this.buildContext, childProgressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (List)Verify.verifyNotNull((Object)this.results.applicationLayers))));
    }

    private void checkImageInTargetRegistry() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.manifestCheckResult = this.executorService.submit(() -> new CheckImageStep(this.buildContext, childProgressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (BlobDescriptor)((Future)Verify.verifyNotNull((Object)((Future)((Map)this.results.builtImagesAndContainerConfigurationPushResults.get()).get(((List)this.results.builtImages.get()).get(0))))).get(), (Image)((Future)((List)this.results.builtImages.get()).get(0)).get()).call());
    }

    private void pushImages() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> {
            StepsRunner.realizeFutures((List)((List)this.results.baseImageLayerPushResults.get()).get(0));
            StepsRunner.realizeFutures((List)this.results.applicationLayerPushResults.get());
            List manifestPushResults = this.scheduleCallables(PushImageStep.makeList(this.buildContext, childProgressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (BlobDescriptor)((Future)Verify.verifyNotNull((Object)((Future)((Map)this.results.builtImagesAndContainerConfigurationPushResults.get()).get(((List)this.results.builtImages.get()).get(0))))).get(), (Image)((Future)((List)this.results.builtImages.get()).get(0)).get(), ((Optional)this.results.manifestCheckResult.get()).isPresent()));
            StepsRunner.realizeFutures(manifestPushResults);
            return manifestPushResults.isEmpty() ? new BuildResult(((ManifestAndDigest)((Optional)this.results.manifestCheckResult.get()).get()).getDigest(), ((BlobDescriptor)((Future)Verify.verifyNotNull((Object)((Future)((Map)this.results.builtImagesAndContainerConfigurationPushResults.get()).get(((List)this.results.builtImages.get()).get(0))))).get()).getDigest()) : (BuildResult)manifestPushResults.get(0).get();
        });
    }

    private void loadDocker(DockerClient dockerClient) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> new LoadDockerStep(this.buildContext, childProgressDispatcherFactory, dockerClient, (Image)((Future)((List)this.results.builtImages.get()).get(0)).get()).call());
    }

    private void writeTarFile(Path outputPath) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> new WriteTarFileStep(this.buildContext, childProgressDispatcherFactory, outputPath, (Image)((Future)((List)this.results.builtImages.get()).get(0)).get()).call());
    }

    private <E> List<Future<E>> scheduleCallables(ImmutableList<? extends Callable<E>> callables) {
        return callables.stream().map(this.executorService::submit).collect(Collectors.toList());
    }

    private static class StepResults {
        private Future<PullBaseImageStep.ImagesAndRegistryClient> baseImagesAndRegistryClient = StepResults.failedFuture();
        private Future<Map<Image, List<Future<PreparedLayer>>>> baseImagesAndLayers = StepResults.failedFuture();
        @Nullable
        private List<Future<PreparedLayer>> applicationLayers;
        private Future<List<Future<Image>>> builtImages = StepResults.failedFuture();
        private Future<RegistryClient> targetRegistryClient = StepResults.failedFuture();
        private Future<List<List<Future<BlobDescriptor>>>> baseImageLayerPushResults = StepResults.failedFuture();
        private Future<List<Future<BlobDescriptor>>> applicationLayerPushResults = StepResults.failedFuture();
        private Future<Map<Future<Image>, Future<BlobDescriptor>>> builtImagesAndContainerConfigurationPushResults = StepResults.failedFuture();
        private Future<BuildResult> buildResult = StepResults.failedFuture();
        private Future<Optional<ManifestAndDigest<ManifestTemplate>>> manifestCheckResult = StepResults.failedFuture();

        private StepResults() {
        }

        private static <E> Future<E> failedFuture() {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("invalid usage; required step not configured"));
        }

        static /* synthetic */ Future access$100(StepResults x0) {
            return x0.buildResult;
        }
    }
}

