/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements Callable<PreparedLayer> {
    private static final String DESCRIPTION = "Building %s layer";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final String layerName;
    private final FileEntriesLayer layerConfiguration;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        ImmutableList<FileEntriesLayer> layerConfigurations = buildContext.getLayerConfigurations();
        try (ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("launching application layer builders", layerConfigurations.size());){
            TimerEventDispatcher ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), "Preparing application layer builders");
            try {
                ImmutableList immutableList = (ImmutableList)layerConfigurations.stream().filter(layerConfiguration -> !layerConfiguration.getEntries().isEmpty()).map(layerConfiguration -> new BuildAndCacheApplicationLayerStep(buildContext, progressEventDispatcher.newChildProducer(), layerConfiguration.getName(), (FileEntriesLayer)layerConfiguration)).collect(ImmutableList.toImmutableList());
                ignored.close();
                return immutableList;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private BuildAndCacheApplicationLayerStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, String layerName, FileEntriesLayer layerConfiguration) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.layerName = layerName;
        this.layerConfiguration = layerConfiguration;
    }

    @Override
    public PreparedLayer call() throws IOException, CacheCorruptedException {
        String description = String.format(DESCRIPTION, this.layerName);
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        eventHandlers.dispatch(LogEvent.progress(description + "..."));
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("building " + this.layerName + " layer", 1L);){
            ImmutableList layerEntries;
            Cache cache;
            TimerEventDispatcher ignored2;
            block13: {
                ignored2 = new TimerEventDispatcher(eventHandlers, description);
                try {
                    cache = this.buildContext.getApplicationLayersCache();
                    layerEntries = ImmutableList.copyOf((Collection)this.layerConfiguration.getEntries());
                    Optional<CachedLayer> optionalCachedLayer = cache.retrieve((ImmutableList<FileEntry>)layerEntries);
                    if (!optionalCachedLayer.isPresent()) break block13;
                    PreparedLayer preparedLayer = new PreparedLayer.Builder(optionalCachedLayer.get()).setName(this.layerName).build();
                    ignored2.close();
                    return preparedLayer;
                }
                catch (Throwable throwable) {
                    try {
                        ignored2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Blob layerBlob = new ReproducibleLayerBuilder((ImmutableList<FileEntry>)layerEntries).build();
            CachedLayer cachedLayer = cache.writeUncompressedLayer(layerBlob, (ImmutableList<FileEntry>)layerEntries);
            eventHandlers.dispatch(LogEvent.debug(description + " built " + cachedLayer.getDigest()));
            PreparedLayer preparedLayer = new PreparedLayer.Builder(cachedLayer).setName(this.layerName).build();
            ignored2.close();
            return preparedLayer;
        }
    }
}

