/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    private ZipUtil() {
    }

    public static void unzip(Path archive, Path destination) throws IOException {
        ZipUtil.unzip(archive, destination, false);
    }

    public static void unzip(Path archive, Path destination, boolean enableReproducibleTimestamps) throws IOException {
        if (enableReproducibleTimestamps && Files.isDirectory(destination, new LinkOption[0]) && destination.toFile().list().length != 0) {
            throw new IllegalStateException("Cannot enable reproducible timestamps. They can only be enabled when the target root doesn't exist or is an empty directory");
        }
        String canonicalDestination = destination.toFile().getCanonicalPath();
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        try (BufferedInputStream fileIn = new BufferedInputStream(Files.newInputStream(archive, new OpenOption[0]));
             ZipInputStream zipIn = new ZipInputStream(fileIn);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                entries.add(entry);
                Path entryPath = destination.resolve(entry.getName());
                String canonicalTarget = entryPath.toFile().getCanonicalPath();
                if (!canonicalTarget.startsWith(canonicalDestination + File.separator)) {
                    String offender = entry.getName() + " from " + archive;
                    throw new IOException("Blocked unzipping files outside destination: " + offender);
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    if (entryPath.getParent() != null) {
                        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    }
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(entryPath, new OpenOption[0]));){
                        ByteStreams.copy((InputStream)zipIn, (OutputStream)out);
                    }
                }
                entry = zipIn.getNextEntry();
            }
        }
        ZipUtil.preserveModificationTimes(destination, entries, enableReproducibleTimestamps);
    }

    private static void preserveModificationTimes(Path destination, List<ZipEntry> entries, boolean enableReproducibleTimestamps) throws IOException {
        if (enableReproducibleTimestamps) {
            FileTime epochPlusOne = FileTime.fromMillis(1000L);
            new DirectoryWalker(destination).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).walk(path -> Files.setLastModifiedTime(path, epochPlusOne));
        }
        for (ZipEntry entry : entries) {
            Files.setLastModifiedTime(destination.resolve(entry.getName()), entry.getLastModifiedTime());
        }
    }
}

