/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Comparators {
    private static final Ordering<Comparable> NATURAL_ORDER = new Ordering<Comparable>(){
        private static final long serialVersionUID = 4773556737939767552L;

        @Override
        public int compare(Comparable left, Comparable right) {
            if (left == right) {
                return 0;
            }
            int result = left.compareTo(right);
            return result;
        }

        private Object readResolve() {
            return NATURAL_ORDER;
        }
    };
    private static final Ordering<Comparable> NULL_LEAST_ORDER = Comparators.nullLeastOrder(NATURAL_ORDER);
    private static final Ordering<Comparable> NULL_GREATEST_ORDER = Comparators.nullGreatestOrder(NATURAL_ORDER);
    public static final Ordering<Object> STRING_FORM_ORDER = Comparators.fromFunction(Functions.TO_STRING);

    private Comparators() {
    }

    public static <C extends Comparable> Ordering<C> naturalOrder() {
        return NATURAL_ORDER;
    }

    public static <T> Ordering<T> nullLeastOrder(Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        return new NullHandlingOrdering<T>((Comparator)comparator){
            private static final long serialVersionUID = 6553795663477987335L;

            @Override
            int compareNullAndNonNull() {
                return -1;
            }
        };
    }

    public static <C extends Comparable> Ordering<C> nullLeastOrder() {
        return NULL_LEAST_ORDER;
    }

    public static <T> Ordering<T> nullGreatestOrder(Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        return new NullHandlingOrdering<T>((Comparator)comparator){
            private static final long serialVersionUID = -5657312031376122631L;

            @Override
            int compareNullAndNonNull() {
                return 1;
            }
        };
    }

    public static <C extends Comparable> Ordering<C> nullGreatestOrder() {
        return NULL_GREATEST_ORDER;
    }

    public static <T> Ordering<T> compound(Comparator<? super T> primary, Comparator<? super T> secondary, Comparator<? super T> ... rest) {
        Comparator<? super T> primaryT = primary;
        Comparator<? super T> secondaryT = secondary;
        Comparator<? super T>[] restT = rest;
        return Comparators.compound(Lists.asList(primaryT, secondaryT, restT));
    }

    public static <T> Ordering<T> compound(List<? extends Comparator<? super T>> comparators) {
        return new CompoundOrder(comparators);
    }

    public static <F, T extends Comparable> Ordering<F> fromFunction(Function<F, T> function) {
        return new TransformingNaturalOrder<F, T>(function);
    }

    public static <F, T> Ordering<F> fromFunction(Function<F, T> function, Comparator<? super T> comparator) {
        return new TransformingOrder<F, T>(function, comparator);
    }

    public static <T extends Comparable> T min(T a, T b) {
        int result = a.compareTo(b);
        return result <= 0 ? a : b;
    }

    public static <T extends Comparable> T max(T a, T b) {
        int result = a.compareTo(b);
        return result >= 0 ? a : b;
    }

    public static <T> T min(Comparator<? super T> comparator, @Nullable T a, @Nullable T b) {
        return comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> T max(Comparator<? super T> comparator, @Nullable T a, @Nullable T b) {
        return comparator.compare(a, b) >= 0 ? a : b;
    }

    public static <T> Ordering<T> givenOrder(List<T> valuesInOrder) {
        return new GivenOrder<T>(valuesInOrder);
    }

    public static <T> Ordering<T> givenOrder(@Nullable T leastValue, T ... remainingValuesInOrder) {
        return Comparators.givenOrder(Lists.asList(leastValue, remainingValuesInOrder));
    }

    public static int compare(byte a, byte b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(char a, char b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(short a, short b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    public static int compare(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NullHandlingOrdering<T>
    extends Ordering<T> {
        final Comparator<T> comparator;

        public NullHandlingOrdering(Comparator<T> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public int compare(T left, T right) {
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return this.compareNullAndNonNull();
            }
            if (right == null) {
                return -this.compareNullAndNonNull();
            }
            return this.comparator.compare(left, right);
        }

        abstract int compareNullAndNonNull();

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                NullHandlingOrdering that = (NullHandlingOrdering)object;
                return ((Object)this.comparator).equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return this.comparator.hashCode();
        }
    }

    static class DuplicateValueException
    extends IllegalArgumentException {
        final Object value;
        final int firstIndex;
        final int secondIndex;

        DuplicateValueException(Object value, int firstIndex, int secondIndex) {
            super(String.format("Duplicate value at indices %s and %s: %s", firstIndex, secondIndex, value));
            this.value = value;
            this.firstIndex = firstIndex;
            this.secondIndex = secondIndex;
        }
    }

    static class IncomparableValueException
    extends ClassCastException {
        final Object value;

        IncomparableValueException(Object value) {
            super("Cannot compare value: " + value);
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GivenOrder<T>
    extends Ordering<T> {
        final Map<T, Integer> rankMap;
        private static final long serialVersionUID = 1841692415248046482L;

        GivenOrder(List<T> valuesInOrder) {
            this.rankMap = GivenOrder.buildRankMap(valuesInOrder);
        }

        @Override
        public int compare(T left, T right) {
            return this.rank(left) - this.rank(right);
        }

        int rank(T value) {
            Integer rank = this.rankMap.get(value);
            if (rank == null) {
                throw new IncomparableValueException(value);
            }
            return rank;
        }

        static <T> Map<T, Integer> buildRankMap(Collection<T> valuesInOrder) {
            HashMap<T, Integer> ranks = Maps.newHashMapWithExpectedSize(valuesInOrder.size());
            Object previousValue = null;
            int rank = 0;
            for (T value : valuesInOrder) {
                Integer priorRank;
                if (!(rank != 0 && Objects.equal(value, previousValue) || (priorRank = ranks.put(value, rank)) == null)) {
                    throw new DuplicateValueException(value, priorRank, rank);
                }
                ++rank;
                previousValue = value;
            }
            return ranks;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof GivenOrder) {
                GivenOrder that = (GivenOrder)object;
                return ((Object)this.rankMap).equals(that.rankMap);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.rankMap).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TransformingOrder<F, T>
    extends Ordering<F> {
        private final Function<F, T> function;
        private final Comparator<? super T> comparator;
        private static final long serialVersionUID = 5364346520892770700L;

        TransformingOrder(Function<F, T> function, Comparator<? super T> comparator) {
            this.function = Preconditions.checkNotNull(function);
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public int compare(F left, F right) {
            return this.comparator.compare(this.function.apply(left), this.function.apply(right));
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof TransformingOrder) {
                TransformingOrder that = (TransformingOrder)object;
                return ((Object)this.function).equals(that.function) && ((Object)this.comparator).equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.function, this.comparator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingNaturalOrder<F, T extends Comparable>
    extends Ordering<F> {
        private final Function<F, T> function;
        private static final long serialVersionUID = 4211028873657370047L;

        TransformingNaturalOrder(Function<F, T> function) {
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public int compare(F left, F right) {
            Comparable leftTransformed = (Comparable)this.function.apply(left);
            Comparable rightTransformed = (Comparable)this.function.apply(right);
            int result = leftTransformed.compareTo(rightTransformed);
            return result;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof TransformingNaturalOrder) {
                TransformingNaturalOrder that = (TransformingNaturalOrder)object;
                return ((Object)this.function).equals(that.function);
            }
            return false;
        }

        public int hashCode() {
            return this.function.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompoundOrder<T>
    extends Ordering<T> {
        private final List<? extends Comparator<? super T>> comparators;
        private static final long serialVersionUID = 5950260273184699058L;

        CompoundOrder(List<? extends Comparator<? super T>> comparators) {
            this.comparators = Preconditions.checkContentsNotNull(comparators);
        }

        @Override
        public int compare(T left, T right) {
            if (left == right) {
                return 0;
            }
            for (Comparator<T> comparator : this.comparators) {
                int result = comparator.compare(left, right);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof CompoundOrder) {
                CompoundOrder that = (CompoundOrder)object;
                return ((Object)this.comparators).equals(that.comparators);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.comparators).hashCode();
        }
    }
}

