/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.Iterables;
import java.util.EnumMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMapBasedMultiset<E> {
    private static final long serialVersionUID = -3657226655572850764L;

    public EnumMultiset(Class<E> type) {
        super(new EnumMap(type));
    }

    public EnumMultiset(Iterable<E> elements) {
        this(EnumMultiset.findClass(elements));
        Iterables.addAll(this, elements);
    }

    private static <E extends Enum<E>> Class<E> findClass(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        return ((Enum)iterator.next()).getDeclaringClass();
    }
}

