/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultisetEntry;
import com.google.common.collect.Comparators;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.SerializableComparator;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TreeMultiset;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Multisets {
    private static final Multiset<?> EMPTY_MULTISET = new EmptyMultiset();
    private static final Multiset<?> IMMUTABLE_EMPTY_MULTISET = Multisets.unmodifiableMultiset(new EmptyMultiset());

    private Multisets() {
    }

    public static <E> HashMultiset<E> newHashMultiset() {
        return new HashMultiset();
    }

    public static <E> HashMultiset<E> newHashMultiset(E ... elements) {
        HashMultiset multiset = new HashMultiset();
        Collections.addAll(multiset, elements);
        return multiset;
    }

    public static <E> HashMultiset<E> newHashMultiset(Iterable<? extends E> elements) {
        return new HashMultiset<E>(elements);
    }

    public static <E extends Comparable> TreeMultiset<E> newTreeMultiset() {
        return new TreeMultiset();
    }

    public static <E> TreeMultiset<E> newTreeMultiset(Comparator<? super E> c) {
        return new TreeMultiset<E>(c);
    }

    public static <E extends Enum<E>> EnumMultiset<E> newEnumMultiset(Class<E> type) {
        return new EnumMultiset<E>(type);
    }

    public static <E extends Enum<E>> EnumMultiset<E> newEnumMultiset(Iterable<E> elements) {
        return new EnumMultiset<E>(elements);
    }

    public static <E extends Enum<E>> EnumMultiset<E> newEnumMultiset(E ... elements) {
        Preconditions.checkArgument(elements.length > 0, "newEnumMultiset requires at least one element");
        EnumMultiset<E> multiset = Multisets.newEnumMultiset(((Enum)elements[0]).getDeclaringClass());
        Collections.addAll(multiset, elements);
        return multiset;
    }

    public static <E> Multiset<E> unmodifiableMultiset(Multiset<E> multiset) {
        return new ForwardingMultiset<E>((Multiset)multiset){
            volatile transient Set<E> elementSet;
            volatile transient Set<Multiset.Entry<E>> entrySet;

            @Override
            public Set<E> elementSet() {
                if (this.elementSet == null) {
                    this.elementSet = Collections.unmodifiableSet(super.elementSet());
                }
                return this.elementSet;
            }

            @Override
            public Set<Multiset.Entry<E>> entrySet() {
                if (this.entrySet == null) {
                    this.entrySet = Collections.unmodifiableSet(super.entrySet());
                }
                return this.entrySet;
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.unmodifiableIterator(super.iterator());
            }

            @Override
            public boolean add(E element) {
                throw this.up();
            }

            @Override
            public boolean add(E element, int occurences) {
                throw this.up();
            }

            @Override
            public boolean addAll(Collection<? extends E> elementsToAdd) {
                throw this.up();
            }

            @Override
            public boolean remove(Object element) {
                throw this.up();
            }

            @Override
            public int remove(Object element, int occurrences) {
                throw this.up();
            }

            @Override
            public int removeAllOccurrences(Object element) {
                throw this.up();
            }

            @Override
            public boolean removeAll(Collection<?> elementsToRemove) {
                throw this.up();
            }

            @Override
            public boolean retainAll(Collection<?> elementsToRetain) {
                throw this.up();
            }

            @Override
            public void clear() {
                throw this.up();
            }

            UnsupportedOperationException up() {
                return new UnsupportedOperationException();
            }
        };
    }

    public static <E> Multiset<E> synchronizedMultiset(Multiset<E> multiset) {
        return Synchronized.multiset(multiset, null);
    }

    public static <E> Multiset<E> emptyMultiset() {
        return EMPTY_MULTISET;
    }

    public static <E> Multiset.Entry<E> immutableEntry(final E e, final int n) {
        return new AbstractMultisetEntry<E>(){

            @Override
            public E getElement() {
                return e;
            }

            @Override
            public int getCount() {
                return n;
            }
        };
    }

    public static <E> Multiset<E> forSet(Set<E> set) {
        return new SetMultiset<E>(set);
    }

    public static <E> Multiset<E> immutableMultiset() {
        return IMMUTABLE_EMPTY_MULTISET;
    }

    public static <E> Multiset<E> immutableMultiset(E ... elements) {
        return elements.length == 0 ? Multisets.immutableMultiset() : Multisets.unmodifiableMultiset(Multisets.newHashMultiset(elements));
    }

    static int inferDistinctElements(Iterable<?> elements) {
        if (elements instanceof Multiset) {
            return ((Multiset)elements).elementSet().size();
        }
        return 11;
    }

    public static <T> Comparator<T> frequencyOrder(Multiset<?> multiset) {
        return new FrequencyOrder(multiset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyOrder<T>
    implements SerializableComparator<T> {
        final Multiset<?> multiset;
        private static final long serialVersionUID = -6424503578659119387L;

        FrequencyOrder(Multiset<?> multiset) {
            this.multiset = Preconditions.checkNotNull(multiset);
        }

        @Override
        public int compare(T left, T right) {
            int leftCount = this.multiset.count(left);
            int rightCount = this.multiset.count(right);
            return Comparators.compare(leftCount, rightCount);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof FrequencyOrder) {
                FrequencyOrder that = (FrequencyOrder)object;
                return ((Object)this.multiset).equals(that.multiset);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.multiset).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetMultiset<E>
    extends ForwardingCollection<E>
    implements Multiset<E>,
    Serializable {
        volatile transient Set<E> elementSet;
        volatile transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 7787490547740866319L;

        SetMultiset(Set<E> set) {
            super(set);
        }

        @Override
        protected Set<E> delegate() {
            return (Set)super.delegate();
        }

        @Override
        public int count(Object element) {
            return this.delegate().contains(element) ? 1 : 0;
        }

        @Override
        public boolean add(E element, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object element, int occurrences) {
            if (occurrences == 0) {
                return 0;
            }
            Preconditions.checkArgument(occurrences > 0);
            return this.removeAllOccurrences(element);
        }

        @Override
        public int removeAllOccurrences(Object element) {
            return this.delegate().remove(element) ? 1 : 0;
        }

        @Override
        public Set<E> elementSet() {
            if (this.elementSet == null) {
                this.elementSet = new ElementSet();
            }
            return this.elementSet;
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySet();
            }
            return this.entrySet;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Multiset)) {
                return false;
            }
            Multiset m = (Multiset)o;
            return this.size() == m.size() && ((Object)this.delegate()).equals(m.elementSet());
        }

        @Override
        public int hashCode() {
            int sum = 0;
            for (Object e : this) {
                sum += (e == null ? 0 : e.hashCode()) ^ 1;
            }
            return sum;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntrySet
        extends AbstractSet<Multiset.Entry<E>> {
            EntrySet() {
            }

            @Override
            public int size() {
                return SetMultiset.this.delegate().size();
            }

            @Override
            public Iterator<Multiset.Entry<E>> iterator() {
                return new Iterator<Multiset.Entry<E>>(){
                    final Iterator<E> elements;
                    {
                        this.elements = SetMultiset.this.delegate().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.elements.hasNext();
                    }

                    @Override
                    public Multiset.Entry<E> next() {
                        return Multisets.immutableEntry(this.elements.next(), 1);
                    }

                    @Override
                    public void remove() {
                        this.elements.remove();
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElementSet
        extends ForwardingSet<E> {
            ElementSet() {
                super(SetMultiset.this.delegate());
            }

            @Override
            public boolean add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> c) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyMultiset<E>
    extends AbstractCollection<E>
    implements Multiset<E>,
    Serializable {
        private static final long serialVersionUID = -4387083049544049902L;

        private EmptyMultiset() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int count(Object element) {
            return 0;
        }

        @Override
        public boolean add(E element, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object element, int occurrences) {
            return 0;
        }

        @Override
        public int removeAllOccurrences(Object element) {
            return 0;
        }

        @Override
        public Set<E> elementSet() {
            return Collections.emptySet();
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Multiset)) {
                return false;
            }
            return ((Multiset)obj).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_MULTISET;
        }
    }
}

