/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.collect.Multimap;
import com.google.common.collect.StandardSortedSetMultimap;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeMultimap<K, V>
extends StandardSortedSetMultimap<K, V> {
    private final Comparator<? super K> keyComparator;
    private final Comparator<? super V> valueComparator;
    private static final long serialVersionUID = 4309375142408689415L;

    public TreeMultimap() {
        this(null, null);
    }

    public TreeMultimap(@Nullable Comparator<? super K> keyComparator, @Nullable Comparator<? super V> valueComparator) {
        super(keyComparator == null ? new TreeMap() : new TreeMap(keyComparator));
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
    }

    public TreeMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap instanceof TreeMultimap ? ((TreeMultimap)multimap).keyComparator : null, multimap instanceof TreeMultimap ? ((TreeMultimap)multimap).valueComparator : null, multimap);
    }

    public TreeMultimap(@Nullable Comparator<? super K> keyComparator, @Nullable Comparator<? super V> valueComparator, Multimap<? extends K, ? extends V> multimap) {
        this(keyComparator, valueComparator);
        this.putAll(multimap);
    }

    @Override
    SortedSet<V> createCollection() {
        return this.valueComparator == null ? new TreeSet() : new TreeSet<V>(this.valueComparator);
    }

    public Comparator<? super K> keyComparator() {
        return this.keyComparator;
    }

    public Comparator<? super V> valueComparator() {
        return this.valueComparator;
    }

    @Override
    public SortedSet<K> keySet() {
        return (SortedSet)super.keySet();
    }
}

