/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeMultiset<E>
extends AbstractMapBasedMultiset<E> {
    private static final long serialVersionUID = 980261132547708887L;

    public TreeMultiset() {
        super(new TreeMap());
    }

    public TreeMultiset(Comparator<? super E> comparator) {
        super(new TreeMap(comparator));
    }

    public TreeMultiset(Iterable<? extends E> elements) {
        this();
        Iterables.addAll(this, elements);
    }

    @Override
    public SortedSet<E> elementSet() {
        return (SortedSet)super.elementSet();
    }

    @Override
    protected Set<E> createElementSet() {
        return new SortedMapBasedElementSet((SortedMap)this.backingMap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedMapBasedElementSet
    extends AbstractMapBasedMultiset.MapBasedElementSet
    implements SortedSet<E> {
        SortedMapBasedElementSet(SortedMap<E, AtomicInteger> map) {
            super(TreeMultiset.this, map);
        }

        SortedMap<E, AtomicInteger> sortedMap() {
            return (SortedMap)this.getMap();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public E first() {
            return this.sortedMap().firstKey();
        }

        @Override
        public E last() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new SortedMapBasedElementSet(this.sortedMap().headMap(toElement));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new SortedMapBasedElementSet(this.sortedMap().subMap(fromElement, toElement));
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new SortedMapBasedElementSet(this.sortedMap().tailMap(fromElement));
        }
    }
}

