/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.CryptoFormat;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.internal.MutableSerializationRegistry;
import com.google.crypto.tink.internal.ProtoKeySerialization;
import com.google.crypto.tink.monitoring.MonitoringAnnotations;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Hex;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public final class PrimitiveSet<P> {
    private final ConcurrentMap<Prefix, List<Entry<P>>> primitives;
    private Entry<P> primary;
    private final Class<P> primitiveClass;
    private final MonitoringAnnotations annotations;
    private final boolean isMutable;

    private static <P> Entry<P> addEntryToMap(@Nullable P fullPrimitive, @Nullable P primitive, Keyset.Key key, ConcurrentMap<Prefix, List<Entry<P>>> primitives) throws GeneralSecurityException {
        Integer idRequirement = key.getKeyId();
        if (key.getOutputPrefixType() == OutputPrefixType.RAW) {
            idRequirement = null;
        }
        Key keyObject = MutableSerializationRegistry.globalInstance().parseKeyWithLegacyFallback(ProtoKeySerialization.create(key.getKeyData().getTypeUrl(), key.getKeyData().getValue(), key.getKeyData().getKeyMaterialType(), key.getOutputPrefixType(), idRequirement), InsecureSecretKeyAccess.get());
        Entry<P> entry = new Entry<P>(fullPrimitive, primitive, CryptoFormat.getOutputPrefix(key), key.getStatus(), key.getOutputPrefixType(), key.getKeyId(), key.getKeyData().getTypeUrl(), keyObject);
        ArrayList<Entry<P>> list = new ArrayList<Entry<P>>();
        list.add(entry);
        Prefix identifier = new Prefix(entry.getIdentifier());
        List existing = primitives.put(identifier, Collections.unmodifiableList(list));
        if (existing != null) {
            ArrayList newList = new ArrayList();
            newList.addAll(existing);
            newList.add(entry);
            primitives.put(identifier, Collections.unmodifiableList(newList));
        }
        return entry;
    }

    @Nullable
    public Entry<P> getPrimary() {
        return this.primary;
    }

    public boolean hasAnnotations() {
        return !this.annotations.toMap().isEmpty();
    }

    public MonitoringAnnotations getAnnotations() {
        return this.annotations;
    }

    public List<Entry<P>> getRawPrimitives() {
        return this.getPrimitive(CryptoFormat.RAW_PREFIX);
    }

    public List<Entry<P>> getPrimitive(byte[] identifier) {
        List<Entry<P>> found = (List<Entry<P>>)this.primitives.get(new Prefix(identifier));
        return found != null ? found : Collections.emptyList();
    }

    public Collection<List<Entry<P>>> getAll() {
        return this.primitives.values();
    }

    private PrimitiveSet(Class<P> primitiveClass) {
        this.primitives = new ConcurrentHashMap<Prefix, List<Entry<P>>>();
        this.primitiveClass = primitiveClass;
        this.annotations = MonitoringAnnotations.EMPTY;
        this.isMutable = true;
    }

    private PrimitiveSet(ConcurrentMap<Prefix, List<Entry<P>>> primitives, Entry<P> primary, MonitoringAnnotations annotations, Class<P> primitiveClass) {
        this.primitives = primitives;
        this.primary = primary;
        this.primitiveClass = primitiveClass;
        this.annotations = annotations;
        this.isMutable = false;
    }

    @Deprecated
    public static <P> PrimitiveSet<P> newPrimitiveSet(Class<P> primitiveClass) {
        return new PrimitiveSet<P>(primitiveClass);
    }

    @Deprecated
    public void setPrimary(Entry<P> primary) {
        if (!this.isMutable) {
            throw new IllegalStateException("setPrimary cannot be called on an immutable primitive set");
        }
        if (primary == null) {
            throw new IllegalArgumentException("the primary entry must be non-null");
        }
        if (primary.getStatus() != KeyStatusType.ENABLED) {
            throw new IllegalArgumentException("the primary entry has to be ENABLED");
        }
        List<Entry<P>> entries = this.getPrimitive(primary.getIdentifier());
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("the primary entry cannot be set to an entry which is not held by this primitive set");
        }
        this.primary = primary;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Entry<P> addPrimitive(P primitive, Keyset.Key key) throws GeneralSecurityException {
        if (!this.isMutable) {
            throw new IllegalStateException("addPrimitive cannot be called on an immutable primitive set");
        }
        if (key.getStatus() != KeyStatusType.ENABLED) {
            throw new GeneralSecurityException("only ENABLED key is allowed");
        }
        return PrimitiveSet.addEntryToMap(null, primitive, key, this.primitives);
    }

    public Class<P> getPrimitiveClass() {
        return this.primitiveClass;
    }

    public static <P> Builder<P> newBuilder(Class<P> primitiveClass) {
        return new Builder(primitiveClass);
    }

    public static class Builder<P> {
        private final Class<P> primitiveClass;
        private ConcurrentMap<Prefix, List<Entry<P>>> primitives = new ConcurrentHashMap<Prefix, List<Entry<P>>>();
        private Entry<P> primary;
        private MonitoringAnnotations annotations;

        @CanIgnoreReturnValue
        private Builder<P> addPrimitive(@Nullable P fullPrimitive, @Nullable P primitive, Keyset.Key key, boolean asPrimary) throws GeneralSecurityException {
            if (this.primitives == null) {
                throw new IllegalStateException("addPrimitive cannot be called after build");
            }
            if (fullPrimitive == null && primitive == null) {
                throw new GeneralSecurityException("at least one of the `fullPrimitive` or `primitive` must be set");
            }
            if (key.getStatus() != KeyStatusType.ENABLED) {
                throw new GeneralSecurityException("only ENABLED key is allowed");
            }
            Entry entry = PrimitiveSet.addEntryToMap(fullPrimitive, primitive, key, this.primitives);
            if (asPrimary) {
                if (this.primary != null) {
                    throw new IllegalStateException("you cannot set two primary primitives");
                }
                this.primary = entry;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<P> addPrimitive(P primitive, Keyset.Key key) throws GeneralSecurityException {
            return this.addPrimitive(null, primitive, key, false);
        }

        @CanIgnoreReturnValue
        public Builder<P> addPrimaryPrimitive(P primitive, Keyset.Key key) throws GeneralSecurityException {
            return this.addPrimitive(null, primitive, key, true);
        }

        @CanIgnoreReturnValue
        public Builder<P> addFullPrimitiveAndOptionalPrimitive(@Nullable P fullPrimitive, @Nullable P primitive, Keyset.Key key) throws GeneralSecurityException {
            return this.addPrimitive(fullPrimitive, primitive, key, false);
        }

        @CanIgnoreReturnValue
        public Builder<P> addPrimaryFullPrimitiveAndOptionalPrimitive(@Nullable P fullPrimitive, @Nullable P primitive, Keyset.Key key) throws GeneralSecurityException {
            return this.addPrimitive(fullPrimitive, primitive, key, true);
        }

        @CanIgnoreReturnValue
        public Builder<P> setAnnotations(MonitoringAnnotations annotations) {
            if (this.primitives == null) {
                throw new IllegalStateException("setAnnotations cannot be called after build");
            }
            this.annotations = annotations;
            return this;
        }

        public PrimitiveSet<P> build() throws GeneralSecurityException {
            if (this.primitives == null) {
                throw new IllegalStateException("build cannot be called twice");
            }
            PrimitiveSet output = new PrimitiveSet(this.primitives, this.primary, this.annotations, this.primitiveClass);
            this.primitives = null;
            return output;
        }

        private Builder(Class<P> primitiveClass) {
            this.primitiveClass = primitiveClass;
            this.annotations = MonitoringAnnotations.EMPTY;
        }
    }

    private static class Prefix
    implements Comparable<Prefix> {
        private final byte[] prefix;

        private Prefix(byte[] prefix) {
            this.prefix = Arrays.copyOf(prefix, prefix.length);
        }

        public int hashCode() {
            return Arrays.hashCode(this.prefix);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Prefix)) {
                return false;
            }
            Prefix other = (Prefix)o;
            return Arrays.equals(this.prefix, other.prefix);
        }

        @Override
        public int compareTo(Prefix o) {
            if (this.prefix.length != o.prefix.length) {
                return this.prefix.length - o.prefix.length;
            }
            for (int i = 0; i < this.prefix.length; ++i) {
                if (this.prefix[i] == o.prefix[i]) continue;
                return this.prefix[i] - o.prefix[i];
            }
            return 0;
        }

        public String toString() {
            return Hex.encode(this.prefix);
        }
    }

    public static final class Entry<P> {
        @Nullable
        private final P fullPrimitive;
        @Nullable
        private final P primitive;
        private final byte[] identifier;
        private final KeyStatusType status;
        private final OutputPrefixType outputPrefixType;
        private final int keyId;
        private final String keyType;
        private final Key key;

        Entry(@Nullable P fullPrimitive, @Nullable P primitive, byte[] identifier, KeyStatusType status, OutputPrefixType outputPrefixType, int keyId, String keyType, Key key) {
            this.fullPrimitive = fullPrimitive;
            this.primitive = primitive;
            this.identifier = Arrays.copyOf(identifier, identifier.length);
            this.status = status;
            this.outputPrefixType = outputPrefixType;
            this.keyId = keyId;
            this.keyType = keyType;
            this.key = key;
        }

        @Nullable
        public P getFullPrimitive() {
            return this.fullPrimitive;
        }

        @Nullable
        public P getPrimitive() {
            return this.primitive;
        }

        public KeyStatusType getStatus() {
            return this.status;
        }

        public OutputPrefixType getOutputPrefixType() {
            return this.outputPrefixType;
        }

        @Nullable
        public final byte[] getIdentifier() {
            if (this.identifier == null) {
                return null;
            }
            return Arrays.copyOf(this.identifier, this.identifier.length);
        }

        public int getKeyId() {
            return this.keyId;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public Key getKey() {
            return this.key;
        }

        @Nullable
        public Parameters getParameters() {
            if (this.key == null) {
                return null;
            }
            return this.key.getParameters();
        }
    }
}

