/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid.internal;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.hybrid.internal.HpkeDecrypt;
import com.google.crypto.tink.hybrid.internal.HpkePublicKeyManager;
import com.google.crypto.tink.hybrid.internal.HpkeUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.PrivateKeyTypeManager;
import com.google.crypto.tink.proto.HpkeAead;
import com.google.crypto.tink.proto.HpkeKdf;
import com.google.crypto.tink.proto.HpkeKem;
import com.google.crypto.tink.proto.HpkeKeyFormat;
import com.google.crypto.tink.proto.HpkeParams;
import com.google.crypto.tink.proto.HpkePrivateKey;
import com.google.crypto.tink.proto.HpkePublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.crypto.tink.subtle.X25519;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class HpkePrivateKeyManager
extends PrivateKeyTypeManager<HpkePrivateKey, HpkePublicKey> {
    public HpkePrivateKeyManager() {
        super(HpkePrivateKey.class, HpkePublicKey.class, new PrimitiveFactory<HybridDecrypt, HpkePrivateKey>(HybridDecrypt.class){

            @Override
            public HybridDecrypt getPrimitive(HpkePrivateKey recipientPrivateKey) throws GeneralSecurityException {
                return HpkeDecrypt.createHpkeDecrypt(recipientPrivateKey);
            }
        });
    }

    public static void registerPair(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerAsymmetricKeyManagers(new HpkePrivateKeyManager(), new HpkePublicKeyManager(), newKeyAllowed);
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HpkePrivateKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public HpkePublicKey getPublicKey(HpkePrivateKey key) {
        return key.getPublicKey();
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    public HpkePrivateKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return HpkePrivateKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(HpkePrivateKey key) throws GeneralSecurityException {
        if (key.getPrivateKey().isEmpty()) {
            throw new GeneralSecurityException("Private key is empty.");
        }
        if (!key.hasPublicKey()) {
            throw new GeneralSecurityException("Missing public key.");
        }
        Validators.validateVersion(key.getVersion(), this.getVersion());
        HpkeUtil.validateParams(key.getPublicKey().getParams());
    }

    @Override
    public KeyTypeManager.KeyFactory<HpkeKeyFormat, HpkePrivateKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<HpkeKeyFormat, HpkePrivateKey>(HpkeKeyFormat.class){

            @Override
            public void validateKeyFormat(HpkeKeyFormat keyFormat) throws GeneralSecurityException {
                HpkeUtil.validateParams(keyFormat.getParams());
            }

            @Override
            public HpkeKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return HpkeKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public HpkePrivateKey createKey(HpkeKeyFormat keyFormat) throws GeneralSecurityException {
                byte[] publicKeyBytes;
                byte[] privateKeyBytes;
                switch (keyFormat.getParams().getKem()) {
                    case DHKEM_X25519_HKDF_SHA256: {
                        privateKeyBytes = X25519.generatePrivateKey();
                        publicKeyBytes = X25519.publicFromPrivate(privateKeyBytes);
                        break;
                    }
                    case DHKEM_P256_HKDF_SHA256: 
                    case DHKEM_P384_HKDF_SHA384: 
                    case DHKEM_P521_HKDF_SHA512: {
                        EllipticCurves.CurveType curveType = HpkeUtil.nistHpkeKemToCurve(keyFormat.getParams().getKem());
                        KeyPair keyPair = EllipticCurves.generateKeyPair(curveType);
                        publicKeyBytes = EllipticCurves.pointEncode(curveType, EllipticCurves.PointFormatType.UNCOMPRESSED, ((ECPublicKey)keyPair.getPublic()).getW());
                        privateKeyBytes = ((ECPrivateKey)keyPair.getPrivate()).getS().toByteArray();
                        break;
                    }
                    default: {
                        throw new GeneralSecurityException("Invalid KEM");
                    }
                }
                HpkePublicKey publicKey = (HpkePublicKey)HpkePublicKey.newBuilder().setVersion(HpkePrivateKeyManager.this.getVersion()).setParams(keyFormat.getParams()).setPublicKey(ByteString.copyFrom(publicKeyBytes)).build();
                return (HpkePrivateKey)HpkePrivateKey.newBuilder().setVersion(HpkePrivateKeyManager.this.getVersion()).setPublicKey(publicKey).setPrivateKey(ByteString.copyFrom(privateKeyBytes)).build();
            }

            @Override
            public Map<String, KeyTypeManager.KeyFactory.KeyFormat<HpkeKeyFormat>> keyFormats() {
                HashMap<String, KeyTypeManager.KeyFactory.KeyFormat> result = new HashMap<String, KeyTypeManager.KeyFactory.KeyFormat>();
                result.put("DHKEM_X25519_HKDF_SHA256_HKDF_SHA256_AES_128_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_X25519_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_X25519_HKDF_SHA256_HKDF_SHA256_AES_128_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_X25519_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_X25519_HKDF_SHA256_HKDF_SHA256_AES_256_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_X25519_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_X25519_HKDF_SHA256_HKDF_SHA256_AES_256_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_X25519_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_X25519_HKDF_SHA256_HKDF_SHA256_CHACHA20_POLY1305", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_X25519_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.CHACHA20_POLY1305, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_X25519_HKDF_SHA256_HKDF_SHA256_CHACHA20_POLY1305_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_X25519_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.CHACHA20_POLY1305, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_P256_HKDF_SHA256_HKDF_SHA256_AES_128_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P256_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_P256_HKDF_SHA256_HKDF_SHA256_AES_128_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P256_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_P256_HKDF_SHA256_HKDF_SHA256_AES_256_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P256_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_P256_HKDF_SHA256_HKDF_SHA256_AES_256_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P256_HKDF_SHA256, HpkeKdf.HKDF_SHA256, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_P384_HKDF_SHA384_HKDF_SHA384_AES_128_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P384_HKDF_SHA384, HpkeKdf.HKDF_SHA384, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_P384_HKDF_SHA384_HKDF_SHA384_AES_128_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P384_HKDF_SHA384, HpkeKdf.HKDF_SHA384, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_P384_HKDF_SHA384_HKDF_SHA384_AES_256_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P384_HKDF_SHA384, HpkeKdf.HKDF_SHA384, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_P384_HKDF_SHA384_HKDF_SHA384_AES_256_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P384_HKDF_SHA384, HpkeKdf.HKDF_SHA384, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_P521_HKDF_SHA512_HKDF_SHA512_AES_128_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P521_HKDF_SHA512, HpkeKdf.HKDF_SHA512, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_P521_HKDF_SHA512_HKDF_SHA512_AES_128_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P521_HKDF_SHA512, HpkeKdf.HKDF_SHA512, HpkeAead.AES_128_GCM, KeyTemplate.OutputPrefixType.RAW));
                result.put("DHKEM_P521_HKDF_SHA512_HKDF_SHA512_AES_256_GCM", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P521_HKDF_SHA512, HpkeKdf.HKDF_SHA512, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.TINK));
                result.put("DHKEM_P521_HKDF_SHA512_HKDF_SHA512_AES_256_GCM_RAW", HpkePrivateKeyManager.createKeyFormat(HpkeKem.DHKEM_P521_HKDF_SHA512, HpkeKdf.HKDF_SHA512, HpkeAead.AES_256_GCM, KeyTemplate.OutputPrefixType.RAW));
                return Collections.unmodifiableMap(result);
            }
        };
    }

    private static KeyTypeManager.KeyFactory.KeyFormat<HpkeKeyFormat> createKeyFormat(HpkeKem kem, HpkeKdf kdf, HpkeAead aead, KeyTemplate.OutputPrefixType prefixType) {
        HpkeParams params = (HpkeParams)HpkeParams.newBuilder().setKem(kem).setKdf(kdf).setAead(aead).build();
        return new KeyTypeManager.KeyFactory.KeyFormat<HpkeKeyFormat>((HpkeKeyFormat)HpkeKeyFormat.newBuilder().setParams(params).build(), prefixType);
    }
}

