/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.gcpkms;

import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudkms.v1.model.DecryptRequest;
import com.google.api.services.cloudkms.v1.model.DecryptResponse;
import com.google.api.services.cloudkms.v1.model.EncryptRequest;
import com.google.api.services.cloudkms.v1.model.EncryptResponse;
import com.google.crypto.tink.Aead;
import java.io.IOException;
import java.security.GeneralSecurityException;

public final class GcpKmsAead
implements Aead {
    private final CloudKMS kmsClient;
    private final String keyName;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public GcpKmsAead(CloudKMS kmsClient, String keyName) {
        this.kmsClient = kmsClient;
        this.keyName = keyName;
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        try {
            EncryptRequest request = new EncryptRequest().encodePlaintext(plaintext).encodeAdditionalAuthenticatedData(associatedData);
            EncryptResponse response = (EncryptResponse)this.kmsClient.projects().locations().keyRings().cryptoKeys().encrypt(this.keyName, request).execute();
            return GcpKmsAead.toNonNullableByteArray(response.decodeCiphertext());
        }
        catch (IOException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            DecryptRequest request = new DecryptRequest().encodeCiphertext(ciphertext).encodeAdditionalAuthenticatedData(associatedData);
            DecryptResponse response = (DecryptResponse)this.kmsClient.projects().locations().keyRings().cryptoKeys().decrypt(this.keyName, request).execute();
            return GcpKmsAead.toNonNullableByteArray(response.decodePlaintext());
        }
        catch (IOException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }

    private static byte[] toNonNullableByteArray(byte[] data) {
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return data;
    }
}

