/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.MapKey;
import dagger.android.AndroidInjectionKey;
import dagger.android.AndroidInjector;
import dagger.android.processor.AndroidMapKeys;
import dagger.android.shaded.auto.common.AnnotationMirrors;
import dagger.android.shaded.auto.common.BasicAnnotationProcessor;
import dagger.android.shaded.auto.common.MoreElements;
import dagger.multibindings.ClassKey;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Elements elements;
    private final Types types;
    private final Messager messager;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.builder().add(AndroidInjectionKey.class).add(ClassKey.class).build();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        elementsByAnnotation.entries().forEach(entry -> {
            try {
                this.validateMethod((Class)entry.getKey(), MoreElements.asExecutable((Element)entry.getValue()));
            }
            catch (TypeNotPresentException e) {
                deferredElements.add((Object)((Element)entry.getValue()));
            }
        });
        return deferredElements.build();
    }

    private void validateMethod(Class<? extends Annotation> annotation, ExecutableElement method) {
        SuppressWarnings suppressedWarnings;
        if (!AnnotationMirrors.getAnnotatedAnnotations(method, Qualifier.class).isEmpty()) {
            return;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(returnType), this.factoryElement().asType())) {
            return;
        }
        if (!(AnnotationMirrors.getAnnotatedAnnotations(method, Scope.class).isEmpty() || (suppressedWarnings = method.getAnnotation(SuppressWarnings.class)) != null && ImmutableSet.copyOf((Object[])suppressedWarnings.value()).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            AnnotationMirror mapKeyAnnotation = (AnnotationMirror)Iterables.getOnlyElement(AnnotationMirrors.getAnnotatedAnnotations(method, MapKey.class));
            TypeElement mapKeyValueElement = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(mapKeyAnnotation).get());
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s.", AndroidInjector.Factory.class.getCanonicalName(), mapKeyValueElement.getQualifiedName()), method);
        }
        this.validateReturnType(method);
        if (MoreElements.isAnnotationPresent(method, Binds.class) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateReturnType(ExecutableElement method) {
        DeclaredType requiredReturnType;
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isSameType(returnType, requiredReturnType = this.injectorFactoryOf(this.types.getWildcardType(null, null)))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should bind %s, not %s. See https://dagger.dev/android", method, requiredReturnType, returnType), method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(Class<? extends Annotation> annotation, ExecutableElement method) {
        AnnotationMirror annotationMirror;
        TypeMirror mapKeyType;
        TypeMirror parameterType = ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType();
        if (!this.types.isAssignable(parameterType, this.injectorFactoryOf(mapKeyType = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(method, annotation).get()).get()).asType()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", parameterType, mapKeyType), method, annotationMirror);
        }
    }

    private DeclaredType injectorFactoryOf(TypeMirror implementationType) {
        return this.types.getDeclaredType(this.factoryElement(), implementationType);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(AndroidInjector.Factory.class.getCanonicalName());
    }
}

