/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import dagger.MapKey;
import dagger.android.AndroidInjector;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.processor.AndroidMapKeys;
import dagger.android.shaded.auto.common.AnnotationMirrors;
import dagger.android.shaded.auto.common.MoreTypes;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.Key;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Formatter;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class DuplicateAndroidInjectorsChecker
implements BindingGraphPlugin {
    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        for (Binding binding : graph.bindings()) {
            if (!this.isDispatchingAndroidInjector(binding)) continue;
            this.validateMapKeyUniqueness(binding, graph, diagnosticReporter);
        }
    }

    private boolean isDispatchingAndroidInjector(Binding binding) {
        Key key = binding.key();
        return MoreTypes.isTypeOf(DispatchingAndroidInjector.class, key.type()) && !key.qualifier().isPresent();
    }

    private void validateMapKeyUniqueness(Binding dispatchingAndroidInjector, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        ImmutableSet injectorFactories = this.injectorMapDependencies(dispatchingAndroidInjector, graph).flatMap(injectorFactoryMap -> graph.requestedBindings(injectorFactoryMap).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf));
        ImmutableListMultimap.Builder mapKeyIndex = ImmutableListMultimap.builder();
        for (Binding injectorFactory : injectorFactories) {
            AnnotationMirror mapKey = this.mapKey(injectorFactory).get();
            Optional<String> injectedType2 = AndroidMapKeys.injectedTypeFromMapKey(mapKey);
            if (injectedType2.isPresent()) {
                mapKeyIndex.put((Object)injectedType2.get(), (Object)injectorFactory);
                continue;
            }
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)injectorFactory, "Unrecognized class: %s", (Object)mapKey, new Object[0]);
        }
        Map duplicates = Maps.filterValues((Map)Multimaps.asMap((ListMultimap)mapKeyIndex.build()), bindings -> bindings.size() > 1);
        if (!duplicates.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Multiple injector factories bound for the same type:\n");
            Formatter formatter = new Formatter(errorMessage);
            duplicates.forEach((injectedType, duplicateFactories) -> {
                formatter.format("  %s:\n", injectedType);
                duplicateFactories.forEach(duplicate -> formatter.format("    %s\n", duplicate));
            });
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)dispatchingAndroidInjector, errorMessage.toString());
        }
    }

    private Stream<Binding> injectorMapDependencies(Binding binding, BindingGraph graph) {
        return graph.requestedBindings(binding).stream().filter(requestedBinding -> requestedBinding.kind().equals((Object)BindingKind.MULTIBOUND_MAP)).filter(requestedBinding -> {
            TypeMirror valueType = MoreTypes.asDeclared(requestedBinding.key().type()).getTypeArguments().get(1);
            if (!MoreTypes.isTypeOf(Provider.class, valueType) || !valueType.getKind().equals((Object)TypeKind.DECLARED)) {
                return false;
            }
            TypeMirror providedType = MoreTypes.asDeclared(valueType).getTypeArguments().get(0);
            return MoreTypes.isTypeOf(AndroidInjector.Factory.class, providedType);
        });
    }

    private Optional<AnnotationMirror> mapKey(Binding binding) {
        return binding.bindingElement().map(bindingElement -> AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class)).flatMap(annotations -> annotations.isEmpty() ? Optional.empty() : Optional.of((AnnotationMirror)Iterables.getOnlyElement((Iterable)annotations)));
    }

    public String pluginName() {
        return "Dagger/Android/DuplicateAndroidInjectors";
    }
}

