/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.shaded.auto.common;

import com.google.common.base.Preconditions;
import dagger.android.shaded.auto.common.MoreTypes;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class SimpleTypeAnnotationValue
implements AnnotationValue {
    private final TypeMirror value;

    private SimpleTypeAnnotationValue(TypeMirror value) {
        Preconditions.checkArgument((value.getKind().isPrimitive() || value.getKind().equals((Object)TypeKind.DECLARED) || value.getKind().equals((Object)TypeKind.ARRAY) ? 1 : 0) != 0, (String)"value must be a primitive, array, or declared type, but was %s (%s)", (Object)((Object)value.getKind()), (Object)value);
        if (value.getKind().equals((Object)TypeKind.DECLARED)) {
            Preconditions.checkArgument((boolean)MoreTypes.asDeclared(value).getTypeArguments().isEmpty(), (String)"value must not be a parameterized type: %s", (Object)value);
        }
        this.value = value;
    }

    public static AnnotationValue of(TypeMirror value) {
        return new SimpleTypeAnnotationValue(value);
    }

    @Override
    public TypeMirror getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.value);
        return new StringBuilder(6 + String.valueOf(string).length()).append(string).append(".class").toString();
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> visitor, P parameter) {
        return visitor.visitType(this.getValue(), parameter);
    }
}

